/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.ProjectBuilder;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapUtil;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.ProjectBuilder.PhoneGapProjectTemplateGenerator;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapProjectPeer
implements WebProjectGenerator.GeneratorPeer<PhoneGapProjectTemplateGenerator.PhoneGapProjectSettings> {
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TextFieldWithHistoryWithBrowseButton myExecutablePathField;
    private final ConcurrentMap<String, Boolean> myValidateCache = ContainerUtil.newConcurrentMap();

    PhoneGapProjectPeer() {
    }

    @NotNull
    public JComponent getComponent() {
        this.setFields();
        JPanel panel = FormBuilder.createFormBuilder().addLabeledComponent(PhoneGapBundle.message("phonegap.project.builder.label", new Object[0]), (JComponent)this.myExecutablePathField).getPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)600, (int)40));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectPeer", "getComponent"));
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectPeer", "buildUI"));
        }
        this.setFields();
        settingsStep.addSettingsField(PhoneGapBundle.message("phonegap.project.builder.label", new Object[0]), (JComponent)this.myExecutablePathField);
    }

    @NotNull
    public PhoneGapProjectTemplateGenerator.PhoneGapProjectSettings getSettings() {
        PhoneGapProjectTemplateGenerator.PhoneGapProjectSettings settings = new PhoneGapProjectTemplateGenerator.PhoneGapProjectSettings();
        settings.setExecutable(this.myExecutablePathField.getText());
        PhoneGapProjectTemplateGenerator.PhoneGapProjectSettings phoneGapProjectSettings = settings;
        if (phoneGapProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectPeer", "getSettings"));
        }
        return phoneGapProjectSettings;
    }

    private void setFields() {
        this.myExecutablePathField = PhoneGapUtil.createPhoneGapExecutableTextField(null);
    }

    @Nullable
    public ValidationInfo validate() {
        boolean error;
        String path = this.myExecutablePathField.getText();
        if (this.myValidateCache.containsKey(path)) {
            error = (Boolean)this.myValidateCache.get(path);
        } else {
            try {
                if (StringUtil.isEmpty((String)path)) {
                    return new ValidationInfo(PhoneGapBundle.message("phonegap.incorrect.path.executable", new Object[0]));
                }
                new PhoneGapCommandLine(path, null).version();
                error = false;
            }
            catch (Exception e) {
                error = true;
            }
            this.myValidateCache.put(path, error);
        }
        return error ? new ValidationInfo(PhoneGapBundle.message("phonegap.incorrect.path.error", new Object[0])) : null;
    }

    public boolean isBackgroundJobRunning() {
        return false;
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectPeer", "addSettingsStateListener"));
        }
        this.myStateListeners.add(listener);
    }
}

