/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.ProjectBuilder;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapProjectComponent;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.ProjectBuilder.PhoneGapProjectPeer;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapConfigurationType;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapRunConfiguration;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.PhoneGapIcons;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapProjectTemplateGenerator
extends WebProjectTemplate<PhoneGapProjectSettings> {
    private static final Logger LOG = Logger.getInstance(PhoneGapProjectTemplateGenerator.class);

    @Nls
    @NotNull
    public String getName() {
        String string = PhoneGapBundle.message("phonegap.app.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "getName"));
        }
        return string;
    }

    public String getDescription() {
        return PhoneGapBundle.message("phonegap.app.name.titile", new Object[0]);
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull PhoneGapProjectSettings settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "generateProject"));
        }
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$generateProject$0"));
                }
                if (baseDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$generateProject$0"));
                }
                try {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    indicator.setText("Creating...");
                    File tempProject = this.createTemp();
                    PhoneGapCommandLine commandLine = new PhoneGapCommandLine(settings.getExecutable(), tempProject.getPath(), settings.getOptions());
                    if (!commandLine.isCorrectExecutable()) {
                        PhoneGapProjectTemplateGenerator.showErrorMessage("Incorrect path");
                        return;
                    }
                    commandLine.createNewProject(settings.name(), indicator);
                    Object[] array = tempProject.listFiles();
                    if (array != null && array.length != 0) {
                        File from = (File)ContainerUtil.getFirstItem((List)ContainerUtil.newArrayList((Object[])array));
                        assert (from != null);
                        FileUtil.copyDir((File)from, (File)new File(baseDir.getPath()));
                        this.deleteTemp(tempProject);
                    } else {
                        PhoneGapProjectTemplateGenerator.showErrorMessage(PhoneGapBundle.message("phonegap.project.template.create.no.files", new Object[0]) + " " + tempProject.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, PhoneGapBundle.message("phonegap.project.template.create.title", new Object[0]), false, project);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$generateProject$2"));
                }
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$generateProject$2"));
                }
                if (baseDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$generateProject$2"));
                }
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
                propertiesComponent.setValue(PhoneGapSettings.PHONEGAP_WORK_DIRECTORY, project.getBasePath());
                PhoneGapSettings.State state = PhoneGapSettings.getInstance().getState();
                if (!StringUtil.equals((CharSequence)settings.getExecutable(), (CharSequence)state.getExecutablePath())) {
                    PhoneGapSettings.getInstance().loadState(new PhoneGapSettings.State(settings.executable, state.repositoriesList));
                }
                VfsUtil.markDirty((boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{project.getBaseDir()});
                PhoneGapProjectTemplateGenerator.createRunConfiguration(project, settings);
                baseDir.refresh(true, true, () -> {
                    VirtualFile platformsFolder;
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "lambda$null$1"));
                    }
                    if (PhoneGapSettings.getInstance().isExcludePlatformFolder() && (platformsFolder = project.getBaseDir().findChild("platforms")) != null) {
                        PhoneGapProjectComponent.excludePlatformFolder(project, platformsFolder);
                    }
                });
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            PhoneGapProjectTemplateGenerator.showErrorMessage(e.getMessage());
        }
    }

    private static void createRunConfiguration(@NotNull Project project, @NotNull PhoneGapProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "createRunConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "createRunConfiguration"));
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        PhoneGapConfigurationType configurationType = (PhoneGapConfigurationType)ConfigurationTypeUtil.findConfigurationType(PhoneGapConfigurationType.class);
        RunnerAndConfigurationSettings configuration = runManager.createRunConfiguration(PhoneGapBundle.message("phonegap.project.template.create.run.configuration.title", new Object[0]), configurationType.getConfigurationFactories()[0]);
        PhoneGapRunConfiguration runConfiguration = (PhoneGapRunConfiguration)configuration.getConfiguration();
        runConfiguration.setExecutable(settings.executable);
        runConfiguration.setWorkDir(project.getBasePath());
        runConfiguration.setPlatform(SystemInfo.isMac ? "ios" : "android");
        runConfiguration.setCommand("emulate");
        runManager.addConfiguration(configuration, false);
        runManager.setSelectedConfiguration(configuration);
    }

    protected File createTemp() throws IOException {
        return FileUtil.createTempDirectory((String)"intellij-phonegap-generator", null, (boolean)false);
    }

    protected void deleteTemp(File tempProject) {
        if (!FileUtil.delete((File)tempProject)) {
            LOG.warn("Cannot delete " + tempProject);
        } else {
            LOG.info("Successfully deleted " + tempProject);
        }
    }

    @NotNull
    public PhoneGapProjectPeer createPeer() {
        PhoneGapProjectPeer phoneGapProjectPeer = new PhoneGapProjectPeer();
        if (phoneGapProjectPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "createPeer"));
        }
        return phoneGapProjectPeer;
    }

    public Icon getIcon() {
        return PhoneGapIcons.PhonegapIntegration;
    }

    private static void showErrorMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/ProjectBuilder/PhoneGapProjectTemplateGenerator", "showErrorMessage"));
        }
        String fullMessage = PhoneGapBundle.message("phonegap.project.template.error.text", message);
        String title = PhoneGapBundle.message("phonegap.project.template.error.notification.title", new Object[0]);
        Notifications.Bus.notify((Notification)new Notification(PhoneGapBundle.message("phonegap.project.template.error.notification", new Object[0]), title, fullMessage, NotificationType.ERROR));
    }

    static final class PhoneGapProjectSettings {
        private final String name = "example";
        @Nullable
        private String executable;
        @Nullable
        private String options;

        PhoneGapProjectSettings() {
        }

        public void setExecutable(@Nullable String executable) {
            this.executable = executable;
        }

        public void setOptions(@Nullable String options) {
            this.options = options;
        }

        @Nullable
        public String getExecutable() {
            return this.executable;
        }

        @Nullable
        public String getOptions() {
            return StringUtil.nullize((String)this.options, (boolean)true);
        }

        public String name() {
            return "example";
        }
    }
}

