/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapTargets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhoneGapAndroidTargets
extends PhoneGapTargets {
    public static final Function<String, String> PARSER_VIRTUAL_DEVICES = s -> {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (PhoneGapAndroidTargets.isAndroidExcludedStrings(s)) {
            return null;
        }
        return s.trim();
    };
    public static final Function<String, String> PARSER_DEVICES = s -> {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (PhoneGapAndroidTargets.isAndroidExcludedStrings(s)) {
            return null;
        }
        return s.split("\t")[0].trim();
    };

    public PhoneGapAndroidTargets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapAndroidTargets", "<init>"));
        }
        super(project);
    }

    @NotNull
    public static String getAndroidName() {
        String string = SystemInfo.isWindows ? "android.bat" : "android";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapAndroidTargets", "getAndroidName"));
        }
        return string;
    }

    private static String getAdbName() {
        return SystemInfo.isWindows ? "adb.exe" : "adb";
    }

    private static boolean isAndroidExcludedStrings(String device) {
        return device.startsWith("List of devices attached") || device.startsWith("* ") && device.endsWith(" *");
    }

    @Override
    @NotNull
    protected List<String> listDevicesNonCached() {
        List<String> list = this.list(PhoneGapAndroidTargets.getAdbName(), PARSER_DEVICES, false, "devices");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapAndroidTargets", "listDevicesNonCached"));
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> listVirtualDevicesNonCached() {
        List<String> list = this.list(PhoneGapAndroidTargets.getAndroidName(), PARSER_VIRTUAL_DEVICES, false, "-v", "list", "avd", "-c");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapAndroidTargets", "listVirtualDevicesNonCached"));
        }
        return list;
    }

    @Override
    @NotNull
    public String platform() {
        if ("android" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapAndroidTargets", "platform"));
        }
        return "android";
    }
}

