/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapCommandLine {
    private static final Logger LOGGER = Logger.getInstance(PhoneGapCommandLine.class);
    public static final String INFO_PHONEGAP = "the following plugins are installed";
    public static final String PLATFORM_PHONEGAP = "phonegap";
    public static final String PLATFORM_CORDOVA = "cordova";
    public static final String PLATFORM_IONIC = "ionic";
    public static final String COMMAND_RUN = "run";
    public static final String COMMAND_PREPARE = "prepare";
    public static final String COMMAND_EMULATE = "emulate";
    public static final String COMMAND_SERVE = "serve";
    public static final String COMMAND_REMOTE_RUN = "remote run";
    public static final String COMMAND_REMOTE_BUILD = "remote build";
    public static final long PROCESS_TIMEOUT = TimeUnit.SECONDS.toMillis(120L);
    @Nullable
    private final String myWorkDir;
    @NotNull
    private final String myPath;
    @Nullable
    private String version;
    private boolean myIsCorrect;
    private boolean myPassParentEnv;
    private Map<String, String> myEnv;
    private final String myOptions;
    public static final Function<String, String> REMOVE_QUOTE_AND_TRIM = s -> s.replace("'", "").trim();

    public boolean isPassParentEnv() {
        return this.myPassParentEnv;
    }

    public Map<String, String> getEnv() {
        return this.myEnv;
    }

    @Nullable
    public String getWorkDir() {
        return this.myWorkDir;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "getPath"));
        }
        return string;
    }

    public void setPassParentEnv(boolean passParentEnv) {
        this.myPassParentEnv = passParentEnv;
    }

    public void setEnv(Map<String, String> env) {
        this.myEnv = env;
    }

    public PhoneGapCommandLine(@NotNull String path, @Nullable String dir, boolean isPassEnv, Map<String, String> env) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "<init>"));
        }
        this.myIsCorrect = true;
        this.myPassParentEnv = true;
        this.myEnv = ContainerUtil.newHashMap();
        this.myWorkDir = dir;
        this.myPath = path;
        this.myEnv = env;
        this.myPassParentEnv = isPassEnv;
        this.myOptions = null;
        try {
            this.version = this.getInnerVersion(this.myPath, "--version").replace("\"", "").trim();
        }
        catch (Exception e) {
            this.version = null;
            LOGGER.debug(e.getMessage(), (Throwable)e);
            this.myIsCorrect = false;
        }
    }

    public PhoneGapCommandLine(@NotNull String path, @Nullable String dir, @Nullable String options) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "<init>"));
        }
        this.myIsCorrect = true;
        this.myPassParentEnv = true;
        this.myEnv = ContainerUtil.newHashMap();
        this.myWorkDir = dir;
        this.myPath = path;
        this.myOptions = options;
        try {
            this.version = this.getInnerVersion(this.myPath, "--version").replace("\"", "").trim();
        }
        catch (Exception e) {
            this.version = null;
            LOGGER.debug(e.getMessage(), (Throwable)e);
            this.myIsCorrect = false;
        }
    }

    public PhoneGapCommandLine(@NotNull String path, @Nullable String dir) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "<init>"));
        }
        this(path, dir, null);
    }

    public ProcessOutput platformAdd(@NotNull String platform) throws ExecutionException {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "platformAdd"));
        }
        String trimmedPlatform = platform.trim();
        ProcessOutput output = this.executeAndGetOut(new String[]{this.myPath, "platform", "add", trimmedPlatform});
        String message = "Platform " + trimmedPlatform + " already added";
        if (output.getExitCode() != 0 && (StringUtil.contains((CharSequence)output.getStderr(), (CharSequence)message) || StringUtil.contains((CharSequence)output.getStdout(), (CharSequence)message))) {
            return new ProcessOutput(0);
        }
        return output;
    }

    public boolean isCorrectExecutable() {
        return this.myIsCorrect;
    }

    public String version() {
        return this.version;
    }

    public void pluginAdd(String fqn) {
        this.executeVoidCommand(this.myPath, "plugin", "add", fqn);
    }

    public void pluginRemove(String fqn) {
        this.executeVoidCommand(this.myPath, "plugin", "remove", fqn);
    }

    public ProcessOutput pluginListRaw() throws ExecutionException {
        return this.executeAndGetOut(new String[]{this.myPath, "plugin", "list"});
    }

    public String getPlatformName() {
        return this.isIonic() ? "Ionic" : "PhoneGap/Cordova";
    }

    public boolean isOld() {
        if (this.isIonic()) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.version) || !Character.isDigit(this.version.charAt(0))) {
            return false;
        }
        try {
            String[] split = this.version.split("\\.");
            int first = Integer.parseInt(split[0]);
            if (first > 3) {
                return false;
            }
            if (first == 3) {
                return split.length < 2 || Integer.parseInt(split[1]) < 5;
            }
            return first < 3;
        }
        catch (RuntimeException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @NotNull
    public List<String> pluginList() {
        List<String> list;
        try {
            String out = this.executeAndReturnResult(this.myPath, "plugin", "list").trim();
            list = PhoneGapCommandLine.parsePluginList(out);
        }
        catch (RuntimeException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "pluginList"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "pluginList"));
        }
        return list;
    }

    private OSProcessHandler serve(String extraArg) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])new String[]{this.myPath, COMMAND_SERVE}), PhoneGapCommandLine.parseArgs(extraArg)));
        commandLine.withWorkDirectory(this.myWorkDir);
        return new KillableColoredProcessHandler(commandLine, true);
    }

    @NotNull
    public OSProcessHandler runCommand(@NotNull String command, @NotNull String platform, @Nullable String target, @Nullable String extraArgs) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
        }
        if (COMMAND_RUN.equals(command)) {
            OSProcessHandler oSProcessHandler = this.executeStandardCommand(platform, target, extraArgs, COMMAND_RUN);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        if (COMMAND_EMULATE.equals(command)) {
            OSProcessHandler oSProcessHandler = this.emulate(platform, target, extraArgs);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        if (COMMAND_SERVE.equals(command)) {
            OSProcessHandler oSProcessHandler = this.serve(extraArgs);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        if (COMMAND_REMOTE_RUN.equals(command)) {
            OSProcessHandler oSProcessHandler = this.remoteRun(platform, extraArgs);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        if (COMMAND_REMOTE_BUILD.equals(command)) {
            OSProcessHandler oSProcessHandler = this.remoteBuild(platform, extraArgs);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        if (COMMAND_PREPARE.equals(command)) {
            OSProcessHandler oSProcessHandler = this.executeStandardCommand(platform, target, extraArgs, COMMAND_PREPARE);
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "runCommand"));
            }
            return oSProcessHandler;
        }
        throw new IllegalStateException("Unsupported command");
    }

    private OSProcessHandler remoteRun(@NotNull String platform, @Nullable String extraArg) throws ExecutionException {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "remoteRun"));
        }
        return this.createProcessHandler(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])new String[]{this.myPath, "remote", COMMAND_RUN, platform}), PhoneGapCommandLine.parseArgs(extraArg)));
    }

    private OSProcessHandler remoteBuild(@NotNull String platform, @Nullable String extraArg) throws ExecutionException {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "remoteBuild"));
        }
        return this.createProcessHandler(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])new String[]{this.myPath, "remote", "build", platform}), PhoneGapCommandLine.parseArgs(extraArg)));
    }

    private OSProcessHandler emulate(@NotNull String platform, @Nullable String target, @Nullable String extraArg) throws ExecutionException {
        Object[] command;
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", COMMAND_EMULATE));
        }
        if (!StringUtil.isEmpty((String)target)) {
            target = target.trim();
            command = new String[]{this.myPath, COMMAND_RUN, "--emulator", "--target=" + target, platform};
        } else {
            command = new String[]{this.myPath, COMMAND_RUN, "--emulator", platform};
        }
        return this.createProcessHandler(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])command), PhoneGapCommandLine.parseArgs(extraArg)));
    }

    private OSProcessHandler executeStandardCommand(@NotNull String platform, @Nullable String target, @Nullable String extraArg, @NotNull String commandToExecute) throws ExecutionException {
        Object[] command;
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "executeStandardCommand"));
        }
        if (commandToExecute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandToExecute", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapCommandLine", "executeStandardCommand"));
        }
        if (!StringUtil.isEmpty((String)target)) {
            target = target.trim();
            command = new String[]{this.myPath, commandToExecute, "--target=" + target, platform};
        } else {
            command = new String[]{this.myPath, commandToExecute, platform};
        }
        return this.createProcessHandler(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])command), PhoneGapCommandLine.parseArgs(extraArg)));
    }

    public boolean needAddPlatform() {
        if (!this.isPhoneGap()) {
            return true;
        }
        return PhoneGapCommandLine.isPhonegapAfter363(this.version);
    }

    static boolean isPhonegapAfter363(String version) {
        if (StringUtil.isEmpty((String)version)) {
            return true;
        }
        return StringUtil.compareVersionNumbers((String)version, (String)"3.6.3") >= 0;
    }

    public void createNewProject(String name, @Nullable ProgressIndicator indicator) throws Exception {
        String command;
        String string = command = this.isIonic() ? "start" : "create";
        if (this.myOptions == null) {
            this.executeVoidCommand(indicator, this.myPath, command, name);
        } else {
            String[] resultCommand = ArrayUtil.mergeArrays((String[])new String[]{this.myPath, command, name, this.myOptions}, (String[])new String[0]);
            this.executeVoidCommand(indicator, resultCommand);
        }
    }

    private boolean isPhoneGap() {
        assert (this.myWorkDir != null);
        Boolean isPhoneGapByName = PhoneGapCommandLine.isPhoneGapExecutableByPath(this.myPath);
        if (isPhoneGapByName != null) {
            return isPhoneGapByName;
        }
        String s = this.executeAndReturnResult(this.myPath);
        return s.contains(PLATFORM_PHONEGAP);
    }

    @Nullable
    public static Boolean isPhoneGapExecutableByPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.getName().contains(PLATFORM_IONIC)) {
            return false;
        }
        if (file.getName().contains(PLATFORM_CORDOVA)) {
            return false;
        }
        if (file.getName().contains(PLATFORM_PHONEGAP)) {
            return true;
        }
        return null;
    }

    private boolean isIonic() {
        File file = new File(this.myPath);
        if (file.getName().contains(PLATFORM_IONIC)) {
            return true;
        }
        if (file.getName().contains(PLATFORM_PHONEGAP)) {
            return false;
        }
        if (file.getName().contains(PLATFORM_CORDOVA)) {
            return false;
        }
        if (this.myWorkDir != null) {
            String s = this.executeAndReturnResult(this.myPath);
            return s.contains(PLATFORM_IONIC);
        }
        return false;
    }

    static List<String> parsePluginList(String out) {
        List plugins;
        String item;
        if (StringUtil.isEmpty((String)out) || StringUtil.contains((CharSequence)out.toLowerCase(Locale.getDefault()), (CharSequence)"no plugins")) {
            return ContainerUtil.newArrayList();
        }
        if (out.startsWith("[") && out.endsWith("]")) {
            out = out.substring(1, out.length() - 1);
            return ContainerUtil.map((Object[])out.split(","), REMOVE_QUOTE_AND_TRIM);
        }
        if (out.startsWith("[")) {
            out = out.replaceAll("\\[(.*?)\\]", "");
        }
        if ((item = (String)ContainerUtil.getFirstItem((List)(plugins = ContainerUtil.map((Object[])out.split("\n"), (Function)StringUtil.TRIMMER)))) != null && item.contains(INFO_PHONEGAP)) {
            plugins = plugins.subList(1, plugins.size());
        }
        return plugins;
    }

    private void executeVoidCommand(String ... command) {
        this.executeVoidCommand((ProgressIndicator)null, command);
    }

    private void executeVoidCommand(ProgressIndicator indicator, String ... command) {
        try {
            ProcessOutput output = this.executeAndGetOut(indicator, command);
            if (output.getExitCode() > 0) {
                throw new RuntimeException("Command error: " + output.getStderr());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Select correct executable path", e);
        }
    }

    private String getInnerVersion(String ... command) {
        try {
            ProcessOutput output = this.executeAndGetOut(command);
            String stderr = output.getStderr();
            if (output.getExitCode() > 0) {
                throw new RuntimeException("Command error: " + stderr);
            }
            String stdout = output.getStdout();
            if (StringUtil.isEmpty((String)stdout) && !StringUtil.isEmpty((String)stderr)) {
                return stderr;
            }
            return stdout;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String executeAndReturnResult(String ... command) {
        try {
            ProcessOutput output = this.executeAndGetOut(command);
            if (output.getExitCode() > 0) {
                throw new RuntimeException("Command error: " + output.getStderr());
            }
            return output.getStdout();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ProcessOutput executeAndGetOut(String[] command) throws ExecutionException {
        return this.executeAndGetOut(null, command);
    }

    private ProcessOutput executeAndGetOut(final @Nullable ProgressIndicator indicator, String[] command) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        commandLine.withWorkDirectory(this.myWorkDir);
        commandLine.withParentEnvironmentType(this.myPassParentEnv ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.withEnvironment(this.myEnv);
        commandLine.setCharset(Charsets.UTF_8);
        ColoredProcessHandler processHandler = new ColoredProcessHandler(commandLine);
        final ProcessOutput output = new ProcessOutput();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String s;
                if (indicator != null && !StringUtil.isEmpty((String)(s = StringUtil.trim((String)event.getText())))) {
                    indicator.setText2(s);
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    output.appendStderr(event.getText());
                } else if (outputType != ProcessOutputTypes.SYSTEM) {
                    output.appendStdout(event.getText());
                }
            }
        });
        processHandler.startNotify();
        if (processHandler.waitFor(PROCESS_TIMEOUT)) {
            output.setExitCode(processHandler.getProcess().exitValue());
        } else {
            processHandler.destroyProcess();
            output.setTimeout();
        }
        return output;
    }

    private OSProcessHandler createProcessHandler(List<String> commands) throws ExecutionException {
        return this.createProcessHandler(ArrayUtil.toStringArray(commands));
    }

    private OSProcessHandler createProcessHandler(String ... commands) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(commands);
        commandLine.withWorkDirectory(this.myWorkDir);
        return new KillableColoredProcessHandler(commandLine, true);
    }

    private static List<String> parseArgs(String paramList) {
        ArrayList list = ContainerUtil.newArrayList();
        if (StringUtil.isEmpty((String)paramList)) {
            return list;
        }
        for (String s : paramList.split(" ")) {
            String trim = StringUtil.trim((String)s);
            if (trim == null || trim.isEmpty()) continue;
            list.add(trim);
        }
        return list;
    }
}

