/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapTargets;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapIosTargets
extends PhoneGapTargets {
    private static final Function<String, String> PARSER_DEVICE_LINE = s -> PhoneGapIosTargets.parseDevice(s);
    private static final Function<String, String> PARSER_VIRTUAL_DEVICE_LINE = s -> PhoneGapIosTargets.parseVirtualDevice(s);
    private static final String IOS_SIM = "ios-sim";
    private static final String IOS_DEPLOY = "ios-deploy";
    private static final String EMULATOR_PREFIX = "com.apple.CoreSimulator.SimDeviceType.";

    public PhoneGapIosTargets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapIosTargets", "<init>"));
        }
        super(project);
    }

    @Override
    @NotNull
    protected List<String> listDevicesNonCached() {
        List<String> list = this.list(IOS_DEPLOY, PARSER_DEVICE_LINE, true, "-c", "-t", "1");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapIosTargets", "listDevicesNonCached"));
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> listVirtualDevicesNonCached() {
        List<String> list = this.list(IOS_SIM, PARSER_VIRTUAL_DEVICE_LINE, true, "showdevicetypes");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapIosTargets", "listVirtualDevicesNonCached"));
        }
        return list;
    }

    @Override
    @NotNull
    public String platform() {
        if ("ios" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapIosTargets", "platform"));
        }
        return "ios";
    }

    public static String getIosSimName() {
        return IOS_SIM;
    }

    public static String getIosDeployName() {
        return IOS_DEPLOY;
    }

    @Nullable
    private static String parseDevice(@Nullable String inputLine) {
        if (inputLine == null) {
            return null;
        }
        int start = inputLine.indexOf(40);
        if (start < 0) {
            return null;
        }
        int end = inputLine.indexOf(41);
        if (end <= 0 || end < start) {
            return null;
        }
        return inputLine.substring(start + 1, end).trim();
    }

    public static String parseVirtualDevice(@Nullable String inputLine) {
        if (inputLine == null) {
            return null;
        }
        String[] splitValues = inputLine.split(",");
        if (splitValues[0].startsWith(EMULATOR_PREFIX)) {
            return splitValues[0].substring(EMULATOR_PREFIX.length()).trim();
        }
        return null;
    }
}

