/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.RepoPackage;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class PhoneGapPluginsList {
    public static final String PLUGINS_URL = "http://registry.cordova.io/-/all";
    public static volatile Map<String, PhoneGapRepoPackage> CACHED_REPO;
    private static final Logger LOGGER;
    private static final Lock lock;

    private static boolean isExcludedProperty(String name) {
        return "_updated".equals(name);
    }

    public static PhoneGapRepoPackage getPackage(String name) {
        return PhoneGapPluginsList.mapCached().get(name);
    }

    public static List<RepoPackage> listCached() {
        return ContainerUtil.newArrayList(PhoneGapPluginsList.mapCached().values());
    }

    public static Map<String, PhoneGapRepoPackage> mapCached() {
        Map<String, PhoneGapRepoPackage> value = CACHED_REPO;
        if (value == null) {
            lock.lock();
            try {
                value = CACHED_REPO;
                if (value == null) {
                    CACHED_REPO = value = PhoneGapPluginsList.listNoCache();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return value;
    }

    private static Map<String, PhoneGapRepoPackage> listNoCache() {
        try {
            return (Map)HttpRequests.request((String)PLUGINS_URL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Map<String, PhoneGapRepoPackage>>(){

                public Map<String, PhoneGapRepoPackage> process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapPluginsList$1", "process"));
                    }
                    THashMap result = new THashMap();
                    for (Map.Entry entry : new JsonParser().parse((Reader)request.getReader()).getAsJsonObject().entrySet()) {
                        if (PhoneGapPluginsList.isExcludedProperty((String)entry.getKey())) continue;
                        result.put(entry.getKey(), new PhoneGapRepoPackage((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
                    }
                    return result;
                }
            });
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return ContainerUtil.newHashMap();
        }
    }

    public static void resetCache() {
        CACHED_REPO = null;
    }

    public static List<InstalledPackage> wrapInstalled(List<String> names) {
        return ContainerUtil.map(names, s -> {
            Object[] split = s.split(" ");
            String name = (String)ArrayUtil.getFirstElement((Object[])split);
            String version = split.length > 1 ? split[1] : "";
            return new InstalledPackage(name, version);
        });
    }

    public static List<RepoPackage> wrapRepo(List<String> names) {
        return ContainerUtil.map(names, s -> new RepoPackage(s, s));
    }

    static {
        LOGGER = Logger.getInstance(PhoneGapPluginsList.class);
        lock = new ReentrantLock();
    }

    public static final class PhoneGapRepoPackage
    extends RepoPackage {
        private final String myDesc;

        public PhoneGapRepoPackage(String name, JsonObject jsonObject) {
            super(name, PhoneGapPluginsList.PLUGINS_URL, PhoneGapRepoPackage.getVersionLatest(jsonObject.getAsJsonObject()));
            this.myDesc = PhoneGapRepoPackage.getDescr(jsonObject);
        }

        private static String getDescr(JsonObject jsonObject) {
            JsonElement descriptionElement = jsonObject.get("description");
            return descriptionElement == null ? "" : descriptionElement.getAsString();
        }

        private static String getVersionLatest(JsonObject jsonObject) {
            JsonElement element = jsonObject.get("dist-tags");
            if (element == null || !element.isJsonObject()) {
                return null;
            }
            JsonObject asObject = element.getAsJsonObject();
            JsonElement latest = asObject.get("latest");
            return latest == null ? null : latest.getAsString();
        }

        public String getDesc() {
            return this.myDesc;
        }
    }
}

