/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapAndroidTargets;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapIosTargets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhoneGapTargets {
    private static Logger LOGGER = Logger.getInstance(PhoneGapTargets.class);
    @NotNull
    protected final Project myProject;
    private final NotNullLazyValue<List<String>> myVirtualDevices;
    private final NotNullLazyValue<List<String>> myDevices;

    @Nullable
    public static PhoneGapTargets createTargetsList(@NotNull Project project, @Nullable String platform) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "createTargetsList"));
        }
        if ("android".equals(platform)) {
            return new PhoneGapAndroidTargets(project);
        }
        if ("ios".equals(platform)) {
            return new PhoneGapIosTargets(project);
        }
        return null;
    }

    @NotNull
    public static List<String> listTargets(@Nullable PhoneGapTargets phoneGapTargets, @Nullable String command) {
        if (phoneGapTargets == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listTargets"));
            }
            return list;
        }
        if ("emulate".equals(command)) {
            List<String> list = phoneGapTargets.listVirtualDevices();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listTargets"));
            }
            return list;
        }
        if ("run".equals(command)) {
            List<String> list = phoneGapTargets.listDevices();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listTargets"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listTargets"));
        }
        return list;
    }

    public PhoneGapTargets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "<init>"));
        }
        this.myVirtualDevices = new NotNullLazyValue<List<String>>(){

            @NotNull
            protected List<String> compute() {
                List<String> list = PhoneGapTargets.this.listVirtualDevicesNonCached();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets$1", "compute"));
                }
                return list;
            }
        };
        this.myDevices = new NotNullLazyValue<List<String>>(){

            @NotNull
            protected List<String> compute() {
                List<String> list = PhoneGapTargets.this.listDevicesNonCached();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets$2", "compute"));
                }
                return list;
            }
        };
        this.myProject = project;
    }

    @NotNull
    public List<String> listDevices() {
        List list = (List)this.myDevices.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listDevices"));
        }
        return list;
    }

    @NotNull
    public List<String> listVirtualDevices() {
        List list = (List)this.myVirtualDevices.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/commandLine/PhoneGapTargets", "listVirtualDevices"));
        }
        return list;
    }

    @NotNull
    protected abstract List<String> listDevicesNonCached();

    @NotNull
    protected abstract List<String> listVirtualDevicesNonCached();

    protected List<String> list(String executableName, Function<String, String> parser, boolean errorOut, String ... params) {
        ArrayList result = ContainerUtil.newArrayList();
        File deployExecutable = PathEnvironmentVariableUtil.findInPath((String)executableName);
        if (deployExecutable == null) {
            return result;
        }
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{deployExecutable.getAbsolutePath()});
            line.addParameters(params);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)line);
            List lines = null;
            if (errorOut && !StringUtil.isEmpty((String)output.getStderr())) {
                lines = output.getStderrLines();
            }
            if (lines == null) {
                lines = output.getStdoutLines();
            }
            if (output.getExitCode() != 0) {
                return result;
            }
            for (String value : lines) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)parser.fun((Object)value));
            }
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @NotNull
    public abstract String platform();
}

