/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.externalToolsDetector;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public class PhoneGapExecutableChecker {
    public static void check(Project project) {
        PhoneGapSettings instance = PhoneGapSettings.getInstance();
        if (StringUtil.isEmpty((String)instance.getExecutablePath())) {
            PhoneGapExecutableChecker.noPhoneGap();
            return;
        }
        String phoneGapExecutablePath = instance.getExecutablePath();
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{phoneGapExecutablePath, "--version"});
        generalCommandLine.setWorkDirectory(project.getBasePath());
        try {
            OSProcessHandler handler = new OSProcessHandler(generalCommandLine);
            handler.startNotify();
            generalCommandLine.createProcess();
        }
        catch (Exception e) {
            PhoneGapExecutableChecker.noPhoneGap();
        }
    }

    private static void noPhoneGap() {
        String groupDisplayId = "PhoneGap notification";
        String notificationTitle = "PhoneGap Plugin";
        String notificationMessage = "PhoneGap/Cordova has incorrect executable path";
        NotificationType notificationType = NotificationType.ERROR;
        Notification notification = new Notification(groupDisplayId, notificationTitle, notificationMessage, notificationType);
        Notifications.Bus.notify((Notification)notification);
    }
}

