/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapRunConfiguration;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import icons.PhoneGapIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapAddPlatformBeforeRun
extends BeforeRunTaskProvider<PhoneGapAddPlatformTask> {
    public static final Key<PhoneGapAddPlatformTask> ID = Key.create((String)"PhonegapTask");

    public Key<PhoneGapAddPlatformTask> getId() {
        return ID;
    }

    public String getName() {
        return PhoneGapBundle.message("phonegap.before.task.init.title", new Object[0]);
    }

    public String getDescription(PhoneGapAddPlatformTask task) {
        return PhoneGapBundle.message("phonegap.before.task.init.title", new Object[0]);
    }

    public boolean isConfigurable() {
        return false;
    }

    public Icon getIcon() {
        return PhoneGapIcons.PhonegapIntegration;
    }

    @Nullable
    public PhoneGapAddPlatformTask createTask(RunConfiguration runConfiguration) {
        return runConfiguration instanceof PhoneGapRunConfiguration ? new PhoneGapAddPlatformTask(ID) : null;
    }

    public boolean configureTask(RunConfiguration runConfiguration, PhoneGapAddPlatformTask task) {
        return false;
    }

    public boolean canExecuteTask(RunConfiguration configuration, PhoneGapAddPlatformTask task) {
        return configuration instanceof PhoneGapRunConfiguration;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, PhoneGapAddPlatformTask task) {
        final PhoneGapRunConfiguration phoneGapRunConfiguration = (PhoneGapRunConfiguration)configuration;
        final PhoneGapCommandLine line = phoneGapRunConfiguration.getCommandLine();
        if (!line.needAddPlatform()) {
            return true;
        }
        final Project project = configuration.getProject();
        final Semaphore targetDone = new Semaphore();
        final Ref result = new Ref((Object)true);
        final ArrayList exceptions = new ArrayList();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            targetDone.down();
            new Task.Backgroundable(project, PhoneGapBundle.message("phonegap.before.task.init.title", new Object[0]), true){

                public boolean shouldStartInBackground() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapAddPlatformBeforeRun$1", "run"));
                    }
                    try {
                        String platform = phoneGapRunConfiguration.getPlatform();
                        assert (platform != null);
                        ProcessOutput output = line.platformAdd(platform);
                        if (output.getExitCode() != 0) {
                            ExecutionHelper.showOutput((Project)project, (ProcessOutput)output, (String)PhoneGapBundle.message("phonegap.before.task.init.title", new Object[0]), null, (boolean)true);
                            result.set((Object)false);
                        }
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                        result.set((Object)false);
                    }
                    finally {
                        targetDone.up();
                    }
                }
            }.queue();
        }, ModalityState.NON_MODAL);
        if (!targetDone.waitFor(TimeUnit.MINUTES.toMillis(2L))) {
            ExecutionHelper.showErrors((Project)project, (List)ContainerUtil.createMaybeSingletonList((Object)new RuntimeException("Timeout")), (String)PhoneGapBundle.message("phonegap.before.task.init.error", new Object[0]), null);
        } else if (!exceptions.isEmpty()) {
            ExecutionHelper.showErrors((Project)project, exceptions, (String)PhoneGapBundle.message("phonegap.before.task.init.error", new Object[0]), null);
        }
        return (Boolean)result.get();
    }

    public static class PhoneGapAddPlatformTask
    extends BeforeRunTask<PhoneGapAddPlatformTask> {
        protected PhoneGapAddPlatformTask(@NotNull Key<PhoneGapAddPlatformTask> providerId) {
            if (providerId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerId", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapAddPlatformBeforeRun$PhoneGapAddPlatformTask", "<init>"));
            }
            super(providerId);
            this.setEnabled(true);
        }
    }
}

