/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapAndroidTargets;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapIosTargets;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapRunProfileState;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.ui.PhoneGapRunConfigurationEditor;
import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapRunConfiguration
extends LocatableConfigurationBase {
    private static final String CORDOVA_IOS_LOG_PATH = "/platforms/ios/cordova/console.log";
    private static final Set<String> MAC_SPEC_PLATFORMS = ContainerUtil.immutableSet((Object[])new String[]{"ios", "amazon-fireos", "android", "blackberry10", "browser", "firefoxos"});
    private static final Set<String> WIN_SPEC_PLATFORMS = ContainerUtil.immutableSet((Object[])new String[]{"amazon-fireos", "android", "blackberry10", "firefoxos", "wp8", "browser", "windows8"});
    private static final Set<String> LINUX_SPEC_PLATFORMS = ContainerUtil.immutableSet((Object[])new String[]{"amazon-fireos", "android", "browser", "firefoxos", "ubuntu"});
    private static final Set<String> REMOTE_BUILD_PLATFORMS = ContainerUtil.immutableSet((Object[])new String[]{"ios", "android", "wp8"});
    public static final String ANDROID_HOME_VARIABLE = "ANDROID_HOME";
    @Nullable
    public String myExecutable;
    @Nullable
    public String myWorkDir;
    @Nullable
    public String myCommand;
    public boolean myPassParent = true;
    @NotNull
    public Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    @Nullable
    public String myPlatform;
    public String myExtraArgs;
    public boolean hasTarget;
    @Nullable
    public String target;
    private volatile PhoneGapCommandLine myCommandLine;

    public boolean isPassParent() {
        return this.myPassParent;
    }

    public void setPassParent(boolean passParent) {
        this.myPassParent = passParent;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "setEnvs"));
        }
        this.myEnvs = envs;
    }

    @Nullable
    public String getCommand() {
        return this.myCommand;
    }

    public String getExtraArgs() {
        return this.myExtraArgs;
    }

    public void setExtraArgs(String extraArgs) {
        this.myExtraArgs = extraArgs;
    }

    public boolean hasTarget() {
        return this.hasTarget;
    }

    public void setHasTarget(boolean hasTarget) {
        this.hasTarget = hasTarget;
    }

    @Nullable
    public String getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable String target) {
        this.target = target;
    }

    @Nullable
    public String getWorkDir() {
        return this.myWorkDir;
    }

    public void setWorkDir(@Nullable String workDir) {
        this.myWorkDir = workDir;
    }

    @Nullable
    public String getExecutable() {
        return this.myExecutable;
    }

    public void setExecutable(@Nullable String executable) {
        this.myExecutable = executable;
    }

    public void setCommand(@Nullable String myCommand) {
        this.myCommand = myCommand;
    }

    @Nullable
    public String getPlatform() {
        return this.myPlatform;
    }

    public void setPlatform(@Nullable String myPlatform) {
        this.myPlatform = myPlatform;
    }

    public PhoneGapRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public String suggestedName() {
        return "Run PhoneGap";
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhoneGapRunConfigurationEditor phoneGapRunConfigurationEditor = new PhoneGapRunConfigurationEditor(this.getProject());
        if (phoneGapRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "getConfigurationEditor"));
        }
        return phoneGapRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (StringUtil.isEmpty((String)this.myCommand)) {
            throw new RuntimeConfigurationError("Command is missing");
        }
        if (StringUtil.isEmpty((String)this.myPlatform)) {
            throw new RuntimeConfigurationError("Platform is missing");
        }
        if (StringUtil.isEmpty((String)this.myExecutable)) {
            throw new RuntimeConfigurationError("Executable is missing");
        }
        if (StringUtil.isEmpty((String)this.myWorkDir)) {
            throw new RuntimeConfigurationError("Working directory is missing");
        }
        if (SystemInfo.isMac && !MAC_SPEC_PLATFORMS.contains(this.myPlatform)) {
            this.throwOSWarning();
        }
        if (SystemInfo.isLinux && !LINUX_SPEC_PLATFORMS.contains(this.myPlatform)) {
            this.throwOSWarning();
        }
        if (SystemInfo.isWindows && !WIN_SPEC_PLATFORMS.contains(this.myPlatform)) {
            this.throwOSWarning();
        }
        if (this.myPlatform.equals("firefoxos") && (this.myCommand.equals("emulate") || this.myCommand.equals("run"))) {
            this.throwUnsupportedCommandWarning();
        }
        if (!REMOTE_BUILD_PLATFORMS.contains(this.myPlatform) && (this.myCommand.equals("remote build") || this.myCommand.equals("remote run"))) {
            this.throwUnsupportedCommandWarning();
        }
        if (this.myPlatform.equals("android") && StringUtil.isEmpty((String)EnvironmentUtil.getValue((String)ANDROID_HOME_VARIABLE))) {
            PhoneGapRunConfiguration.checkExistsSdkWithWarning(PhoneGapAndroidTargets.getAndroidName(), "Cannot detect android SDK in path");
        }
        if (this.myPlatform.equals("ios")) {
            PhoneGapRunConfiguration.checkExistsSdkWithWarning(ContainerUtil.newArrayList((Object[])new String[]{PhoneGapIosTargets.getIosSimName(), PhoneGapIosTargets.getIosDeployName()}), "Cannot detect ios-sim and ios-deploy in path");
        }
    }

    public void throwOSWarning() throws RuntimeConfigurationWarning {
        throw new RuntimeConfigurationWarning("Applications for platform " + this.myPlatform + " can not be built on this OS");
    }

    public void throwUnsupportedCommandWarning() throws RuntimeConfigurationWarning {
        throw new RuntimeConfigurationWarning("Phonegap/Cordova doesn't support " + this.myCommand + " for " + this.myPlatform);
    }

    public PhoneGapCommandLine getCommandLine() {
        PhoneGapCommandLine current = this.myCommandLine;
        String executable = this.getExecutable();
        String workDir = this.getWorkDir();
        boolean passParentEnv = this.myPassParent;
        Map<String, String> env = this.myEnvs;
        if (current != null && StringUtil.equals((CharSequence)current.getPath(), (CharSequence)executable) && StringUtil.equals((CharSequence)current.getWorkDir(), (CharSequence)workDir) && passParentEnv == current.isPassParentEnv() && env.equals(current.getEnv())) {
            return current;
        }
        assert (executable != null);
        assert (workDir != null);
        this.myCommandLine = current = new PhoneGapCommandLine(executable, workDir, passParentEnv, env);
        return current;
    }

    public PhoneGapRunConfiguration clone() {
        Element element = new Element("toClone");
        try {
            this.writeExternal(element);
            PhoneGapRunConfiguration configuration = (PhoneGapRunConfiguration)this.getFactory().createTemplateConfiguration(this.getProject());
            configuration.setName(this.getName());
            configuration.readExternal(element);
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "getState"));
        }
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "getState"));
        }
        return new PhoneGapRunProfileState(this.getProject(), executionEnvironment, this);
    }

    private static void checkExistsSdkWithWarning(@Nullable String path, @NotNull String error) throws RuntimeConfigurationWarning {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "checkExistsSdkWithWarning"));
        }
        if (path == null) {
            return;
        }
        File file = PathEnvironmentVariableUtil.findInPath((String)path);
        if (file != null && file.exists()) {
            return;
        }
        throw new RuntimeConfigurationWarning(error);
    }

    private static void checkExistsSdkWithWarning(@Nullable List<String> paths, @NotNull String error) throws RuntimeConfigurationWarning {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "checkExistsSdkWithWarning"));
        }
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            File file = PathEnvironmentVariableUtil.findInPath((String)path);
            if (file == null || !file.exists()) continue;
            return;
        }
        throw new RuntimeConfigurationWarning(error);
    }

    public final void customizeLogConsole(LogConsole console) {
        LogFilterModel model = console.getFilterModel();
        if (model instanceof DefaultLogFilterModel) {
            ((DefaultLogFilterModel)model).setCheckStandartFilters(false);
        }
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        if (!"ios".equals(this.myPlatform) || StringUtil.isEmpty((String)this.myWorkDir)) {
            super.getAllLogFiles();
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LogFileOptions[]{new LogFileOptions("console.log", this.getPathToLog(), true, false, true)});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunConfiguration", "getAllLogFiles"));
        }
        return arrayList;
    }

    private String getPathToLog() {
        assert (this.myWorkDir != null);
        return FileUtil.toCanonicalPath((String)(FileUtil.toSystemIndependentName((String)StringUtil.trimEnd((String)this.myWorkDir, (String)File.separator)) + CORDOVA_IOS_LOG_PATH));
    }
}

