/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PhoneGapRunProfileState
extends CommandLineState {
    private ExecutionEnvironment env;
    private PhoneGapRunConfiguration phoneGapRunConfiguration;
    private final Project myProject;

    public PhoneGapRunProfileState(Project project, @NotNull ExecutionEnvironment env, PhoneGapRunConfiguration phoneGapRunConfiguration) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunProfileState", "<init>"));
        }
        super(env);
        this.myProject = project;
        this.env = env;
        this.phoneGapRunConfiguration = phoneGapRunConfiguration;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        PhoneGapCommandLine line = this.phoneGapRunConfiguration.getCommandLine();
        String command = this.phoneGapRunConfiguration.getCommand();
        assert (command != null);
        String platform = this.phoneGapRunConfiguration.getPlatform();
        assert (platform != null);
        OSProcessHandler oSProcessHandler = line.runCommand(command, platform, this.phoneGapRunConfiguration.hasTarget() ? this.phoneGapRunConfiguration.getTarget() : null, this.phoneGapRunConfiguration.getExtraArgs());
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/PhoneGapRunProfileState", "startProcess"));
        }
        return oSProcessHandler;
    }
}

