/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ComboBoxWithMoreOption
extends ComboBox {
    @NotNull
    private final Collection<String> myStartItems;
    @NotNull
    private final Collection<String> myExtendedItems;
    @NotNull
    private final String myMoreItem;

    public ComboBoxWithMoreOption(@NotNull Collection<String> startItems, @NotNull Collection<String> extendedItems) {
        if (startItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startItems", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/ComboBoxWithMoreOption", "<init>"));
        }
        if (extendedItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItems", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/ComboBoxWithMoreOption", "<init>"));
        }
        this.myStartItems = startItems;
        this.myExtendedItems = extendedItems;
        this.myMoreItem = "More options...";
        this.initItems();
    }

    public void initItems() {
        ComboBoxWithMoreOption.addItems(this, this.myStartItems);
        this.addItem(this.myMoreItem);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && ComboBoxWithMoreOption.this.myMoreItem.equals(ComboBoxWithMoreOption.this.getSelectedItem())) {
                    Object prevItem = e.getItem();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (ComboBoxWithMoreOption.this.getItemCount() != ComboBoxWithMoreOption.this.myStartItems.size() + ComboBoxWithMoreOption.this.myExtendedItems.size()) {
                            ComboBoxWithMoreOption.this.extend();
                            ComboBoxWithMoreOption.this.setSelectedItem(prevItem);
                        }
                        if (!ComboBoxWithMoreOption.this.isPopupVisible()) {
                            ComboBoxWithMoreOption.this.showPopup();
                        }
                    });
                }
            }
        });
    }

    public void setSelectedWithExtend(String value) {
        if (!this.myStartItems.contains(value)) {
            this.extend();
        }
        this.setSelectedItem(value);
    }

    private static void addItems(ComboBox box, Collection<String> items) {
        for (String item : items) {
            box.addItem((Object)item);
        }
    }

    public void extend() {
        this.removeItem(this.myMoreItem);
        ComboBoxWithMoreOption.addItems(this, this.myExtendedItems);
    }
}

