/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.ui;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapUtil;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapTargets;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.PhoneGapRunConfiguration;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.ui.ComboBoxWithMoreOption;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.runner.ui.PhoneGapTargetsPanel;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ReloadablePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PhoneGapRunConfigurationEditor
extends SettingsEditor<PhoneGapRunConfiguration> {
    public static final ArrayList<String> COMMANDS_LIST = ContainerUtil.newArrayList((Object[])new String[]{"emulate", "run", "prepare", "serve"});
    public static final ArrayList<String> COMMANDS_PHONEGAP_LIST = ContainerUtil.newArrayList((Object[])new String[]{"emulate", "run", "prepare", "serve", "remote build", "remote run"});
    public static final String PLATFORM_ANDROID = "android";
    public static final String PLATFORM_IOS = "ios";
    public static final String PLATFORM_AMAZON_FIREOS = "amazon-fireos";
    public static final String PLATFORM_BLACKBERRY_10 = "blackberry10";
    public static final String PLATFORM_UBUNTU = "ubuntu";
    public static final String PLATFORM_WP_8 = "wp8";
    public static final String PLATFORM_WINDOWS_8 = "windows8";
    public static final String PLATFORM_FIREFOXOS = "firefoxos";
    public static final String PLATFORM_BROWSER = "browser";
    private TextFieldWithHistoryWithBrowseButton myExecutablePathField;
    private TextFieldWithHistoryWithBrowseButton myWorkDirField;
    private ComboBoxWithMoreOption myPlatformField;
    private ComboBox myCommand;
    private final Project myProject;
    private JBCheckBox myHasTarget;
    private PhoneGapTargetsPanel myTarget;
    private JBTextField myExtraArgsTextField;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvComponent;

    public PhoneGapRunConfigurationEditor(Project project) {
        this.myProject = project;
    }

    protected void resetEditorFrom(@NotNull PhoneGapRunConfiguration s) {
        String workDir;
        String command;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/PhoneGapRunConfigurationEditor", "resetEditorFrom"));
        }
        String executable = s.getExecutable();
        PhoneGapUtil.setFieldWithHistoryWithBrowseButtonPath(this.myExecutablePathField, !StringUtil.isEmpty((String)executable) ? executable : PhoneGapSettings.getInstance().getExecutablePath());
        String item = s.getPlatform();
        if (item != null) {
            this.myPlatformField.setSelectedWithExtend(StringUtil.toLowerCase((String)item));
        }
        if ((command = s.getCommand()) != null) {
            this.myCommand.setSelectedItem((Object)command);
        }
        PhoneGapUtil.setFieldWithHistoryWithBrowseButtonPath(this.myWorkDirField, !StringUtil.isEmpty((String)(workDir = s.getWorkDir())) ? workDir : PhoneGapSettings.getInstance().getWorkingDirectory(this.myProject));
        boolean hasTarget = s.hasTarget();
        this.myHasTarget.setSelected(hasTarget);
        this.myExtraArgsTextField.setText(s.getExtraArgs());
        this.myEnvComponent.setEnvs(s.getEnvs());
        this.myEnvComponent.setPassParentEnvs(s.isPassParent());
        PhoneGapUtil.setTextFieldWithHistory(this.myTarget.getTargetsField(), s.getTarget());
        this.fillTargetValuesAndSetVisible(false);
    }

    private void fillTargetValuesAndSetVisible() {
        this.fillTargetValuesAndSetVisible(true);
    }

    private void fillTargetValuesAndSetVisible(boolean resetField) {
        this.setTargetFieldsEnable();
        if (resetField) {
            this.myTarget.getTargetsField().setHistory(ContainerUtil.emptyList());
            this.myTarget.getTargetsField().setText("");
        }
        this.myTarget.reloadValuesInBackground();
    }

    private String getPlatformAsCodeFromField() {
        return (String)this.myPlatformField.getSelectedItem();
    }

    protected void applyEditorTo(@NotNull PhoneGapRunConfiguration persistentSettings) throws ConfigurationException {
        if (persistentSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentSettings", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/PhoneGapRunConfigurationEditor", "applyEditorTo"));
        }
        persistentSettings.setExecutable(this.myExecutablePathField.getText());
        String item = (String)this.myPlatformField.getSelectedItem();
        persistentSettings.setPlatform(item);
        persistentSettings.setCommand((String)this.myCommand.getSelectedItem());
        persistentSettings.setWorkDir(this.myWorkDirField.getText());
        persistentSettings.setTarget(this.myTarget.getSelectedValue());
        persistentSettings.setHasTarget(this.myHasTarget.isSelected());
        persistentSettings.setExtraArgs(this.myExtraArgsTextField.getText());
        persistentSettings.setEnvs(this.myEnvComponent.getEnvs());
        persistentSettings.setPassParent(this.myEnvComponent.isPassParentEnvs());
    }

    @NotNull
    protected JComponent createEditor() {
        this.myExecutablePathField = PhoneGapUtil.createPhoneGapExecutableTextField(this.myProject);
        this.myWorkDirField = PhoneGapUtil.createPhoneGapWorkingDirectoryField(this.myProject);
        this.myPlatformField = new ComboBoxWithMoreOption(PhoneGapRunConfigurationEditor.getDefaultPlatforms(), PhoneGapRunConfigurationEditor.getNonDefaultPlatforms());
        this.myCommand = new ComboBox();
        this.myEnvComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myEnvComponent.setPassParentEnvs(true);
        this.myHasTarget = new JBCheckBox("Specify target");
        this.myTarget = new PhoneGapTargetsPanel();
        this.myExtraArgsTextField = new JBTextField(15);
        this.myCommand.setMinimumAndPreferredWidth(200);
        this.myPlatformField.setMinimumAndPreferredWidth(200);
        this.myTarget.getTargetsField().setMinimumAndPreferredWidth(this.myPlatformField.getPreferredSize().width);
        this.myTarget.setDataProvider((ReloadablePanel.DataProvider)new ReloadablePanel.DataProvider<String>(){

            @NotNull
            public Set<String> getCachedValues() {
                Set set = ContainerUtil.newHashOrEmptySet(null);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/PhoneGapRunConfigurationEditor$1", "getCachedValues"));
                }
                return set;
            }

            public void updateValuesAsynchronously() {
                if (!PhoneGapRunConfigurationEditor.this.myTarget.isEnabled()) {
                    this.processEmpty();
                    return;
                }
                String platform = PhoneGapRunConfigurationEditor.this.getPlatformAsCodeFromField();
                String command = (String)PhoneGapRunConfigurationEditor.this.myCommand.getSelectedItem();
                PhoneGapTargets targetsProvider = PhoneGapTargets.createTargetsList(PhoneGapRunConfigurationEditor.this.myProject, platform);
                if (targetsProvider == null) {
                    this.processEmpty();
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    String currentText = PhoneGapRunConfigurationEditor.this.myTarget.getTargetsField().getText();
                    LinkedHashSet targets = ContainerUtil.newLinkedHashSet(PhoneGapTargets.listTargets(targetsProvider, command));
                    if (!StringUtil.isEmpty((String)currentText) && !targets.contains(currentText)) {
                        targets.add(currentText);
                    }
                    UIUtil.invokeLaterIfNeeded(() -> PhoneGapRunConfigurationEditor.this.myTarget.onUpdateValues(targets));
                });
            }

            private void processEmpty() {
                PhoneGapRunConfigurationEditor.this.myTarget.onUpdateValues(ContainerUtil.newHashOrEmptySet(null));
            }
        });
        this.setListenerForPlatforms();
        this.setListenerForCommand();
        this.setListenerForHasTarget();
        this.setListenerForExecutablePath();
        this.setCommandList();
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent(PhoneGapBundle.message("phonegap.conf.executable.name", new Object[0]), (JComponent)this.myExecutablePathField).addLabeledComponent(PhoneGapBundle.message("phonegap.conf.work.dir.name", new Object[0]), (JComponent)this.myWorkDirField).addLabeledComponent(ExecutionBundle.message((String)"environment.variables.component.title", (Object[])new Object[0]), (JComponent)this.myEnvComponent).addLabeledComponent("Command:", (JComponent)this.myCommand).addLabeledComponent("Platform:", (JComponent)((Object)this.myPlatformField)).addLabeledComponent(PhoneGapBundle.message("phonegap.conf.extra.args.name", new Object[0]), (JComponent)this.myExtraArgsTextField).addLabeledComponent((JComponent)this.myHasTarget, (JComponent)this.myTarget.getMainPanel()).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/runner/ui/PhoneGapRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    private void setListenerForPlatforms() {
        this.myPlatformField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PhoneGapRunConfigurationEditor.this.fillTargetValuesAndSetVisible();
            }
        });
    }

    private void setListenerForHasTarget() {
        this.myHasTarget.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhoneGapRunConfigurationEditor.this.fillTargetValuesAndSetVisible();
            }
        });
    }

    private void setListenerForCommand() {
        this.myCommand.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PhoneGapRunConfigurationEditor.this.fillTargetValuesAndSetVisible();
                }
            }
        });
    }

    private void setListenerForExecutablePath() {
        final Ref prevExecutablePathRef = Ref.create((Object)StringUtil.notNullize((String)this.myExecutablePathField.getText()));
        final JTextField textEditor = ((TextFieldWithHistory)this.myExecutablePathField.getChildComponent()).getTextEditor();
        textEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String executablePath = StringUtil.notNullize((String)textEditor.getText());
                if (StringUtil.isEmpty((String)executablePath)) {
                    return;
                }
                String prevExecutablePath = (String)prevExecutablePathRef.get();
                if (!prevExecutablePath.equals(executablePath)) {
                    PhoneGapRunConfigurationEditor.this.setCommandList();
                    prevExecutablePathRef.set((Object)executablePath);
                }
            }
        });
    }

    private static void addItems(ComboBox box, List<String> list) {
        for (String s : list) {
            box.addItem((Object)s);
        }
        box.setSelectedIndex(0);
    }

    private void setCommandList() {
        String selectedItem = (String)this.myCommand.getSelectedItem();
        if (this.isPhoneGap()) {
            this.replaceCommandList(selectedItem, COMMANDS_PHONEGAP_LIST);
        } else {
            this.replaceCommandList(selectedItem, COMMANDS_LIST);
        }
    }

    private void replaceCommandList(String selectedItem, List<String> commandList) {
        if (this.myCommand.getItemCount() == commandList.size()) {
            return;
        }
        this.myCommand.removeAllItems();
        PhoneGapRunConfigurationEditor.addItems(this.myCommand, commandList);
        if (commandList.contains(selectedItem)) {
            this.myCommand.setSelectedItem((Object)selectedItem);
        }
    }

    private static Set<String> getDefaultPlatforms() {
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        set.add(PLATFORM_ANDROID);
        set.add(PLATFORM_IOS);
        set.add(PLATFORM_BROWSER);
        return set;
    }

    private static Set<String> getNonDefaultPlatforms() {
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        set.add(PLATFORM_AMAZON_FIREOS);
        set.add(PLATFORM_FIREFOXOS);
        set.add(PLATFORM_BLACKBERRY_10);
        set.add(PLATFORM_UBUNTU);
        set.add(PLATFORM_WP_8);
        set.add(PLATFORM_WINDOWS_8);
        return set;
    }

    private void setTargetFieldsEnable() {
        boolean isNotServe = !"serve".equals(this.myCommand.getSelectedItem());
        this.myHasTarget.setEnabled(isNotServe);
        this.myTarget.setEnabled(isNotServe && this.myHasTarget.isSelected());
    }

    private boolean isPhoneGap() {
        return Boolean.TRUE.equals(PhoneGapCommandLine.isPhoneGapExecutableByPath(this.myExecutablePathField.getText()));
    }
}

