/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhoneGapSettings", storages={@Storage(value="phonegap.xml")})
public final class PhoneGapSettings
implements PersistentStateComponent<State> {
    public static String PHONEGAP_WORK_DIRECTORY = "js.phonegap.settings.workdir";
    public static final String ANDROID_SDK = "android";
    public static final String IOS_SIM = "ios-sim";
    private State myState = new State();

    public static PhoneGapSettings getInstance() {
        return (PhoneGapSettings)ServiceManager.getService(PhoneGapSettings.class);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/PhoneGapSettings", "getState"));
        }
        return state;
    }

    @NotNull
    public String getWorkingDirectory(@Nullable Project project) {
        if (project == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/PhoneGapSettings", "getWorkingDirectory"));
            }
            return "";
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        String value = propertiesComponent.getValue(PHONEGAP_WORK_DIRECTORY);
        if (value != null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/PhoneGapSettings", "getWorkingDirectory"));
            }
            return string;
        }
        String item = (String)ContainerUtil.getFirstItem(PhoneGapUtil.getDefaultWorkingDirectory(project));
        String string = item == null ? "" : item;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/PhoneGapSettings", "getWorkingDirectory"));
        }
        return string;
    }

    public void setWorkingDirectory(@Nullable Project project, @Nullable String dir) {
        if (project == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        propertiesComponent.setValue(PHONEGAP_WORK_DIRECTORY, dir);
    }

    public boolean isExcludePlatformFolder() {
        return this.myState.isExcludePlatformFolder;
    }

    @Nullable
    public String getExecutablePath() {
        return this.myState.getExecutablePath();
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @Nullable
    private static String detectDefaultPath() {
        return (String)ContainerUtil.getFirstItem(PhoneGapUtil.getDefaultExecutablePaths());
    }

    public static class State {
        public String phoneGapExecutablePath;
        public String cordovaExecutablePath;
        public String executablePath;
        public boolean isExcludePlatformFolder = true;
        public List<String> repositoriesList = ContainerUtil.newArrayList();

        public State() {
        }

        public State(String path, List<String> repositories) {
            this.executablePath = path;
            this.repositoriesList = repositories;
        }

        public boolean equals(Object o) {
            if (!(o instanceof State)) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)this.getExecutablePath(), (CharSequence)((State)o).getExecutablePath())) {
                return false;
            }
            if (this.repositoriesList == ((State)o).repositoriesList) {
                return true;
            }
            if (this.repositoriesList == null) {
                return false;
            }
            return this.repositoriesList.equals(((State)o).repositoriesList) && ((State)o).isExcludePlatformFolder == this.isExcludePlatformFolder;
        }

        public int hashCode() {
            return String.valueOf(this.getExecutablePath()).hashCode();
        }

        public String getExecutablePath() {
            if (!StringUtil.isEmpty((String)this.phoneGapExecutablePath)) {
                this.executablePath = this.phoneGapExecutablePath;
                this.phoneGapExecutablePath = null;
            } else if (!StringUtil.isEmpty((String)this.cordovaExecutablePath)) {
                this.executablePath = this.cordovaExecutablePath;
                this.cordovaExecutablePath = null;
            }
            if (StringUtil.isEmpty((String)this.executablePath)) {
                this.executablePath = PhoneGapSettings.detectDefaultPath();
            }
            return this.executablePath;
        }
    }
}

