/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapUtil;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.plugins.PhoneGapPluginsView;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PhoneGapConfigurable
implements Configurable {
    private TextFieldWithHistoryWithBrowseButton myExecutablePath;
    private TextFieldWithHistoryWithBrowseButton myWorkingDirectory;
    private final PhoneGapSettings mySettings = PhoneGapSettings.getInstance();
    private UIController myUIController;
    private PhoneGapPluginsView phoneGapPluginsView;
    private final Project myProject;
    private JPanel myWrapper;
    private JBLabel myVersion;
    private RepositoryStore myRepositoryStore;
    private JCheckBox myExcludePlatformsCheckBox;

    public PhoneGapConfigurable(Project project) {
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return "PhoneGap/Cordova";
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.javascript.phonegap.cordova";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myWrapper == null) {
            this.myExecutablePath = PhoneGapUtil.createPhoneGapExecutableTextField(this.myProject);
            this.myWorkingDirectory = PhoneGapUtil.createPhoneGapWorkingDirectoryField(this.myProject);
            this.myVersion = new JBLabel();
            this.myUIController = new UIController();
            this.myExcludePlatformsCheckBox = new JCheckBox(PhoneGapBundle.message("phonegap.conf.exclude.platforms", new Object[0]));
            this.myRepositoryStore = new RepositoryStore();
            this.myUIController.reset(this.mySettings.getState());
            this.phoneGapPluginsView = new PhoneGapPluginsView(this.myProject);
            JPanel panel = FormBuilder.createFormBuilder().addLabeledComponent(PhoneGapBundle.message("phonegap.conf.executable.name", new Object[0]), (JComponent)this.myExecutablePath).addLabeledComponent(PhoneGapBundle.message("phonegap.conf.version.name", new Object[0]), (JComponent)this.myVersion).addLabeledComponent(PhoneGapBundle.message("phonegap.conf.work.dir.name", new Object[0]), (JComponent)this.myWorkingDirectory).addComponent((JComponent)this.myExcludePlatformsCheckBox).addComponent((JComponent)this.phoneGapPluginsView.getPanel()).getPanel();
            this.myWrapper = new JPanel(new BorderLayout());
            this.myWrapper.add((Component)panel, "North");
            this.setupListeners();
            this.phoneGapPluginsView.setupService(this.myExecutablePath.getText(), this.myWorkingDirectory.getText(), this.myRepositoryStore, this.getVersionCallback());
        }
        return this.myWrapper;
    }

    private void setupListeners() {
        JTextField executableValue = ((TextFieldWithHistory)this.myExecutablePath.getChildComponent()).getTextEditor();
        this.setUpListener((TextFieldWithHistory)this.myExecutablePath.getChildComponent(), (Ref<String>)Ref.create((Object)StringUtil.notNullize((String)executableValue.getText())));
        JTextField workDirValue = ((TextFieldWithHistory)this.myWorkingDirectory.getChildComponent()).getTextEditor();
        this.setUpListener((TextFieldWithHistory)this.myWorkingDirectory.getChildComponent(), (Ref<String>)Ref.create((Object)StringUtil.notNullize((String)workDirValue.getText())));
    }

    private void setVersion(String version) {
        this.myVersion.setText(version);
    }

    private void setUpListener(final TextFieldWithHistory textField, final Ref<String> prevExecutablePathRef) {
        textField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String executablePath = StringUtil.notNullize((String)textField.getText());
                String prevExecutablePath = (String)prevExecutablePathRef.get();
                if (!prevExecutablePath.equals(executablePath) && !StringUtil.isEmpty((String)executablePath)) {
                    PhoneGapConfigurable.this.phoneGapPluginsView.setupService(PhoneGapConfigurable.this.myExecutablePath.getText(), PhoneGapConfigurable.this.myWorkingDirectory.getText(), PhoneGapConfigurable.this.myRepositoryStore, PhoneGapConfigurable.this.getVersionCallback());
                    prevExecutablePathRef.set((Object)executablePath);
                }
            }
        });
    }

    public boolean isModified() {
        return this.myUIController.isModified();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.loadState(this.myUIController.getState());
        this.mySettings.setWorkingDirectory(this.myProject, this.myUIController.getWorkingDirectory());
    }

    public void reset() {
        this.myUIController.reset(this.mySettings.getState());
    }

    private PhoneGapPluginsView.VersionCallback getVersionCallback() {
        return new PhoneGapPluginsView.VersionCallback(){

            @Override
            public void forVersion(String version) {
                PhoneGapConfigurable.this.setVersion(version);
            }
        };
    }

    private class UIController {
        private UIController() {
        }

        public void reset(PhoneGapSettings.State state) {
            PhoneGapUtil.setFieldWithHistoryWithBrowseButtonPath(PhoneGapConfigurable.this.myExecutablePath, state.getExecutablePath());
            PhoneGapConfigurable.this.myRepositoryStore.reset(state.repositoriesList);
            PhoneGapConfigurable.this.myExcludePlatformsCheckBox.setSelected(state.isExcludePlatformFolder);
        }

        public boolean isModified() {
            return !this.getState().equals(PhoneGapConfigurable.this.mySettings.getState()) || !StringUtil.equals((CharSequence)this.getWorkingDirectory(), (CharSequence)PhoneGapConfigurable.this.mySettings.getWorkingDirectory(PhoneGapConfigurable.this.myProject));
        }

        private PhoneGapSettings.State getState() {
            PhoneGapSettings.State state = new PhoneGapSettings.State();
            state.executablePath = PhoneGapConfigurable.this.myExecutablePath.getText();
            state.repositoriesList = PhoneGapConfigurable.this.myRepositoryStore.getRepositories();
            state.isExcludePlatformFolder = PhoneGapConfigurable.this.myExcludePlatformsCheckBox.isSelected();
            return state;
        }

        @Nullable
        private String getWorkingDirectory() {
            return PhoneGapConfigurable.this.myWorkingDirectory.getText();
        }
    }

    public static class RepositoryStore {
        private List<String> myRepoList;

        public RepositoryStore() {
            this.setReposInner(ContainerUtil.newArrayList());
        }

        private void setReposInner(List<String> repos) {
            this.myRepoList = repos == null ? ContainerUtil.newArrayList() : ContainerUtil.newArrayList(repos);
        }

        public List<String> getRepositories() {
            return ContainerUtil.newArrayList(this.myRepoList);
        }

        public void addRepository(String repo) {
            this.myRepoList.add(repo);
        }

        public void remove(String repo) {
            this.myRepoList.remove(repo);
        }

        public void reset(List<String> repos) {
            this.setReposInner(repos);
        }
    }
}

