/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.plugins;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapPluginsList;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.PhoneGapConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapPackageManagementService
extends PackageManagementServiceEx {
    private final PhoneGapCommandLine myCommands;
    private PhoneGapConfigurable.RepositoryStore myRepositoryStore;

    public PhoneGapPackageManagementService(@NotNull PhoneGapCommandLine commandLine, @NotNull PhoneGapConfigurable.RepositoryStore repositoryStore) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "<init>"));
        }
        if (repositoryStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryStore", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "<init>"));
        }
        this.myRepositoryStore = repositoryStore;
        this.myCommands = commandLine;
    }

    @Nullable
    public List<String> getAllRepositories() {
        return this.myRepositoryStore.getRepositories();
    }

    public boolean canModifyRepository(String repositoryUrl) {
        return !"http://registry.cordova.io/-/all".equals(repositoryUrl);
    }

    public void addRepository(String repositoryUrl) {
        this.myRepositoryStore.addRepository(repositoryUrl);
    }

    public void removeRepository(String repositoryUrl) {
        this.myRepositoryStore.remove(repositoryUrl);
    }

    public List<RepoPackage> getAllPackages() throws IOException {
        List<RepoPackage> packages = PhoneGapPluginsList.listCached();
        List<String> repositories = this.getAllRepositories();
        assert (repositories != null);
        packages.addAll(PhoneGapPluginsList.wrapRepo(repositories));
        return packages;
    }

    public List<RepoPackage> reloadAllPackages() throws IOException {
        PhoneGapPluginsList.resetCache();
        return this.getAllPackages();
    }

    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        List<String> names = this.myCommands.pluginList();
        return PhoneGapPluginsList.wrapInstalled(names);
    }

    public List<RepoPackage> getAllPackagesCached() {
        try {
            return this.getAllPackages();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, PackageManagementService.Listener listener, boolean installToUser) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            listener.operationStarted(repoPackage.getName());
            Ref errorMessage = new Ref();
            try {
                String appendVersion = version == null ? "" : "@" + version;
                this.myCommands.pluginAdd(repoPackage.getName() + appendVersion);
            }
            catch (Exception e) {
                String message = e.getMessage();
                errorMessage.set((Object)(message == null ? e.toString() : message));
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    listener.operationFinished(repoPackage.getName(), PackageManagementService.ErrorDescription.fromMessage((String)((String)errorMessage.get())));
                    PhoneGapPackageManagementService.scheduleFileSystemRefresh();
                }, ModalityState.any());
            }
        });
    }

    public void uninstallPackages(List<InstalledPackage> installedPackages, PackageManagementService.Listener listener) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> ContainerUtil.process((List)installedPackages, aPackage -> {
            listener.operationStarted(aPackage.getName());
            Ref errorMessage = new Ref();
            try {
                this.myCommands.pluginRemove(aPackage.getName());
            }
            catch (Exception e) {
                errorMessage.set((Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    listener.operationFinished(aPackage.getName(), PackageManagementService.ErrorDescription.fromMessage((String)((String)errorMessage.get())));
                    PhoneGapPackageManagementService.scheduleFileSystemRefresh();
                }, ModalityState.any());
            }
            return true;
        }));
    }

    public void fetchPackageVersions(String packageName, CatchingConsumer<List<String>, Exception> consumer) {
        PhoneGapPluginsList.PhoneGapRepoPackage aPackage = PhoneGapPluginsList.getPackage(packageName);
        if (aPackage == null) {
            consumer.consume((Object)ContainerUtil.emptyList());
            return;
        }
        consumer.consume((Object)ContainerUtil.newArrayList((Object[])new String[]{aPackage.getLatestVersion()}));
    }

    public void fetchPackageDetails(String packageName, CatchingConsumer<String, Exception> consumer) {
        PhoneGapPluginsList.PhoneGapRepoPackage aPackage = PhoneGapPluginsList.getPackage(packageName);
        consumer.consume((Object)(aPackage != null ? aPackage.getDesc() : ""));
    }

    private static void scheduleFileSystemRefresh() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LocalFileSystem.getInstance().refresh(true);
    }

    public void updatePackage(@NotNull InstalledPackage repoPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener) {
        if (repoPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "updatePackage"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "updatePackage"));
        }
        this.installPackage(new RepoPackage(repoPackage.getName(), ""), version, false, null, listener, false);
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "fetchLatestVersion"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPackageManagementService", "fetchLatestVersion"));
        }
        PhoneGapPluginsList.PhoneGapRepoPackage aPackage = PhoneGapPluginsList.getPackage(pkg.getName());
        consumer.consume((Object)(aPackage == null ? null : aPackage.getLatestVersion()));
    }
}

