/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.plugins;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.commandLine.PhoneGapCommandLine;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.PhoneGapConfigurable;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.plugins.PhoneGapInstalledPluginsPanel;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.ui.plugins.PhoneGapPackageManagementService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapPluginsView {
    private final PhoneGapInstalledPluginsPanel myPanel;
    private final JPanel myComponent;
    private PackagesNotificationPanel packagesNotificationPanel;
    private Project myProject;

    public PhoneGapPluginsView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "<init>"));
        }
        this.myProject = project;
        this.packagesNotificationPanel = new PackagesNotificationPanel();
        this.myPanel = new PhoneGapInstalledPluginsPanel(project, this.packagesNotificationPanel);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Plugins", (boolean)false));
        wrapper.add(FormBuilder.createFormBuilder().addComponent((JComponent)((Object)this.myPanel)).addComponent(this.packagesNotificationPanel.getComponent()).getPanel());
        this.myComponent = wrapper;
    }

    public synchronized void setupService(@Nullable String path, @NotNull String workDir, @NotNull PhoneGapConfigurable.RepositoryStore repositoryStore, @NotNull VersionCallback callback) {
        if (workDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workDir", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "setupService"));
        }
        if (repositoryStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryStore", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "setupService"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "setupService"));
        }
        this.packagesNotificationPanel.removeAllLinkHandlers();
        this.packagesNotificationPanel.hide();
        callback.forVersion("");
        if (StringUtil.isEmpty((String)path) || StringUtil.isEmpty((String)workDir)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (workDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workDir", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "lambda$setupService$0"));
            }
            if (repositoryStore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryStore", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "lambda$setupService$0"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/settings/ui/plugins/PhoneGapPluginsView", "lambda$setupService$0"));
            }
            this.runOnPooledThread(path, workDir, repositoryStore, callback);
        });
    }

    private synchronized void runOnPooledThread(String path, String workDir, PhoneGapConfigurable.RepositoryStore repositoryStore, VersionCallback callback) {
        Ref service = new Ref();
        Ref error = new Ref();
        Ref warning = new Ref();
        Ref version = new Ref();
        try {
            PhoneGapCommandLine commandLine = this.checkParams((Ref<String>)error, (Ref<String>)warning, (Ref<String>)version, path, workDir);
            if (error.get() == null) {
                service.set((Object)new PhoneGapPackageManagementService(commandLine, repositoryStore));
            }
        }
        catch (Exception e) {
            error.set((Object)PhoneGapBundle.message("phonegap.plugins.executable.error", new Object[0]));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myPanel.updatePackages((PackageManagementService)service.get());
            if (error.get() != null) {
                this.packagesNotificationPanel.showError((String)error.get(), null, null);
            }
            if (warning.get() != null) {
                this.packagesNotificationPanel.showWarning((String)warning.get());
            }
            callback.forVersion((String)version.get());
        });
    }

    private PhoneGapCommandLine checkParams(Ref<String> error, Ref<String> warning, Ref<String> version, String path, String workDir) throws ExecutionException {
        PhoneGapCommandLine commandLine;
        boolean pathError = false;
        if (!new File(workDir).exists()) {
            pathError = true;
            workDir = this.myProject.getBasePath();
        }
        if (!(commandLine = new PhoneGapCommandLine(path, workDir)).isCorrectExecutable()) {
            error.set((Object)PhoneGapBundle.message("phonegap.plugins.executable.error", new Object[0]));
            return commandLine;
        }
        version.set((Object)commandLine.version());
        if (pathError) {
            error.set((Object)PhoneGapBundle.message("phonegap.plugins.executable.work.path.error", commandLine.getPlatformName()));
            return commandLine;
        }
        ProcessOutput output = commandLine.pluginListRaw();
        if (!StringUtil.isEmpty((String)output.getStderr())) {
            error.set((Object)PhoneGapBundle.message("phonegap.plugins.executable.work.path.error", commandLine.getPlatformName()));
            return commandLine;
        }
        if (commandLine.isOld()) {
            warning.set((Object)PhoneGapBundle.message("phonegap.plugins.executable.version.error", new Object[0]));
        }
        return commandLine;
    }

    public JPanel getPanel() {
        return this.myComponent;
    }

    public static interface VersionCallback {
        public void forVersion(String var1);
    }
}

