/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;

public final class HgCommandResultNotifier {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(HgCommandResultNotifier.class);

    public HgCommandResultNotifier(Project project) {
        this.myProject = project;
    }

    public void notifyError(@Nullable HgCommandResult result, @NotNull String failureTitle, @NotNull String failureDescription) {
        if (failureTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureTitle", "org/zmlx/hg4idea/action/HgCommandResultNotifier", "notifyError"));
        }
        if (failureDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureDescription", "org/zmlx/hg4idea/action/HgCommandResultNotifier", "notifyError"));
        }
        this.notifyError(result, failureTitle, failureDescription, null);
    }

    public void notifyError(@Nullable HgCommandResult result, @NotNull String failureTitle, @NotNull String failureDescription, @Nullable NotificationListener listener) {
        String errorMessage;
        if (failureTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureTitle", "org/zmlx/hg4idea/action/HgCommandResultNotifier", "notifyError"));
        }
        if (failureDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureDescription", "org/zmlx/hg4idea/action/HgCommandResultNotifier", "notifyError"));
        }
        if (StringUtil.isEmptyOrSpaces((String)failureDescription)) {
            failureDescription = failureTitle;
        }
        if (result == null) {
            errorMessage = failureDescription;
        } else {
            List<String> err = result.getErrorLines();
            if (err.isEmpty()) {
                LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)failureDescription), (Object)"Failure title, failure description and errors log can not be empty at the same time");
                errorMessage = failureDescription;
            } else {
                errorMessage = failureDescription.isEmpty() ? XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(err, (String)"<br>")) : XmlStringUtil.wrapInHtml((CharSequence)(failureDescription + "<br>" + StringUtil.join(err, (String)"<br>")));
            }
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError(failureTitle, errorMessage, listener);
    }
}

