/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgBranchCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.ui.HgBookmarkDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopupActions {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;

    HgBranchPopupActions(@NotNull Project project, @NotNull HgRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/branch/HgBranchPopupActions", "<init>"));
        }
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, "");
    }

    ActionGroup createActions(@Nullable DefaultActionGroup toInsert, @NotNull String repoInfo) {
        if (repoInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoInfo", "org/zmlx/hg4idea/branch/HgBranchPopupActions", "createActions"));
        }
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addAction((AnAction)new HgNewBranchAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgNewBookmarkAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgCloseBranchAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgShowUnnamedHeadsForCurrentBranchAction(this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Bookmarks" + repoInfo);
        List<String> bookmarkNames = HgUtil.getSortedNamesWithoutHashes(this.myRepository.getBookmarks());
        String currentBookmark = this.myRepository.getCurrentBookmark();
        for (String bookmark : bookmarkNames) {
            BookmarkActions bookmarkAction = new BookmarkActions(this.myProject, Collections.singletonList(this.myRepository), bookmark);
            if (bookmark.equals(currentBookmark)) {
                bookmarkAction.getTemplatePresentation().setIcon(PlatformIcons.CHECK_ICON);
            }
            popupGroup.add((AnAction)bookmarkAction);
        }
        popupGroup.addSeparator("Branches" + repoInfo);
        ArrayList<String> branchNamesList = new ArrayList<String>(this.myRepository.getOpenedBranches());
        Collections.sort(branchNamesList);
        for (String branch : branchNamesList) {
            if (branch.equals(this.myRepository.getCurrentBranch())) continue;
            popupGroup.add((AnAction)new HgCommonBranchActions(this.myProject, Collections.singletonList(this.myRepository), branch));
        }
        return popupGroup;
    }

    static class BookmarkActions
    extends HgCommonBranchActions {
        BookmarkActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            super(project, repositories, branchName);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])super.getChildren(e), (Object)((Object)new DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)));
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "getChildren"));
            }
            return anActionArray;
        }

        private static class DeleteBookmarkAction
        extends HgBranchAbstractAction {
            DeleteBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                super(project, "Delete", repositories, branchName);
            }

            public void actionPerformed(AnActionEvent e) {
                HgUtil.executeOnPooledThread(() -> {
                    for (HgRepository repository : this.myRepositories) {
                        HgBookmarkCommand.deleteBookmarkSynchronously(this.myProject, repository.getRoot(), this.myBranchName);
                    }
                }, (Disposable)this.myProject);
            }
        }
    }

    public static class HgShowUnnamedHeadsForCurrentBranchAction
    extends ActionGroup {
        @NotNull
        final HgRepository myRepository;
        @NotNull
        final String myCurrentBranchName;
        @NotNull
        Collection<Hash> myHeads;

        public HgShowUnnamedHeadsForCurrentBranchAction(@NotNull HgRepository repository) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "<init>"));
            }
            super(null, true);
            this.myHeads = new HashSet<Hash>();
            this.myRepository = repository;
            this.myCurrentBranchName = repository.getCurrentBranch();
            this.getTemplatePresentation().setText(String.format("Unnamed heads for %s", this.myCurrentBranchName));
            this.myHeads = this.filterUnnamedHeads();
        }

        @NotNull
        private Collection<Hash> filterUnnamedHeads() {
            Collection branchWithHashes = this.myRepository.getBranches().get(this.myCurrentBranchName);
            String currentHead = this.myRepository.getCurrentRevision();
            if (branchWithHashes == null || currentHead == null || this.myRepository.getState() != Repository.State.NORMAL) {
                Set<Hash> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "filterUnnamedHeads"));
                }
                return set;
            }
            List bookmarkHashes = ContainerUtil.map(this.myRepository.getBookmarks(), info -> info.getHash());
            branchWithHashes.removeAll(bookmarkHashes);
            branchWithHashes.remove(HashImpl.build((String)currentHead));
            Collection collection = branchWithHashes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "filterUnnamedHeads"));
            }
            return collection;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<HgCommonBranchActions> branchHeadActions = new ArrayList<HgCommonBranchActions>();
            for (Hash hash : this.myHeads) {
                branchHeadActions.add(new HgCommonBranchActions(this.myRepository.getProject(), Collections.singletonList(this.myRepository), hash.toShortString()));
            }
            AnAction[] anActionArray = (AnAction[])ContainerUtil.toArray(branchHeadActions, (Object[])new AnAction[branchHeadActions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "getChildren"));
            }
            return anActionArray;
        }

        public void update(AnActionEvent e) {
            if (this.myRepository.isFresh() || this.myHeads.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else if (!Repository.State.NORMAL.equals((Object)this.myRepository.getState())) {
                e.getPresentation().setEnabled(false);
            }
        }
    }

    public static class HgNewBookmarkAction
    extends DumbAwareAction {
        @NotNull
        protected final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgNewBookmarkAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction", "<init>"));
            }
            if (preselectedRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepo", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction", "<init>"));
            }
            super("New Bookmark", "Create new bookmark", AllIcons.Modules.AddContentEntry);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void update(AnActionEvent e) {
            if (DvcsUtil.anyRepositoryIsFresh(this.myRepositories)) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Bookmark creation is not possible before the first commit.");
            }
        }

        public void actionPerformed(AnActionEvent e) {
            String name;
            HgBookmarkDialog bookmarkDialog = new HgBookmarkDialog(this.myPreselectedRepo);
            if (bookmarkDialog.showAndGet() && !StringUtil.isEmptyOrSpaces((String)(name = bookmarkDialog.getName()))) {
                HgBookmarkCommand.createBookmarkAsynchronously(this.myRepositories, name, bookmarkDialog.isActive());
            }
        }
    }

    public static class HgCloseBranchAction
    extends DumbAwareAction {
        @NotNull
        private final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgCloseBranchAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction", "<init>"));
            }
            if (preselectedRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepo", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction", "<init>"));
            }
            super("Close " + StringUtil.pluralize((String)"branch", (int)repositories.size()), "Close current " + StringUtil.pluralize((String)"branch", (int)repositories.size()), AllIcons.Actions.Delete);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = this.myPreselectedRepo.getProject();
            ApplicationManager.getApplication().saveAll();
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> this.commitAndCloseBranch(project), InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
        }

        private void commitAndCloseBranch(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction", "commitAndCloseBranch"));
            }
            LocalChangeList activeChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            HgVcs vcs = HgVcs.getInstance(project);
            assert (vcs != null);
            HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
            List changesForRepositories = ContainerUtil.filter((Collection)activeChangeList.getChanges(), change -> this.myRepositories.contains(repositoryManager.getRepositoryForFile(ChangesUtil.getFilePath((Change)change))));
            HgCloseBranchExecutor closeBranchExecutor = vcs.getCloseBranchExecutor();
            closeBranchExecutor.setRepositories(this.myRepositories);
            CommitChangeListDialog.commitChanges((Project)project, (List)changesForRepositories, (LocalChangeList)activeChangeList, Collections.singletonList(closeBranchExecutor), (boolean)false, (AbstractVcs)vcs, (String)"Close Branch", null, (boolean)false);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ContainerUtil.and(this.myRepositories, repository -> repository.getOpenedBranches().contains(repository.getCurrentBranch())));
        }
    }

    public static class HgNewBranchAction
    extends NewBranchAction<HgRepository> {
        @NotNull
        final HgRepository myPreselectedRepo;

        public HgNewBranchAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            if (preselectedRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepo", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            super(project, repositories);
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(AnActionEvent e) {
            final String name = HgUtil.getNewBranchNameFromUser(this.myPreselectedRepo, "Create New Branch");
            if (name == null) {
                return;
            }
            new Task.Backgroundable(this.myProject, "Creating " + StringUtil.pluralize((String)"Branch", (int)this.myRepositories.size()) + "..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction$1", "run"));
                    }
                    this.createNewBranchInCurrentThread(name);
                }
            }.queue();
        }

        public void createNewBranchInCurrentThread(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "createNewBranchInCurrentThread"));
            }
            for (HgRepository repository : this.myRepositories) {
                try {
                    HgCommandResult result = new HgBranchCreateCommand(this.myProject, repository.getRoot(), name).executeInCurrentThread();
                    repository.update();
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) continue;
                    new HgCommandResultNotifier(this.myProject).notifyError(result, "Creation failed", "Branch creation [" + name + "] failed");
                }
                catch (HgCommandException exception) {
                    HgErrorUtil.handleException(this.myProject, "Can't create new branch: ", exception);
                }
            }
        }
    }
}

