/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.util.HgVersion;

public class HgFileRevisionLogParser
extends HgBaseLogParser<HgFileRevision> {
    private static final Logger LOG = Logger.getInstance(HgFileRevisionLogParser.class);
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private HgVersion myVersion;

    public HgFileRevisionLogParser(@NotNull Project project, @NotNull HgFile hgFile, @NotNull HgVersion currentVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "<init>"));
        }
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "<init>"));
        }
        if (currentVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVersion", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "<init>"));
        }
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myVersion = currentVersion;
    }

    @Override
    @Nullable
    protected HgFileRevision convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
        String separator;
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (revisionDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionDate", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "convertDetails"));
        }
        int numAttributes = attributes.size();
        String commitMessage = HgFileRevisionLogParser.parseAdditionalStringAttribute(attributes, 5);
        String branchName = HgFileRevisionLogParser.parseAdditionalStringAttribute(attributes, 6);
        HgRevisionNumber vcsRevisionNumber = new HgRevisionNumber(rev, changeset, author, email, commitMessage, (List<HgRevisionNumber>)parents);
        Set<String> filesAdded = Collections.emptySet();
        Set<String> filesModified = Collections.emptySet();
        Set<String> filesDeleted = Collections.emptySet();
        Map<String, String> copies = Collections.emptyMap();
        boolean shouldParseOldTemplate = !this.myVersion.isBuiltInFunctionSupported();
        String string = separator = shouldParseOldTemplate ? " " : "\u0001";
        if (numAttributes > 7) {
            filesAdded = HgFileRevisionLogParser.parseFileList(attributes.get(7), separator);
            if (numAttributes > 8) {
                filesModified = HgFileRevisionLogParser.parseFileList(attributes.get(8), separator);
                if (numAttributes > 9) {
                    filesDeleted = HgFileRevisionLogParser.parseFileList(attributes.get(9), separator);
                    if (numAttributes > 10) {
                        copies = shouldParseOldTemplate ? HgFileRevisionLogParser.parseCopiesFileListAsOldVersion(attributes.get(10)) : HgFileRevisionLogParser.parseCopiesFileList(attributes.get(10));
                        Iterator<String> keys = copies.keySet().iterator();
                        while (keys.hasNext()) {
                            String s = keys.next();
                            if (filesAdded.contains(copies.get(s)) && filesDeleted.contains(s)) {
                                filesAdded.remove(copies.get(s));
                                filesDeleted.remove(s);
                                continue;
                            }
                            if (filesDeleted.contains(s)) continue;
                            keys.remove();
                        }
                    }
                }
            }
        }
        return new HgFileRevision(this.myProject, this.myHgFile, vcsRevisionNumber, branchName, revisionDate, vcsRevisionNumber.getAuthor(), commitMessage, filesModified, filesAdded, filesDeleted, copies);
    }

    private static Set<String> parseFileList(@Nullable String fileListString, @NotNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseFileList"));
        }
        return StringUtil.isEmpty((String)fileListString) ? Collections.emptySet() : new HashSet(StringUtil.split((String)fileListString, (String)separator));
    }

    @NotNull
    static Map<String, String> parseCopiesFileList(@Nullable String fileListString) {
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseCopiesFileList"));
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        List filesList = StringUtil.split((String)fileListString, (String)"\u0001");
        for (String pairOfFiles : filesList) {
            String[] files = pairOfFiles.split("\\s+\\(");
            if (files.length != 2) {
                LOG.info("Couldn't parse copied files: " + fileListString);
                HashMap<String, String> hashMap = copies;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseCopiesFileList"));
                }
                return hashMap;
            }
            copies.put(files[1].substring(0, files[1].length() - 1), files[0]);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseCopiesFileList"));
        }
        return hashMap;
    }

    @NotNull
    static Map<String, String> parseCopiesFileListAsOldVersion(@Nullable String fileListString) {
        String source;
        int afterRightBraceIndex;
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseCopiesFileListAsOldVersion"));
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        String[] filesList = fileListString.split("\\s+\\(");
        String target = filesList[0];
        for (int i = 1; i < filesList.length && (afterRightBraceIndex = HgFileRevisionLogParser.findRightBracePosition(source = filesList[i])) != -1; ++i) {
            copies.put(source.substring(0, afterRightBraceIndex - 1), target);
            if (afterRightBraceIndex >= source.length()) break;
            target = source.substring(afterRightBraceIndex);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "parseCopiesFileListAsOldVersion"));
        }
        return hashMap;
    }

    private static int findRightBracePosition(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/zmlx/hg4idea/log/HgFileRevisionLogParser", "findRightBracePosition"));
        }
        int len = str.length();
        int depth = 1;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
            if (depth != 0) continue;
            return i + 1;
        }
        LOG.info("Unexpected output during parse copied files in log command " + str);
        return -1;
    }
}

