/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;

public class HgRunConflictResolverDialog
extends DialogWrapper {
    private JPanel mainPanel;
    private HgRepositorySelectorComponent repositorySelector;
    private JList conflictsList;
    private final Project project;

    public HgRunConflictResolverDialog(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/ui/HgRunConflictResolverDialog", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/ui/HgRunConflictResolverDialog", "<init>"));
        }
        super(project, false);
        this.project = project;
        this.$$$setupUI$$$();
        this.repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgRunConflictResolverDialog.this.onChangeRepository();
            }
        });
        this.setTitle("Resolve Conflicts");
        this.init();
        this.setRoots(repositories, selectedRepo);
    }

    @NotNull
    public HgRepository getRepository() {
        HgRepository hgRepository = this.repositorySelector.getRepository();
        if (hgRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgRunConflictResolverDialog", "getRepository"));
        }
        return hgRepository;
    }

    private void setRoots(@NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/ui/HgRunConflictResolverDialog", "setRoots"));
        }
        this.repositorySelector.setRoots(repositories);
        this.repositorySelector.setSelectedRoot(selectedRepo);
        this.onChangeRepository();
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    private void onChangeRepository() {
        VirtualFile repo = this.repositorySelector.getRepository().getRoot();
        HgResolveCommand command = new HgResolveCommand(this.project);
        final ModalityState modalityState = ApplicationManager.getApplication().getModalityStateForComponent((Component)this.getRootPane());
        command.getListAsynchronously(repo, new Consumer<Map<HgFile, HgResolveStatusEnum>>(){

            public void consume(Map<HgFile, HgResolveStatusEnum> status) {
                final DefaultListModel<String> model = new DefaultListModel<String>();
                for (Map.Entry<HgFile, HgResolveStatusEnum> entry : status.entrySet()) {
                    if (entry.getValue() != HgResolveStatusEnum.UNRESOLVED) continue;
                    model.addElement(entry.getKey().getRelativePath());
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HgRunConflictResolverDialog.this.setOKActionEnabled(!model.isEmpty());
                        if (model.isEmpty()) {
                            model.addElement("No conflicts to resolve");
                        }
                        HgRunConflictResolverDialog.this.conflictsList.setModel(model);
                    }
                }, modalityState);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.repositorySelector = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Files with conflicts", (int)0, (int)0, null, null));
        JBList jBList = new JBList();
        this.conflictsList = jBList;
        jPanel2.add((Component)jBList, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 150), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

