/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringStore {
    private final Map<String, Integer> stringMap = new HashMap<String, Integer>();
    public final List<String> strings = new ArrayList<String>();

    public int addString(String s) {
        Integer index = this.stringMap.get(s);
        if (index == null) {
            index = this.strings.size();
            this.strings.add(s);
            this.stringMap.put(s, index);
        }
        return index;
    }

    public void writeBinary(DataOutputStream os) throws IOException {
        os.writeShort(this.strings.size());
        if (this.stringMap.containsKey(null)) {
            Integer index = this.stringMap.get(null);
            os.writeShort(index);
        } else {
            os.writeShort(-1);
        }
        for (int n = 0; n < this.strings.size(); ++n) {
            String s = this.strings.get(n);
            if (s == null) continue;
            os.writeUTF(s);
        }
    }

    static String[] readBinary(DataInputStream is) throws IOException {
        int nStrings = is.readShort();
        short nullIndex = is.readShort();
        Object[] strings = new String[nStrings];
        Arrays.fill(strings, null);
        for (int n = 0; n < nStrings; ++n) {
            if (n == nullIndex) continue;
            strings[n] = is.readUTF();
        }
        return strings;
    }
}

