/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.builder;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import javafx.util.Builder;

public class URLBuilder
extends AbstractMap<String, Object>
implements Builder<URL> {
    private ClassLoader classLoader;
    private Object value = null;
    public static final String VALUE_KEY = "value";

    public URLBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!key.equals(VALUE_KEY)) {
            throw new IllegalArgumentException(key + " is not a valid property.");
        }
        this.value = value;
        return null;
    }

    @Override
    public URL build() {
        URL url;
        if (this.value == null) {
            throw new IllegalStateException();
        }
        if (this.value instanceof URL) {
            url = (URL)this.value;
        } else {
            String spec = this.value.toString();
            if (spec.startsWith("/")) {
                url = this.classLoader.getResource(spec);
            } else {
                try {
                    url = new URL(spec);
                }
                catch (MalformedURLException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return url;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

