/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.PixelSetter;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.tk.Toolkit;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;

public class ByteIndexed {
    public static BytePixelGetter createGetter(PixelFormat<ByteBuffer> pf) {
        return new Getter(pf);
    }

    public static ByteToBytePixelConverter createToByteBgraAny(BytePixelGetter src, BytePixelSetter dst) {
        return new ToByteBgraAnyConverter(src, dst);
    }

    public static ByteToIntPixelConverter createToIntArgbAny(BytePixelGetter src, IntPixelSetter dst) {
        return new ToIntArgbAnyConverter(src, dst);
    }

    static int[] getColors(BytePixelGetter getter, PixelSetter setter) {
        Getter big = (Getter)getter;
        return setter.getAlphaType() == AlphaType.PREMULTIPLIED ? big.getPreColors() : big.getNonPreColors();
    }

    public static class ToIntArgbAnyConverter
    extends BaseByteToIntConverter {
        public ToIntArgbAnyConverter(BytePixelGetter getter, IntPixelSetter setter) {
            super(getter, setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
            int[] colors = ByteIndexed.getColors(this.getGetter(), this.getSetter());
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    dstarr[dstoff + x] = colors[srcarr[srcoff + x] & 0xFF];
                }
                srcoff += srcscanbytes;
                dstoff += dstscanints;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
            int[] colors = ByteIndexed.getColors(this.getGetter(), this.getSetter());
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    dstbuf.put(dstoff + x, colors[srcbuf.get(srcoff + x) & 0xFF]);
                }
                srcoff += srcscanbytes;
                dstoff += dstscanints;
            }
        }
    }

    public static class ToByteBgraAnyConverter
    extends BaseByteToByteConverter {
        public ToByteBgraAnyConverter(BytePixelGetter getter, BytePixelSetter setter) {
            super(getter, setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            int[] colors = ByteIndexed.getColors(this.getGetter(), this.getSetter());
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int argb = colors[srcarr[srcoff + x] & 0xFF];
                    dstarr[dstoff++] = (byte)argb;
                    dstarr[dstoff++] = (byte)(argb >> 8);
                    dstarr[dstoff++] = (byte)(argb >> 16);
                    dstarr[dstoff++] = (byte)(argb >> 24);
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            int[] colors = ByteIndexed.getColors(this.getGetter(), this.getSetter());
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int argb = colors[srcbuf.get(srcoff + x) & 0xFF];
                    dstbuf.put(dstoff, (byte)argb);
                    dstbuf.put(dstoff + 1, (byte)(argb >> 8));
                    dstbuf.put(dstoff + 2, (byte)(argb >> 16));
                    dstbuf.put(dstoff + 3, (byte)(argb >> 24));
                    dstoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    public static class Getter
    implements BytePixelGetter {
        PixelFormat<ByteBuffer> theFormat;
        private int[] precolors;
        private int[] nonprecolors;

        Getter(PixelFormat<ByteBuffer> pf) {
            this.theFormat = pf;
        }

        int[] getPreColors() {
            if (this.precolors == null) {
                this.precolors = Toolkit.getImageAccessor().getPreColors(this.theFormat);
            }
            return this.precolors;
        }

        int[] getNonPreColors() {
            if (this.nonprecolors == null) {
                this.nonprecolors = Toolkit.getImageAccessor().getNonPreColors(this.theFormat);
            }
            return this.nonprecolors;
        }

        @Override
        public AlphaType getAlphaType() {
            return this.theFormat.isPremultiplied() ? AlphaType.PREMULTIPLIED : AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 1;
        }

        @Override
        public int getArgb(byte[] arr, int offset) {
            return this.getNonPreColors()[arr[offset] & 0xFF];
        }

        @Override
        public int getArgbPre(byte[] arr, int offset) {
            return this.getPreColors()[arr[offset] & 0xFF];
        }

        @Override
        public int getArgb(ByteBuffer buf, int offset) {
            return this.getNonPreColors()[buf.get(offset) & 0xFF];
        }

        @Override
        public int getArgbPre(ByteBuffer buf, int offset) {
            return this.getPreColors()[buf.get(offset) & 0xFF];
        }
    }
}

