/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.glass.ui.Accessible;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;

public final class SceneHelper {
    private static SceneAccessor sceneAccessor;

    private SceneHelper() {
    }

    public static void setPaused(boolean paused) {
        sceneAccessor.setPaused(paused);
    }

    public static void parentEffectiveOrientationInvalidated(Scene scene) {
        sceneAccessor.parentEffectiveOrientationInvalidated(scene);
    }

    public static Camera getEffectiveCamera(Scene scene) {
        return sceneAccessor.getEffectiveCamera(scene);
    }

    public static Scene createPopupScene(Parent root) {
        return sceneAccessor.createPopupScene(root);
    }

    public static Accessible getAccessible(Scene scene) {
        return sceneAccessor.getAccessible(scene);
    }

    public static void setSceneAccessor(SceneAccessor newAccessor) {
        if (sceneAccessor != null) {
            throw new IllegalStateException();
        }
        sceneAccessor = newAccessor;
    }

    public static SceneAccessor getSceneAccessor() {
        if (sceneAccessor == null) {
            throw new IllegalStateException();
        }
        return sceneAccessor;
    }

    private static void forceInit(Class<?> classToInit) {
        try {
            Class.forName(classToInit.getName(), true, classToInit.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        SceneHelper.forceInit(Scene.class);
    }

    public static interface SceneAccessor {
        public void setPaused(boolean var1);

        public void parentEffectiveOrientationInvalidated(Scene var1);

        public Camera getEffectiveCamera(Scene var1);

        public Scene createPopupScene(Parent var1);

        public void setTransientFocusContainer(Scene var1, Node var2);

        public Accessible getAccessible(Scene var1);
    }
}

