/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.Accordion;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class AccordionBehavior
extends BehaviorBase<Accordion> {
    private AccordionFocusModel focusModel;
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String PAGE_UP = "Page_Up";
    private static final String PAGE_DOWN = "Page_Down";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> ACCORDION_BINDINGS = new ArrayList<KeyBinding>();

    public AccordionBehavior(Accordion accordion) {
        super(accordion, ACCORDION_BINDINGS);
        this.focusModel = new AccordionFocusModel(accordion);
    }

    @Override
    public void dispose() {
        this.focusModel.dispose();
        super.dispose();
    }

    @Override
    protected void callAction(String name) {
        boolean rtl;
        Accordion accordion = (Accordion)this.getControl();
        boolean bl = rtl = accordion.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        if ("TraverseLeft".equals(name) && !rtl || "TraverseRight".equals(name) && rtl || "TraverseUp".equals(name) || PAGE_UP.equals(name)) {
            if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                this.focusModel.focusPrevious();
                int next = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(next)).requestFocus();
                if (PAGE_UP.equals(name)) {
                    ((TitledPane)accordion.getPanes().get(next)).setExpanded(true);
                }
            }
        } else if ("TraverseRight".equals(name) && !rtl || "TraverseLeft".equals(name) && rtl || "TraverseDown".equals(name) || PAGE_DOWN.equals(name)) {
            if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                this.focusModel.focusNext();
                int next = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(next)).requestFocus();
                if (PAGE_DOWN.equals(name)) {
                    ((TitledPane)accordion.getPanes().get(next)).setExpanded(true);
                }
            }
        } else if (CTRL_TAB.equals(name) || CTRL_PAGE_DOWN.equals(name)) {
            this.focusModel.focusNext();
            if (this.focusModel.getFocusedIndex() != -1) {
                int next = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(next)).requestFocus();
                ((TitledPane)accordion.getPanes().get(next)).setExpanded(true);
            }
        } else if (CTRL_SHIFT_TAB.equals(name) || CTRL_PAGE_UP.equals(name)) {
            this.focusModel.focusPrevious();
            if (this.focusModel.getFocusedIndex() != -1) {
                int next = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(next)).requestFocus();
                ((TitledPane)accordion.getPanes().get(next)).setExpanded(true);
            }
        } else if (HOME.equals(name)) {
            if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                TitledPane tp = (TitledPane)accordion.getPanes().get(0);
                tp.requestFocus();
                tp.setExpanded(!tp.isExpanded());
            }
        } else if (END.equals(name)) {
            if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                TitledPane tp = (TitledPane)accordion.getPanes().get(accordion.getPanes().size() - 1);
                tp.requestFocus();
                tp.setExpanded(!tp.isExpanded());
            }
        } else {
            super.callAction(name);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Accordion accordion = (Accordion)this.getControl();
        if (accordion.getPanes().size() > 0) {
            TitledPane lastTitledPane = (TitledPane)accordion.getPanes().get(accordion.getPanes().size() - 1);
            lastTitledPane.requestFocus();
        } else {
            accordion.requestFocus();
        }
    }

    static {
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, PAGE_UP));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, PAGE_DOWN));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }

    static class AccordionFocusModel
    extends FocusModel<TitledPane> {
        private final Accordion accordion;
        private final ChangeListener<Boolean> focusListener = new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    if (accordion.getExpandedPane() != null) {
                        accordion.getExpandedPane().requestFocus();
                    } else if (!accordion.getPanes().isEmpty()) {
                        ((TitledPane)accordion.getPanes().get(0)).requestFocus();
                    }
                }
            }
        };
        private final ChangeListener<Boolean> paneFocusListener = new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ReadOnlyBooleanProperty focusedProperty = (ReadOnlyBooleanProperty)observable;
                    TitledPane tp = (TitledPane)focusedProperty.getBean();
                    this.focus(accordion.getPanes().indexOf(tp));
                }
            }
        };
        private final ListChangeListener<TitledPane> panesListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    for (TitledPane tp : c.getAddedSubList()) {
                        tp.focusedProperty().addListener(this.paneFocusListener);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                for (TitledPane tp : c.getAddedSubList()) {
                    tp.focusedProperty().removeListener(this.paneFocusListener);
                }
            }
        };

        public AccordionFocusModel(Accordion accordion) {
            if (accordion == null) {
                throw new IllegalArgumentException("Accordion can not be null");
            }
            this.accordion = accordion;
            this.accordion.focusedProperty().addListener(this.focusListener);
            this.accordion.getPanes().addListener(this.panesListener);
            for (TitledPane tp : this.accordion.getPanes()) {
                tp.focusedProperty().addListener(this.paneFocusListener);
            }
        }

        void dispose() {
            this.accordion.focusedProperty().removeListener(this.focusListener);
            this.accordion.getPanes().removeListener(this.panesListener);
            for (TitledPane tp : this.accordion.getPanes()) {
                tp.focusedProperty().removeListener(this.paneFocusListener);
            }
        }

        @Override
        protected int getItemCount() {
            ObservableList<TitledPane> panes = this.accordion.getPanes();
            return panes == null ? 0 : panes.size();
        }

        @Override
        protected TitledPane getModelItem(int row) {
            ObservableList<TitledPane> panes = this.accordion.getPanes();
            if (panes == null) {
                return null;
            }
            if (row < 0) {
                return null;
            }
            return (TitledPane)panes.get(row % panes.size());
        }

        @Override
        public void focusPrevious() {
            if (this.getFocusedIndex() <= 0) {
                this.focus(this.accordion.getPanes().size() - 1);
            } else {
                this.focus((this.getFocusedIndex() - 1) % this.accordion.getPanes().size());
            }
        }

        @Override
        public void focusNext() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else {
                this.focus((this.getFocusedIndex() + 1) % this.accordion.getPanes().size());
            }
        }
    }
}

