/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ComboBoxListViewBehavior<T>
extends ComboBoxBaseBehavior<T> {
    protected static final List<KeyBinding> COMBO_BOX_BINDINGS = new ArrayList<KeyBinding>();

    public ComboBoxListViewBehavior(ComboBox<T> comboBox) {
        super(comboBox, COMBO_BOX_BINDINGS);
    }

    @Override
    protected void callAction(String name) {
        if ("selectPrevious".equals(name)) {
            this.selectPrevious();
        } else if ("selectNext".equals(name)) {
            this.selectNext();
        } else {
            super.callAction(name);
        }
    }

    private ComboBox<T> getComboBox() {
        return (ComboBox)this.getControl();
    }

    private void selectPrevious() {
        SingleSelectionModel<T> sm = this.getComboBox().getSelectionModel();
        if (sm == null) {
            return;
        }
        ((SelectionModel)sm).selectPrevious();
    }

    private void selectNext() {
        SingleSelectionModel<T> sm = this.getComboBox().getSelectionModel();
        if (sm == null) {
            return;
        }
        ((SelectionModel)sm).selectNext();
    }

    static {
        COMBO_BOX_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "selectPrevious"));
        COMBO_BOX_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "selectNext"));
        COMBO_BOX_BINDINGS.addAll(COMBO_BOX_BASE_BINDINGS);
    }
}

