/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class TextBinding {
    private String MNEMONIC_SYMBOL = "_";
    private String text = null;
    private String mnemonic = null;
    private KeyCombination mnemonicKeyCombination = null;
    private int mnemonicIndex = -1;
    private String extendedMnemonicText = null;

    public String getText() {
        return this.text;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public KeyCombination getMnemonicKeyCombination() {
        if (this.mnemonic != null && this.mnemonicKeyCombination == null) {
            this.mnemonicKeyCombination = new MnemonicKeyCombination(this.mnemonic);
        }
        return this.mnemonicKeyCombination;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getExtendedMnemonicText() {
        return this.extendedMnemonicText;
    }

    public TextBinding(String s) {
        this.parseAndSplit(s);
    }

    private void parseAndSplit(String s) {
        if (s == null || s.length() == 0) {
            this.text = s;
            return;
        }
        StringBuffer temp = new StringBuffer(s);
        int index = temp.indexOf(this.MNEMONIC_SYMBOL);
        while (index >= 0 && index < temp.length() - 1) {
            if (this.MNEMONIC_SYMBOL.equals(temp.substring(index + 1, index + 2))) {
                temp.delete(index, index + 1);
            } else {
                if (temp.charAt(index + 1) != '(' || index == temp.length() - 2) {
                    this.mnemonic = temp.substring(index + 1, index + 2);
                    if (this.mnemonic != null) {
                        this.mnemonicIndex = index;
                    }
                    temp.delete(index, index + 1);
                    break;
                }
                int endIndex = temp.indexOf(")", index + 3);
                if (endIndex == -1) {
                    this.mnemonic = temp.substring(index + 1, index + 2);
                    if (this.mnemonic != null) {
                        this.mnemonicIndex = index;
                    }
                    temp.delete(index, index + 1);
                    break;
                }
                if (endIndex == index + 3) {
                    this.mnemonic = temp.substring(index + 2, index + 3);
                    this.extendedMnemonicText = temp.substring(index + 1, index + 4);
                    temp.delete(index, endIndex + 3);
                    break;
                }
            }
            index = temp.indexOf(this.MNEMONIC_SYMBOL, index + 1);
        }
        this.text = temp.toString();
    }

    public static class MnemonicKeyCombination
    extends KeyCombination {
        private String character = "";

        public MnemonicKeyCombination(String character) {
            super(PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
            this.character = character;
        }

        public final String getCharacter() {
            return this.character;
        }

        @Override
        public boolean match(KeyEvent event) {
            String text = event.getText();
            return text != null && !text.isEmpty() && text.equalsIgnoreCase(this.getCharacter()) && super.match(event);
        }

        @Override
        public String getName() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getName());
            if (sb.length() > 0) {
                sb.append("+");
            }
            return sb.append('\'').append(this.character.replace("'", "\\'")).append('\'').toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MnemonicKeyCombination)) {
                return false;
            }
            return this.character.equals(((MnemonicKeyCombination)obj).getCharacter()) && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return 23 * super.hashCode() + this.character.hashCode();
        }
    }
}

