/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class TableViewSkin<T>
extends TableViewSkinBase<T, T, TableView<T>, TableViewBehavior<T>, TableRow<T>, TableColumn<T, ?>> {
    private final TableView<T> tableView;

    public TableViewSkin(TableView<T> tableView) {
        super(tableView, new TableViewBehavior<T>(tableView));
        this.tableView = tableView;
        this.flow.setFixedCellSize(tableView.getFixedCellSize());
        super.init(tableView);
        EventHandler<MouseEvent> ml = event -> {
            if (tableView.getEditingCell() != null) {
                tableView.edit(-1, null);
            }
            if (tableView.isFocusTraversable()) {
                tableView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        TableViewBehavior behavior = (TableViewBehavior)this.getBehavior();
        behavior.setOnFocusPreviousRow(() -> this.onFocusPreviousCell());
        behavior.setOnFocusNextRow(() -> this.onFocusNextCell());
        behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        behavior.setOnScrollPageDown(isFocusDriven -> this.onScrollPageDown((boolean)isFocusDriven));
        behavior.setOnScrollPageUp(isFocusDriven -> this.onScrollPageUp((boolean)isFocusDriven));
        behavior.setOnSelectPreviousRow(() -> this.onSelectPreviousCell());
        behavior.setOnSelectNextRow(() -> this.onSelectNextCell());
        behavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        behavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        this.registerChangeListener(tableView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("FIXED_CELL_SIZE".equals(p)) {
            this.flow.setFixedCellSize(((TableView)this.getSkinnable()).getFixedCellSize());
        }
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return this.tableView.getVisibleLeafColumns();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumn<T, ?> tc) {
        return this.tableView.getVisibleLeafIndex(tc);
    }

    @Override
    protected TableColumn<T, ?> getVisibleLeafColumn(int col) {
        return this.tableView.getVisibleLeafColumn(col);
    }

    protected TableView.TableViewFocusModel<T> getFocusModel() {
        return this.tableView.getFocusModel();
    }

    protected TablePosition<T, ?> getFocusedCell() {
        return this.tableView.getFocusModel().getFocusedCell();
    }

    @Override
    protected TableSelectionModel<T> getSelectionModel() {
        return this.tableView.getSelectionModel();
    }

    @Override
    protected ObjectProperty<Callback<TableView<T>, TableRow<T>>> rowFactoryProperty() {
        return this.tableView.rowFactoryProperty();
    }

    @Override
    protected ObjectProperty<Node> placeholderProperty() {
        return this.tableView.placeholderProperty();
    }

    @Override
    protected ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.tableView.itemsProperty();
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getColumns() {
        return this.tableView.getColumns();
    }

    @Override
    protected BooleanProperty tableMenuButtonVisibleProperty() {
        return this.tableView.tableMenuButtonVisibleProperty();
    }

    @Override
    protected ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty() {
        return this.tableView.columnResizePolicyProperty();
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getSortOrder() {
        return this.tableView.getSortOrder();
    }

    @Override
    protected boolean resizeColumn(TableColumn<T, ?> tc, double delta) {
        return this.tableView.resizeColumn(tc, delta);
    }

    @Override
    protected void edit(int index, TableColumn<T, ?> column) {
        this.tableView.edit(index, column);
    }

    @Override
    protected void resizeColumnToFitContent(TableColumn<T, ?> tc, int maxRows) {
        Node n;
        if (!tc.isResizable()) {
            return;
        }
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback<TableColumn<T, ?>, TableCell<T, ?>> cellFactory = tc.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TableCell<T, ?> cell = cellFactory.call(tc);
        if (cell == null) {
            return;
        }
        cell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows);
        double maxWidth = 0.0;
        for (int row = 0; row < rows; ++row) {
            cell.updateTableColumn(tc);
            cell.updateTableView(this.tableView);
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add(cell);
            cell.applyCss();
            maxWidth = Math.max(maxWidth, cell.prefWidth(-1.0));
            this.getChildren().remove(cell);
        }
        cell.updateIndex(-1);
        TableColumnHeader header = this.getTableHeaderRow().getColumnHeaderFor(tc);
        double headerTextWidth = Utils.computeTextWidth(header.label.getFont(), tc.getText(), -1.0);
        Node graphic = header.label.getGraphic();
        double headerGraphicWidth = graphic == null ? 0.0 : graphic.prefWidth(-1.0) + header.label.getGraphicTextGap();
        double headerWidth = headerTextWidth + headerGraphicWidth + 10.0 + header.snappedLeftInset() + header.snappedRightInset();
        maxWidth = Math.max(maxWidth, headerWidth);
        maxWidth += padding;
        if (this.tableView.getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            maxWidth = Math.max(maxWidth, tc.getWidth());
        }
        tc.impl_setWidth(maxWidth);
    }

    @Override
    public int getItemCount() {
        return this.tableView.getItems() == null ? 0 : this.tableView.getItems().size();
    }

    @Override
    public TableRow<T> createCell() {
        TableRow<T> cell = this.tableView.getRowFactory() != null ? this.tableView.getRowFactory().call(this.tableView) : new TableRow<T>();
        cell.updateTableView(this.tableView);
        return cell;
    }

    @Override
    protected void horizontalScroll() {
        super.horizontalScroll();
        if (((TableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case SELECTED_ITEMS: {
                ArrayList<TableRow> selection = new ArrayList<TableRow>();
                TableView.TableViewSelectionModel sm = ((TableView)this.getSkinnable()).getSelectionModel();
                for (TablePosition pos : sm.getSelectedCells()) {
                    TableRow row = (TableRow)this.flow.getPrivateCell(pos.getRow());
                    if (row == null) continue;
                    selection.add(row);
                }
                return FXCollections.observableArrayList(selection);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_ITEM: {
                Node item = (Node)parameters[0];
                if (!(item instanceof TableCell)) break;
                TableCell cell = (TableCell)item;
                this.flow.show(cell.getIndex());
                break;
            }
            case SET_SELECTED_ITEMS: {
                TableView.TableViewSelectionModel sm;
                ObservableList items = (ObservableList)parameters[0];
                if (items == null || (sm = ((TableView)this.getSkinnable()).getSelectionModel()) == null) break;
                sm.clearSelection();
                for (Node item : items) {
                    if (!(item instanceof TableCell)) continue;
                    TableCell cell = (TableCell)item;
                    ((TableSelectionModel)sm).select(cell.getIndex(), cell.getTableColumn());
                }
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }
}

