/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CachingCompoundImage;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;

public class NGImageView
extends NGNode {
    private Image image;
    private CachingCompoundImage compoundImage;
    private CompoundCoords compoundCoords;
    private float x;
    private float y;
    private float w;
    private float h;
    private Coords coords;
    private ViewPort reqviewport;
    private ViewPort imgviewport;
    private boolean renderable = false;
    private boolean coordsOK = false;
    static final int MAX_SIZE_OVERRIDE = 0;

    private void invalidate() {
        this.coordsOK = false;
        this.coords = null;
        this.compoundCoords = null;
        this.imgviewport = null;
        this.geometryChanged();
    }

    public void setViewport(float vx, float vy, float vw, float vh, float cw, float ch) {
        this.reqviewport = vw > 0.0f && vh > 0.0f ? new ViewPort(vx, vy, vw, vh) : null;
        this.w = cw;
        this.h = ch;
        this.invalidate();
    }

    private void calculatePositionAndClipping() {
        this.renderable = false;
        this.coordsOK = true;
        if (this.reqviewport == null || this.image == null) {
            this.renderable = this.image != null;
            return;
        }
        float iw = this.image.getWidth();
        float ih = this.image.getHeight();
        if (iw == 0.0f || ih == 0.0f) {
            return;
        }
        this.imgviewport = this.reqviewport.getScaledVersion(this.image.getPixelScale());
        this.coords = this.imgviewport.getClippedCoords(iw, ih, this.w, this.h);
        this.renderable = this.coords != null;
    }

    @Override
    protected void doRender(Graphics g) {
        if (!this.coordsOK) {
            this.calculatePositionAndClipping();
        }
        if (this.renderable) {
            super.doRender(g);
        }
    }

    private int maxSizeWrapper(ResourceFactory factory) {
        return factory.getMaximumTextureSize();
    }

    @Override
    protected void renderContent(Graphics g) {
        int imgW = this.image.getWidth();
        int imgH = this.image.getHeight();
        ResourceFactory factory = g.getResourceFactory();
        int maxSize = this.maxSizeWrapper(factory);
        if (imgW <= maxSize && imgH <= maxSize) {
            Texture texture = factory.getCachedTexture(this.image, Texture.WrapMode.CLAMP_TO_EDGE);
            if (this.coords == null) {
                g.drawTexture(texture, this.x, this.y, this.x + this.w, this.y + this.h, 0.0f, 0.0f, imgW, imgH);
            } else {
                this.coords.draw(texture, g, this.x, this.y);
            }
            texture.unlock();
        } else {
            if (this.compoundImage == null) {
                this.compoundImage = new CachingCompoundImage(this.image, maxSize);
            }
            if (this.coords == null) {
                this.coords = new Coords(this.w, this.h, new ViewPort(0.0f, 0.0f, imgW, imgH));
            }
            if (this.compoundCoords == null) {
                this.compoundCoords = new CompoundCoords(this.compoundImage, this.coords);
            }
            this.compoundCoords.draw(g, this.compoundImage, this.x, this.y);
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    public void setImage(Object img) {
        Image newImage = (Image)img;
        if (this.image == newImage) {
            return;
        }
        boolean needsInvalidate = newImage == null || this.image == null || this.image.getPixelScale() != newImage.getPixelScale() || this.image.getHeight() != newImage.getHeight() || this.image.getWidth() != newImage.getWidth();
        this.image = newImage;
        this.compoundImage = null;
        if (needsInvalidate) {
            this.invalidate();
        }
    }

    public void setX(float x) {
        if (this.x != x) {
            this.x = x;
            this.geometryChanged();
        }
    }

    public void setY(float y) {
        if (this.y != y) {
            this.y = y;
            this.geometryChanged();
        }
    }

    public void setSmooth(boolean s) {
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        assert (this.image == null || this.image.getWidth() >= 1 && this.image.getHeight() >= 1);
        return super.hasOpaqueRegion() && this.w >= 1.0f && this.h >= 1.0f && this.image != null && this.image.isOpaque();
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        return (RectBounds)opaqueRegion.deriveWithNewBounds(this.x, this.y, 0.0f, this.x + this.w, this.y + this.h, 0.0f);
    }
}

