/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.text.TextRun;

public class TextLine
implements com.sun.javafx.scene.text.TextLine {
    TextRun[] runs;
    RectBounds bounds;
    float lsb;
    float rsb;
    float leading;
    int start;
    int length;

    public TextLine(int start, int length, TextRun[] runs, float width, float ascent, float descent, float leading) {
        this.start = start;
        this.length = length;
        this.bounds = new RectBounds(0.0f, ascent, width, descent + leading);
        this.leading = leading;
        this.runs = runs;
    }

    @Override
    public RectBounds getBounds() {
        return this.bounds;
    }

    public float getLeading() {
        return this.leading;
    }

    public TextRun[] getRuns() {
        return this.runs;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setSideBearings(float lsb, float rsb) {
        this.lsb = lsb;
        this.rsb = rsb;
    }

    @Override
    public float getLeftSideBearing() {
        return this.lsb;
    }

    @Override
    public float getRightSideBearing() {
        return this.rsb;
    }

    public void setAlignment(float x) {
        this.bounds.setMinX(x);
        this.bounds.setMaxX(x + this.bounds.getMaxX());
    }

    public void setWidth(float width) {
        this.bounds.setMaxX(this.bounds.getMinX() + width);
    }
}

