/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.UIClient;
import com.sun.webkit.WebPage;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCRectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public final class UIClientImpl
implements UIClient {
    private final Accessor accessor;
    private FileChooser chooser;
    private ClipboardContent content;
    private static final DataFormat DF_DRAG_IMAGE = UIClientImpl.getDataFormat("application/x-java-drag-image");
    private static final DataFormat DF_DRAG_IMAGE_OFFSET = UIClientImpl.getDataFormat("application/x-java-drag-image-offset");

    public UIClientImpl(Accessor accessor) {
        this.accessor = accessor;
    }

    private WebEngine getWebEngine() {
        return this.accessor.getEngine();
    }

    private AccessControlContext getAccessContext() {
        return this.accessor.getPage().getAccessControlContext();
    }

    @Override
    public WebPage createPage(boolean menu, boolean status, boolean toolbar, boolean resizable) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getCreatePopupHandler() != null) {
            PopupFeatures pf = new PopupFeatures(menu, status, toolbar, resizable);
            WebEngine popup = AccessController.doPrivileged(() -> w.getCreatePopupHandler().call(pf), this.getAccessContext());
            return Accessor.getPageFor(popup);
        }
        return null;
    }

    private void dispatchWebEvent(EventHandler handler, WebEvent ev) {
        AccessController.doPrivileged(() -> {
            handler.handle(ev);
            return null;
        }, this.getAccessContext());
    }

    private void notifyVisibilityChanged(boolean visible) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getOnVisibilityChanged() != null) {
            this.dispatchWebEvent(w.getOnVisibilityChanged(), new WebEvent<Boolean>((Object)w, WebEvent.VISIBILITY_CHANGED, visible));
        }
    }

    @Override
    public void closePage() {
        this.notifyVisibilityChanged(false);
    }

    @Override
    public void showView() {
        this.notifyVisibilityChanged(true);
    }

    @Override
    public WCRectangle getViewBounds() {
        WebView view = this.accessor.getView();
        Window win = null;
        if (view != null && view.getScene() != null && (win = view.getScene().getWindow()) != null) {
            return new WCRectangle((float)win.getX(), (float)win.getY(), (float)win.getWidth(), (float)win.getHeight());
        }
        return null;
    }

    @Override
    public void setViewBounds(WCRectangle r) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getOnResized() != null) {
            this.dispatchWebEvent(w.getOnResized(), new WebEvent<Rectangle2D>((Object)w, WebEvent.RESIZED, new Rectangle2D(r.getX(), r.getY(), r.getWidth(), r.getHeight())));
        }
    }

    @Override
    public void setStatusbarText(String text) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getOnStatusChanged() != null) {
            this.dispatchWebEvent(w.getOnStatusChanged(), new WebEvent<String>((Object)w, WebEvent.STATUS_CHANGED, text));
        }
    }

    @Override
    public void alert(String text) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getOnAlert() != null) {
            this.dispatchWebEvent(w.getOnAlert(), new WebEvent<String>((Object)w, WebEvent.ALERT, text));
        }
    }

    @Override
    public boolean confirm(String text) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getConfirmHandler() != null) {
            return AccessController.doPrivileged(() -> w.getConfirmHandler().call(text), this.getAccessContext());
        }
        return false;
    }

    @Override
    public String prompt(String text, String defaultValue) {
        WebEngine w = this.getWebEngine();
        if (w != null && w.getPromptHandler() != null) {
            PromptData data = new PromptData(text, defaultValue);
            return AccessController.doPrivileged(() -> w.getPromptHandler().call(data), this.getAccessContext());
        }
        return "";
    }

    @Override
    public String[] chooseFile(String initialFileName, boolean multiple) {
        String[] stringArray;
        Window win = null;
        WebView view = this.accessor.getView();
        if (view != null && view.getScene() != null) {
            win = view.getScene().getWindow();
        }
        if (this.chooser == null) {
            this.chooser = new FileChooser();
        }
        if (initialFileName != null) {
            File dir;
            for (dir = new File(initialFileName); dir != null && !dir.isDirectory(); dir = dir.getParentFile()) {
            }
            this.chooser.setInitialDirectory(dir);
        }
        if (multiple) {
            List<File> files = this.chooser.showOpenMultipleDialog(win);
            if (files != null) {
                int n = files.size();
                String[] result = new String[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = files.get(i).getAbsolutePath();
                }
                return result;
            }
            return null;
        }
        File f = this.chooser.showOpenDialog(win);
        if (f != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = f.getAbsolutePath();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public void print() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataFormat getDataFormat(String mimeType) {
        Class<DataFormat> clazz = DataFormat.class;
        synchronized (DataFormat.class) {
            DataFormat ret = DataFormat.lookupMimeType(mimeType);
            if (ret == null) {
                ret = new DataFormat(mimeType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    @Override
    public void startDrag(WCImage image, int imageOffsetX, int imageOffsetY, int eventPosX, int eventPosY, String[] mimeTypes, Object[] values) {
        this.content = new ClipboardContent();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (values[i] == null) continue;
            try {
                this.content.put(UIClientImpl.getDataFormat(mimeTypes[i]), "text/ie-shortcut-filename".equals(mimeTypes[i]) ? ByteBuffer.wrap(((String)values[i]).getBytes("UTF-16LE")) : values[i]);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (image != null) {
            Object platformImage;
            ByteBuffer dragImageOffset = ByteBuffer.allocate(8);
            dragImageOffset.rewind();
            dragImageOffset.putInt(imageOffsetX);
            dragImageOffset.putInt(imageOffsetY);
            this.content.put(DF_DRAG_IMAGE_OFFSET, dragImageOffset);
            int w = image.getWidth();
            int h = image.getHeight();
            ByteBuffer pixels = image.getPixelBuffer();
            ByteBuffer dragImage = ByteBuffer.allocate(8 + w * h * 4);
            dragImage.putInt(w);
            dragImage.putInt(h);
            dragImage.put(pixels);
            this.content.put(DF_DRAG_IMAGE, dragImage);
            Object object = platformImage = image.getWidth() > 0 && image.getHeight() > 0 ? image.getPlatformImage() : null;
            if (platformImage != null) {
                try {
                    File temp = File.createTempFile("jfx", ".png");
                    temp.deleteOnExit();
                    ImageIO.write((RenderedImage)UIClientImpl.toBufferedImage(Image.impl_fromPlatformImage(Toolkit.getToolkit().loadPlatformImage(platformImage))), "png", temp);
                    this.content.put(DataFormat.FILES, Arrays.asList(temp));
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void confirmStartDrag() {
        WebView view = this.accessor.getView();
        if (view != null && this.content != null) {
            Dragboard db = view.startDragAndDrop(TransferMode.ANY);
            db.setContent(this.content);
        }
        this.content = null;
    }

    @Override
    public boolean isDragConfirmed() {
        return this.accessor.getView() != null && this.content != null;
    }

    public static BufferedImage toBufferedImage(Image img) {
        try {
            Class<?> swingFXUtilsCls = Class.forName("javafx.embed.swing.SwingFXUtils");
            Method m_fromFXImage = swingFXUtilsCls.getMethod("fromFXImage", Image.class, BufferedImage.class);
            Object bimg = m_fromFXImage.invoke(null, img, null);
            return (BufferedImage)bimg;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }
}

