/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Light;
import com.sun.prism.es2.ES2MeshView;
import com.sun.prism.es2.ES2PhongMaterial;
import com.sun.prism.es2.ES2ResourceFactory;
import com.sun.prism.es2.ES2Shader;
import java.util.HashMap;

class ES2PhongShader {
    static ES2Shader[][][][][] shaders = null;
    static String vertexShaderSource;
    static String mainFragShaderSource;
    static final int lightStateCount = 4;
    private static String[] diffuseShaderParts;
    private static String[] specularShaderParts;
    private static String[] selfIllumShaderParts;
    private static String[] normalMapShaderParts;
    private static String[] lightingShaderParts;

    ES2PhongShader() {
    }

    static SpecularState getSpecularState(ES2PhongMaterial material) {
        if (material.maps[ES2PhongMaterial.SPECULAR].getTexture() != null) {
            return material.specularColorSet ? SpecularState.MIX : SpecularState.TEXTURE;
        }
        return material.specularColorSet ? SpecularState.COLOR : SpecularState.NONE;
    }

    static ES2Shader getShader(ES2MeshView meshView, ES2Context context) {
        ES2PhongMaterial material = meshView.getMaterial();
        DiffuseState diffuseState = DiffuseState.DIFFUSECOLOR;
        if (material.maps[ES2PhongMaterial.DIFFUSE].getTexture() != null) {
            diffuseState = DiffuseState.TEXTURE;
        }
        SpecularState specularState = ES2PhongShader.getSpecularState(material);
        BumpMapState bumpState = BumpMapState.NONE;
        if (material.maps[ES2PhongMaterial.BUMP].getTexture() != null) {
            bumpState = BumpMapState.TEXTURE;
        }
        SelfIllumState selfIllumState = SelfIllumState.NONE;
        if (material.maps[ES2PhongMaterial.SELF_ILLUM].getTexture() != null) {
            selfIllumState = SelfIllumState.TEXTURE;
        }
        int numLights = 0;
        for (ES2Light light : meshView.getPointLights()) {
            if (light == null || !(light.w > 0.0f)) continue;
            ++numLights;
        }
        ES2Shader shader = shaders[diffuseState.ordinal()][specularState.ordinal()][selfIllumState.ordinal()][bumpState.ordinal()][numLights];
        if (shader == null) {
            String fragShader = lightingShaderParts[numLights].replace("vec4 apply_diffuse();", diffuseShaderParts[diffuseState.ordinal()]);
            fragShader = fragShader.replace("vec4 apply_specular();", specularShaderParts[specularState.ordinal()]);
            fragShader = fragShader.replace("vec3 apply_normal();", normalMapShaderParts[bumpState.ordinal()]);
            fragShader = fragShader.replace("vec4 apply_selfIllum();", selfIllumShaderParts[selfIllumState.ordinal()]);
            String[] pixelShaders = new String[]{fragShader};
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            attributes.put("pos", 0);
            attributes.put("texCoords", 1);
            attributes.put("tangent", 2);
            HashMap<String, Integer> samplers = new HashMap<String, Integer>();
            samplers.put("diffuseTexture", 0);
            samplers.put("specularMap", 1);
            samplers.put("normalMap", 2);
            samplers.put("selfIllumTexture", 3);
            ES2PhongShader.shaders[diffuseState.ordinal()][specularState.ordinal()][selfIllumState.ordinal()][bumpState.ordinal()][numLights] = shader = ES2Shader.createFromSource(context, vertexShaderSource, pixelShaders, samplers, attributes, 1, false);
        }
        return shader;
    }

    static void setShaderParamaters(ES2Shader shader, ES2MeshView meshView, ES2Context context) {
        ES2PhongMaterial material = meshView.getMaterial();
        shader.setConstant("diffuseColor", material.diffuseColor.getRed(), material.diffuseColor.getGreen(), material.diffuseColor.getBlue(), material.diffuseColor.getAlpha());
        shader.setConstant("specularColor", material.specularColor.getRed(), material.specularColor.getGreen(), material.specularColor.getBlue(), material.specularColor.getAlpha());
        context.updateTexture(0, material.maps[ES2PhongMaterial.DIFFUSE].getTexture());
        context.updateTexture(1, material.maps[ES2PhongMaterial.SPECULAR].getTexture());
        context.updateTexture(2, material.maps[ES2PhongMaterial.BUMP].getTexture());
        context.updateTexture(3, material.maps[ES2PhongMaterial.SELF_ILLUM].getTexture());
        shader.setConstant("ambientColor", meshView.getAmbientLightRed(), meshView.getAmbientLightGreen(), meshView.getAmbientLightBlue());
        int i = 0;
        for (ES2Light light : meshView.getPointLights()) {
            if (light == null || !(light.w > 0.0f)) continue;
            shader.setConstant("lights[" + i + "].pos", light.x, light.y, light.z, light.w);
            shader.setConstant("lights[" + i + "].color", light.r, light.g, light.b);
            ++i;
        }
    }

    static {
        diffuseShaderParts = new String[DiffuseState.values().length];
        specularShaderParts = new String[SpecularState.values().length];
        selfIllumShaderParts = new String[SelfIllumState.values().length];
        normalMapShaderParts = new String[BumpMapState.values().length];
        lightingShaderParts = new String[4];
        shaders = new ES2Shader[DiffuseState.values().length][SpecularState.values().length][SelfIllumState.values().length][BumpMapState.values().length][4];
        ES2PhongShader.diffuseShaderParts[DiffuseState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_none.frag"));
        ES2PhongShader.diffuseShaderParts[DiffuseState.DIFFUSECOLOR.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_color.frag"));
        ES2PhongShader.diffuseShaderParts[DiffuseState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_texture.frag"));
        ES2PhongShader.specularShaderParts[SpecularState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_none.frag"));
        ES2PhongShader.specularShaderParts[SpecularState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_texture.frag"));
        ES2PhongShader.specularShaderParts[SpecularState.COLOR.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_color.frag"));
        ES2PhongShader.specularShaderParts[SpecularState.MIX.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_mix.frag"));
        ES2PhongShader.selfIllumShaderParts[SelfIllumState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/selfIllum_none.frag"));
        ES2PhongShader.selfIllumShaderParts[SelfIllumState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/selfIllum_texture.frag"));
        ES2PhongShader.normalMapShaderParts[BumpMapState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/normalMap_none.frag"));
        ES2PhongShader.normalMapShaderParts[BumpMapState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/normalMap_texture.frag"));
        ES2PhongShader.lightingShaderParts[0] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main0Lights.frag"));
        ES2PhongShader.lightingShaderParts[1] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main1Light.frag"));
        ES2PhongShader.lightingShaderParts[2] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main2Lights.frag"));
        ES2PhongShader.lightingShaderParts[3] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main3Lights.frag"));
        vertexShaderSource = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main.vert"));
    }

    static enum BumpMapState {
        NONE,
        TEXTURE;

    }

    static enum SelfIllumState {
        NONE,
        TEXTURE;

    }

    static enum SpecularState {
        NONE,
        TEXTURE,
        COLOR,
        MIX;

    }

    static enum DiffuseState {
        NONE,
        DIFFUSECOLOR,
        TEXTURE;

    }
}

