/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.paint.PaintUtil;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Gradient;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseContext {
    private final Screen screen;
    private final ResourceFactory factory;
    private final VertexBuffer vertexBuffer;
    private static final int MIN_MASK_DIM = 1024;
    private Texture maskTex;
    private ByteBuffer maskBuffer;
    private ByteBuffer clearBuffer;
    private int curMaskRow;
    private int nextMaskRow;
    private int curMaskCol;
    private int highMaskCol;
    private Texture paintTex;
    private int[] paintPixels;
    private ByteBuffer paintBuffer;
    private Texture rectTex;
    private int rectTexMax;
    private Texture wrapRectTex;
    private Texture ovalTex;
    private final Map<FontStrike, GlyphCache> greyGlyphCaches = new HashMap<FontStrike, GlyphCache>();
    private final Map<FontStrike, GlyphCache> lcdGlyphCaches = new HashMap<FontStrike, GlyphCache>();

    protected BaseContext(Screen screen, ResourceFactory factory, int vbQuads) {
        this.screen = screen;
        this.factory = factory;
        this.vertexBuffer = new VertexBuffer(this, vbQuads);
    }

    protected void setDeviceParametersFor2D() {
    }

    protected void setDeviceParametersFor3D() {
    }

    public Screen getAssociatedScreen() {
        return this.screen;
    }

    public ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void flushVertexBuffer() {
        this.vertexBuffer.flush();
    }

    protected final void flushMask() {
        if (this.curMaskRow > 0 || this.curMaskCol > 0) {
            this.maskTex.lock();
            this.maskTex.update(this.maskBuffer, this.maskTex.getPixelFormat(), 0, 0, 0, 0, this.highMaskCol, this.nextMaskRow, this.maskTex.getPhysicalWidth(), true);
            this.maskTex.unlock();
            this.highMaskCol = 0;
            this.nextMaskRow = 0;
            this.curMaskCol = 0;
            this.curMaskRow = 0;
        }
    }

    public void drawQuads(float[] coordArray, byte[] colorArray, int numVertices) {
        this.flushMask();
        this.renderQuads(coordArray, colorArray, numVertices);
    }

    protected abstract void renderQuads(float[] var1, byte[] var2, int var3);

    public void setRenderTarget(BaseGraphics g) {
        if (g != null) {
            this.setRenderTarget(g.getRenderTarget(), g.getCameraNoClone(), g.isDepthTest() && g.isDepthBuffer(), g.isState3D());
        } else {
            this.releaseRenderTarget();
        }
    }

    protected void releaseRenderTarget() {
    }

    protected abstract void setRenderTarget(RenderTarget var1, NGCamera var2, boolean var3, boolean var4);

    public abstract void validateClearOp(BaseGraphics var1);

    public abstract void validatePaintOp(BaseGraphics var1, BaseTransform var2, Texture var3, float var4, float var5, float var6, float var7);

    public abstract void validateTextureOp(BaseGraphics var1, BaseTransform var2, Texture var3, PixelFormat var4);

    public void clearGlyphCaches() {
        this.clearCaches(this.greyGlyphCaches);
        this.clearCaches(this.lcdGlyphCaches);
    }

    private void clearCaches(Map<FontStrike, GlyphCache> glyphCaches) {
        Iterator<FontStrike> iter = glyphCaches.keySet().iterator();
        while (iter.hasNext()) {
            iter.next().clearDesc();
        }
        for (GlyphCache cache : glyphCaches.values()) {
            if (cache == null) continue;
            cache.clear();
        }
        glyphCaches.clear();
    }

    public abstract RTTexture getLCDBuffer();

    public GlyphCache getGlyphCache(FontStrike strike) {
        Map<FontStrike, GlyphCache> glyphCaches = strike.getAAMode() == 1 ? this.lcdGlyphCaches : this.greyGlyphCaches;
        return this.getGlyphCache(strike, glyphCaches);
    }

    public boolean isSuperShaderEnabled() {
        return false;
    }

    private GlyphCache getGlyphCache(FontStrike strike, Map<FontStrike, GlyphCache> glyphCaches) {
        GlyphCache glyphCache = glyphCaches.get(strike);
        if (glyphCache == null) {
            glyphCache = new GlyphCache(this, strike);
            glyphCaches.put(strike, glyphCache);
        }
        return glyphCache;
    }

    public Texture validateMaskTexture(MaskData maskData, boolean canScale) {
        int pad = canScale ? 1 : 0;
        int needW = maskData.getWidth() + pad + pad;
        int needH = maskData.getHeight() + pad + pad;
        int texW = 0;
        int texH = 0;
        if (this.maskTex != null) {
            this.maskTex.lock();
            if (this.maskTex.isSurfaceLost()) {
                this.maskTex = null;
            } else {
                texW = this.maskTex.getContentWidth();
                texH = this.maskTex.getContentHeight();
            }
        }
        if (this.maskTex == null || texW < needW || texH < needH) {
            if (this.maskTex != null) {
                this.flushVertexBuffer();
                this.maskTex.dispose();
                this.maskTex = null;
            }
            this.maskBuffer = null;
            int newTexW = Math.max(1024, Math.max(needW, texW));
            int newTexH = Math.max(1024, Math.max(needH, texH));
            this.maskTex = this.getResourceFactory().createMaskTexture(newTexW, newTexH, Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.maskBuffer = ByteBuffer.allocate(newTexW * newTexH);
            if (this.clearBuffer == null || this.clearBuffer.capacity() < newTexW) {
                this.clearBuffer = null;
                this.clearBuffer = ByteBuffer.allocate(newTexW);
            }
            this.highMaskCol = 0;
            this.nextMaskRow = 0;
            this.curMaskCol = 0;
            this.curMaskRow = 0;
        }
        return this.maskTex;
    }

    public void updateMaskTexture(MaskData maskData, RectBounds maskBounds, boolean canScale) {
        this.maskTex.assertLocked();
        int maskW = maskData.getWidth();
        int maskH = maskData.getHeight();
        int texW = this.maskTex.getContentWidth();
        int texH = this.maskTex.getContentHeight();
        int pad = canScale ? 1 : 0;
        int needW = maskW + pad + pad;
        int needH = maskH + pad + pad;
        if (this.curMaskCol + needW > texW) {
            this.curMaskCol = 0;
            this.curMaskRow = this.nextMaskRow;
        }
        if (this.curMaskRow + needH > texH) {
            this.flushVertexBuffer();
        }
        int offset = this.curMaskRow * texW + this.curMaskCol;
        ByteToBytePixelConverter b2bpc = ByteGray.ToByteGrayConverter();
        if (canScale) {
            int off = offset;
            b2bpc.convert(this.clearBuffer, 0, 0, this.maskBuffer, off, texW, maskW + 1, 1);
            off = offset + maskW + 1;
            b2bpc.convert(this.clearBuffer, 0, 0, this.maskBuffer, off, texW, 1, maskH + 1);
            off = offset + texW;
            b2bpc.convert(this.clearBuffer, 0, 0, this.maskBuffer, off, texW, 1, maskH + 1);
            off = offset + (maskH + 1) * texW + 1;
            b2bpc.convert(this.clearBuffer, 0, 0, this.maskBuffer, off, texW, maskW + 1, 1);
            offset += texW + 1;
        }
        b2bpc.convert(maskData.getMaskBuffer(), 0, maskW, this.maskBuffer, offset, texW, maskW, maskH);
        float physW = this.maskTex.getPhysicalWidth();
        float physH = this.maskTex.getPhysicalHeight();
        maskBounds.setMinX((float)(this.curMaskCol + pad) / physW);
        maskBounds.setMinY((float)(this.curMaskRow + pad) / physH);
        maskBounds.setMaxX((float)(this.curMaskCol + pad + maskW) / physW);
        maskBounds.setMaxY((float)(this.curMaskRow + pad + maskH) / physH);
        this.curMaskCol += needW;
        if (this.highMaskCol < this.curMaskCol) {
            this.highMaskCol = this.curMaskCol;
        }
        if (this.nextMaskRow < this.curMaskRow + needH) {
            this.nextMaskRow = this.curMaskRow + needH;
        }
    }

    public int getRectTextureMaxSize() {
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        return this.rectTexMax;
    }

    public Texture getRectTexture() {
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        this.rectTex.lock();
        return this.rectTex;
    }

    private void createRectTexture() {
        int texMax = PrismSettings.primTextureSize;
        if (texMax < 0) {
            texMax = this.getResourceFactory().getMaximumTextureSize();
        }
        int texDim = 3;
        int nextCellSize = 2;
        while (texDim + nextCellSize + 1 <= texMax) {
            this.rectTexMax = nextCellSize++;
            texDim += nextCellSize;
        }
        byte[] mask = new byte[texDim * texDim];
        int cellY = 1;
        for (int cellH = 1; cellH <= this.rectTexMax; ++cellH) {
            int cellX = 1;
            for (int cellW = 1; cellW <= this.rectTexMax; ++cellW) {
                int index = cellY * texDim + cellX;
                for (int y = 0; y < cellH; ++y) {
                    for (int x = 0; x < cellW; ++x) {
                        mask[index + x] = -1;
                    }
                    index += texDim;
                }
                cellX += cellW + 1;
            }
            cellY += cellH + 1;
        }
        if (PrismSettings.verbose) {
            System.out.println("max rectangle texture cell size = " + this.rectTexMax);
        }
        Texture tex = this.getResourceFactory().createMaskTexture(texDim, texDim, Texture.WrapMode.CLAMP_NOT_NEEDED);
        tex.contentsUseful();
        tex.makePermanent();
        PixelFormat pf = tex.getPixelFormat();
        int scan = texDim * pf.getBytesPerPixelUnit();
        tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, texDim, texDim, scan, false);
        this.rectTex = tex;
    }

    public Texture getWrapRectTexture() {
        if (this.wrapRectTex == null) {
            Texture tex = this.getResourceFactory().createMaskTexture(2, 2, Texture.WrapMode.CLAMP_TO_EDGE);
            tex.contentsUseful();
            tex.makePermanent();
            int w = tex.getPhysicalWidth();
            int h = tex.getPhysicalHeight();
            if (PrismSettings.verbose) {
                System.out.println("wrap rectangle texture = " + w + " x " + h);
            }
            byte[] mask = new byte[w * h];
            int off = w;
            for (int y = 1; y < h; ++y) {
                for (int x = 1; x < h; ++x) {
                    mask[off + x] = -1;
                }
                off += w;
            }
            PixelFormat pf = tex.getPixelFormat();
            int scan = w * pf.getBytesPerPixelUnit();
            tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, w, h, scan, false);
            this.wrapRectTex = tex;
        }
        this.wrapRectTex.lock();
        return this.wrapRectTex;
    }

    public Texture getOvalTexture() {
        if (this.ovalTex == null) {
            int cellMax = this.getRectTextureMaxSize();
            int texDim = cellMax * (cellMax + 1) / 2;
            byte[] mask = new byte[(texDim += cellMax + 1) * texDim];
            int cellY = 1;
            for (int cellH = 1; cellH <= cellMax; ++cellH) {
                int cellX = 1;
                for (int cellW = 1; cellW <= cellMax; ++cellW) {
                    int index = cellY * texDim + cellX;
                    for (int y = 0; y < cellH; ++y) {
                        int x;
                        if (y * 2 >= cellH) {
                            int reflecty = cellH - 1 - y;
                            int rindex = index + (reflecty - y) * texDim;
                            for (x = 0; x < cellW; ++x) {
                                mask[index + x] = mask[rindex + x];
                            }
                        } else {
                            float ovalY = (float)y + 0.0625f;
                            for (int i = 0; i < 8; ++i) {
                                float ovalX = ovalY / (float)cellH - 0.5f;
                                ovalX = (float)Math.sqrt(0.25f - ovalX * ovalX);
                                int oxi = Math.round((float)cellW * 4.0f * (1.0f - ovalX * 2.0f));
                                int edgeX = oxi >> 3;
                                int subX = oxi & 7;
                                int n = index + edgeX;
                                mask[n] = (byte)(mask[n] + (8 - subX));
                                int n2 = index + edgeX + 1;
                                mask[n2] = (byte)(mask[n2] + subX);
                                ovalY += 0.125f;
                            }
                            int accum = 0;
                            for (x = 0; x < cellW; ++x) {
                                mask[index + x] = x * 2 >= cellW ? mask[index + cellW - 1 - x] : (byte)(((accum += mask[index + x]) * 255 + 32) / 64);
                            }
                            mask[index + cellW] = 0;
                        }
                        index += texDim;
                    }
                    cellX += cellW + 1;
                }
                cellY += cellH + 1;
            }
            Texture tex = this.getResourceFactory().createMaskTexture(texDim, texDim, Texture.WrapMode.CLAMP_NOT_NEEDED);
            tex.contentsUseful();
            tex.makePermanent();
            PixelFormat pf = tex.getPixelFormat();
            int scan = texDim * pf.getBytesPerPixelUnit();
            tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, texDim, texDim, scan, false);
            this.ovalTex = tex;
        }
        this.ovalTex.lock();
        return this.ovalTex;
    }

    public Texture getGradientTexture(Gradient grad, BaseTransform xform, int paintW, int paintH, MaskData maskData, float bx, float by, float bw, float bh) {
        int sizeInPixels = paintW * paintH;
        int sizeInBytes = sizeInPixels * 4;
        if (this.paintBuffer == null || this.paintBuffer.capacity() < sizeInBytes) {
            this.paintPixels = new int[sizeInPixels];
            this.paintBuffer = ByteBuffer.wrap(new byte[sizeInBytes]);
        }
        if (this.paintTex != null) {
            this.paintTex.lock();
            if (this.paintTex.isSurfaceLost()) {
                this.paintTex = null;
            }
        }
        if (this.paintTex == null || this.paintTex.getContentWidth() < paintW || this.paintTex.getContentHeight() < paintH) {
            int newTexW = paintW;
            int newTexH = paintH;
            if (this.paintTex != null) {
                newTexW = Math.max(paintW, this.paintTex.getContentWidth());
                newTexH = Math.max(paintH, this.paintTex.getContentHeight());
                this.paintTex.dispose();
            }
            this.paintTex = this.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_NOT_NEEDED, newTexW, newTexH);
        }
        PaintUtil.fillImageWithGradient(this.paintPixels, grad, xform, 0, 0, paintW, paintH, bx, by, bw, bh);
        byte[] bytePixels = this.paintBuffer.array();
        if (maskData != null) {
            byte[] maskPixels = maskData.getMaskBuffer().array();
            int j = 0;
            for (int i = 0; i < sizeInPixels; ++i) {
                int pixel = this.paintPixels[i];
                int maskA = maskPixels[i] & 0xFF;
                bytePixels[j++] = (byte)((pixel & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >> 8 & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >> 16 & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >>> 24) * maskA / 255);
            }
        } else {
            int j = 0;
            for (int i = 0; i < sizeInPixels; ++i) {
                int pixel = this.paintPixels[i];
                bytePixels[j++] = (byte)(pixel & 0xFF);
                bytePixels[j++] = (byte)(pixel >> 8 & 0xFF);
                bytePixels[j++] = (byte)(pixel >> 16 & 0xFF);
                bytePixels[j++] = (byte)(pixel >>> 24);
            }
        }
        this.paintTex.update(this.paintBuffer, PixelFormat.BYTE_BGRA_PRE, 0, 0, 0, 0, paintW, paintH, paintW * 4, false);
        return this.paintTex;
    }
}

