/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.pisces.JavaSurface;
import com.sun.pisces.PiscesRenderer;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWGraphics;
import com.sun.prism.sw.SWResourceFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class SWRTTexture
extends SWArgbPreTexture
implements RTTexture {
    private PiscesRenderer pr;
    private JavaSurface surface;
    private final Rectangle dimensions = new Rectangle();
    private boolean isOpaque;

    SWRTTexture(SWResourceFactory factory, int w, int h) {
        super(factory, Texture.WrapMode.CLAMP_TO_ZERO, w, h);
        this.allocate();
        this.surface = new JavaSurface(this.getDataNoClone(), 1, w, h);
        this.dimensions.setBounds(0, 0, w, h);
    }

    JavaSurface getSurface() {
        return this.surface;
    }

    @Override
    public int[] getPixels() {
        if (this.contentWidth == this.physicalWidth) {
            return this.getDataNoClone();
        }
        return null;
    }

    @Override
    public boolean readPixels(Buffer pixels, int x, int y, int width, int height) {
        if (x != this.getContentX() || y != this.getContentY() || width != this.getContentWidth() || height != this.getContentHeight()) {
            throw new IllegalArgumentException("reading subtexture not yet supported!");
        }
        return this.readPixels(pixels);
    }

    @Override
    public boolean readPixels(Buffer pixels) {
        if (PrismSettings.debug) {
            System.out.println("+ SWRTT.readPixels: this: " + this);
        }
        int[] pixbuf = this.getDataNoClone();
        pixels.clear();
        if (pixels instanceof IntBuffer) {
            IntBuffer iPixels = (IntBuffer)pixels;
            for (int i = 0; i < this.contentHeight; ++i) {
                iPixels.put(pixbuf, i * this.physicalWidth, this.contentWidth);
            }
        } else if (pixels instanceof ByteBuffer) {
            ByteBuffer bPixels = (ByteBuffer)pixels;
            for (int i = 0; i < this.contentHeight; ++i) {
                for (int j = 0; j < this.contentWidth; ++j) {
                    int argb = pixbuf[i * this.physicalWidth + j];
                    byte a = (byte)(argb >> 24);
                    byte r = (byte)(argb >> 16);
                    byte g = (byte)(argb >> 8);
                    byte b = (byte)argb;
                    bPixels.put(b).put(g).put(r).put(a);
                }
            }
        } else {
            return false;
        }
        pixels.rewind();
        return true;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.getResourceFactory().getScreen();
    }

    @Override
    public Graphics createGraphics() {
        if (this.pr == null) {
            this.pr = new PiscesRenderer(this.surface);
        }
        return new SWGraphics(this, this.getResourceFactory().getContext(), this.pr);
    }

    @Override
    public boolean isOpaque() {
        return this.isOpaque;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.isOpaque = opaque;
    }

    Rectangle getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isMSAA() {
        return false;
    }
}

