/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.RenderState;

public class DisplacementMap
extends CoreEffect<RenderState> {
    private FloatMap mapData;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private boolean wrap;

    public DisplacementMap(FloatMap mapData) {
        this(mapData, DefaultInput);
    }

    public DisplacementMap(FloatMap mapData, Effect contentInput) {
        super(contentInput);
        this.setMapData(mapData);
        this.updatePeerKey("DisplacementMap");
    }

    public final FloatMap getMapData() {
        return this.mapData;
    }

    public void setMapData(FloatMap mapData) {
        if (mapData == null) {
            throw new IllegalArgumentException("Map data must be non-null");
        }
        FloatMap old = this.mapData;
        this.mapData = mapData;
    }

    public final Effect getContentInput() {
        return this.getInputs().get(0);
    }

    public void setContentInput(Effect contentInput) {
        this.setInput(0, contentInput);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        float old = this.scaleX;
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        float old = this.scaleY;
        this.scaleY = scaleY;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        float old = this.offsetX;
        this.offsetX = offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        float old = this.offsetY;
        this.offsetY = offsetY;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        boolean old = this.wrap;
        this.wrap = wrap;
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        return new Point2D(Float.NaN, Float.NaN);
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        BaseBounds r = this.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        float rw = r.getWidth();
        float rh = r.getHeight();
        float x = (p.x - r.getMinX()) / rw;
        float y = (p.y - r.getMinY()) / rh;
        if (x >= 0.0f && y >= 0.0f && x < 1.0f && y < 1.0f) {
            int mx = (int)(x * (float)this.mapData.getWidth());
            int my = (int)(y * (float)this.mapData.getHeight());
            float dx = this.mapData.getSample(mx, my, 0);
            float dy = this.mapData.getSample(mx, my, 1);
            x += this.scaleX * (dx + this.offsetX);
            y += this.scaleY * (dy + this.offsetY);
            if (this.wrap) {
                x = (float)((double)x - Math.floor(x));
                y = (float)((double)y - Math.floor(y));
            }
            p = new Point2D(x * rw + r.getMinX(), y * rh + r.getMinY());
        }
        return this.getDefaultedInput(0, defaultInput).untransform(p, defaultInput);
    }

    @Override
    public ImageData filterImageDatas(FilterContext fctx, BaseTransform transform, Rectangle outputClip, RenderState rstate, ImageData ... inputs) {
        return super.filterImageDatas(fctx, transform, null, rstate, inputs);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return RenderState.UnclippedUserSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        DirtyRegionContainer drc = regionPool.checkOut();
        drc.deriveWithNewRegion((RectBounds)this.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput));
        return drc;
    }
}

