/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.SharedBuffer;
import java.io.InputStream;

public final class SimpleSharedBufferInputStream
extends InputStream {
    private final SharedBuffer sharedBuffer;
    private long position;

    public SimpleSharedBufferInputStream(SharedBuffer sharedBuffer) {
        if (sharedBuffer == null) {
            throw new NullPointerException("sharedBuffer is null");
        }
        this.sharedBuffer = sharedBuffer;
    }

    @Override
    public int read() {
        byte[] buffer = new byte[1];
        int length = this.sharedBuffer.getSomeData(this.position, buffer, 0, 1);
        if (length != 0) {
            ++this.position;
            return buffer[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("b is null");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len is greater than b.length - off");
        }
        if (len == 0) {
            return 0;
        }
        int length = this.sharedBuffer.getSomeData(this.position, b, off, len);
        if (length != 0) {
            this.position += (long)length;
            return length;
        }
        return -1;
    }

    @Override
    public long skip(long n) {
        long k = this.sharedBuffer.size() - this.position;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.position += k;
        return k;
    }

    @Override
    public int available() {
        return (int)Math.min(this.sharedBuffer.size() - this.position, Integer.MAX_VALUE);
    }
}

