/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.scenario.animation.AbstractMasterTimer;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;

public abstract class Transition
extends Animation {
    private ObjectProperty<Interpolator> interpolator;
    private static final Interpolator DEFAULT_INTERPOLATOR = Interpolator.EASE_BOTH;
    private Interpolator cachedInterpolator;

    public final void setInterpolator(Interpolator value) {
        if (this.interpolator != null || !DEFAULT_INTERPOLATOR.equals(value)) {
            this.interpolatorProperty().set(value);
        }
    }

    public final Interpolator getInterpolator() {
        return this.interpolator == null ? DEFAULT_INTERPOLATOR : (Interpolator)this.interpolator.get();
    }

    public final ObjectProperty<Interpolator> interpolatorProperty() {
        if (this.interpolator == null) {
            this.interpolator = new SimpleObjectProperty<Interpolator>(this, "interpolator", DEFAULT_INTERPOLATOR);
        }
        return this.interpolator;
    }

    protected Interpolator getCachedInterpolator() {
        return this.cachedInterpolator;
    }

    public Transition(double targetFramerate) {
        super(targetFramerate);
    }

    public Transition() {
    }

    Transition(AbstractMasterTimer timer) {
        super(timer);
    }

    protected Node getParentTargetNode() {
        return this.parent != null && this.parent instanceof Transition ? ((Transition)this.parent).getParentTargetNode() : null;
    }

    protected abstract void interpolate(double var1);

    private double calculateFraction(long currentTicks, long cycleTicks) {
        double frac = cycleTicks <= 0L ? 1.0 : (double)currentTicks / (double)cycleTicks;
        return this.cachedInterpolator.interpolate(0.0, 1.0, frac);
    }

    @Override
    boolean impl_startable(boolean forceSync) {
        return super.impl_startable(forceSync) && (this.getInterpolator() != null || !forceSync && this.cachedInterpolator != null);
    }

    @Override
    void impl_sync(boolean forceSync) {
        super.impl_sync(forceSync);
        if (forceSync || this.cachedInterpolator == null) {
            this.cachedInterpolator = this.getInterpolator();
        }
    }

    @Override
    void impl_playTo(long currentTicks, long cycleTicks) {
        this.impl_setCurrentTicks(currentTicks);
        this.interpolate(this.calculateFraction(currentTicks, cycleTicks));
    }

    @Override
    void impl_jumpTo(long currentTicks, long cycleTicks, boolean forceJump) {
        this.impl_setCurrentTicks(currentTicks);
        if (this.getStatus() != Animation.Status.STOPPED || forceJump) {
            this.impl_sync(false);
            this.interpolate(this.calculateFraction(currentTicks, cycleTicks));
        }
    }
}

