/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.Utils;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;

class ControlUtils {
    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int index) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> Event.fireEvent(control, new ScrollToEvent<Integer>(control, control, ScrollToEvent.scrollToTopIndex(), index)));
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> column) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> control.fireEvent(new ScrollToEvent<TableColumnBase>(control, control, ScrollToEvent.scrollToColumn(), column)));
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control c) {
        Node focusOwner;
        Scene scene = c.getScene();
        Node node = focusOwner = scene == null ? null : scene.getFocusOwner();
        if (focusOwner == null) {
            c.requestFocus();
        } else if (!c.equals(focusOwner)) {
            for (Parent p = focusOwner.getParent(); p != null; p = p.getParent()) {
                if (!c.equals(p)) continue;
                c.requestFocus();
                break;
            }
        }
    }

    static <T> ListChangeListener.Change<T> buildClearAndSelectChange(ObservableList<T> list, final List<T> removed, final int retainedRow) {
        return new ListChangeListener.Change<T>(list){
            private final int[] EMPTY_PERM;
            private final int removedSize;
            private final List<T> firstRemovedRange;
            private final List<T> secondRemovedRange;
            private boolean invalid;
            private boolean atFirstRange;
            private int from;
            {
                super(x0);
                this.EMPTY_PERM = new int[0];
                this.removedSize = removed.size();
                this.invalid = true;
                this.atFirstRange = true;
                this.from = -1;
                int midIndex = retainedRow >= this.removedSize ? this.removedSize : (retainedRow < 0 ? 0 : retainedRow);
                this.firstRemovedRange = removed.subList(0, midIndex);
                this.secondRemovedRange = removed.subList(midIndex, this.removedSize);
            }

            @Override
            public int getFrom() {
                this.checkState();
                return this.from;
            }

            @Override
            public int getTo() {
                return this.getFrom();
            }

            @Override
            public List<T> getRemoved() {
                this.checkState();
                return this.atFirstRange ? this.firstRemovedRange : this.secondRemovedRange;
            }

            @Override
            public int getRemovedSize() {
                return this.atFirstRange ? this.firstRemovedRange.size() : this.secondRemovedRange.size();
            }

            @Override
            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            @Override
            public boolean next() {
                if (this.invalid && this.atFirstRange) {
                    this.invalid = false;
                    this.from = 0;
                    return true;
                }
                if (this.atFirstRange && !this.secondRemovedRange.isEmpty()) {
                    this.atFirstRange = false;
                    this.from = 1;
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                this.invalid = true;
                this.atFirstRange = true;
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
    }
}

