/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;

public abstract class WritablePixelFormat<T extends Buffer>
extends PixelFormat<T> {
    WritablePixelFormat(PixelFormat.Type type) {
        super(type);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    public abstract void setArgb(T var1, int var2, int var3, int var4, int var5);

    static class ByteBgraPre
    extends WritablePixelFormat<ByteBuffer> {
        static final ByteBgraPre INSTANCE = new ByteBgraPre();

        private ByteBgraPre() {
            super(PixelFormat.Type.BYTE_BGRA_PRE);
        }

        @Override
        public boolean isPremultiplied() {
            return true;
        }

        @Override
        public int getArgb(ByteBuffer buf, int x, int y, int scanlineStride) {
            int index = y * scanlineStride + x * 4;
            int b = buf.get(index) & 0xFF;
            int g = buf.get(index + 1) & 0xFF;
            int r = buf.get(index + 2) & 0xFF;
            int a = buf.get(index + 3) & 0xFF;
            if (a > 0 && a < 255) {
                int halfa = a >> 1;
                r = r >= a ? 255 : (r * 255 + halfa) / a;
                g = g >= a ? 255 : (g * 255 + halfa) / a;
                b = b >= a ? 255 : (b * 255 + halfa) / a;
            }
            return a << 24 | r << 16 | g << 8 | b;
        }

        @Override
        public void setArgb(ByteBuffer buf, int x, int y, int scanlineStride, int argb) {
            int b;
            int g;
            int r;
            int index = y * scanlineStride + x * 4;
            int a = argb >>> 24;
            if (a > 0) {
                r = argb >> 16 & 0xFF;
                g = argb >> 8 & 0xFF;
                b = argb & 0xFF;
                if (a < 255) {
                    r = (r * a + 127) / 255;
                    g = (g * a + 127) / 255;
                    b = (b * a + 127) / 255;
                }
            } else {
                b = 0;
                g = 0;
                r = 0;
                a = 0;
            }
            buf.put(index, (byte)b);
            buf.put(index + 1, (byte)g);
            buf.put(index + 2, (byte)r);
            buf.put(index + 3, (byte)a);
        }
    }

    static class ByteBgra
    extends WritablePixelFormat<ByteBuffer> {
        static final ByteBgra INSTANCE = new ByteBgra();

        private ByteBgra() {
            super(PixelFormat.Type.BYTE_BGRA);
        }

        @Override
        public boolean isPremultiplied() {
            return false;
        }

        @Override
        public int getArgb(ByteBuffer buf, int x, int y, int scanlineStride) {
            int index = y * scanlineStride + x * 4;
            int b = buf.get(index) & 0xFF;
            int g = buf.get(index + 1) & 0xFF;
            int r = buf.get(index + 2) & 0xFF;
            int a = buf.get(index + 3) & 0xFF;
            return a << 24 | r << 16 | g << 8 | b;
        }

        @Override
        public void setArgb(ByteBuffer buf, int x, int y, int scanlineStride, int argb) {
            int index = y * scanlineStride + x * 4;
            buf.put(index, (byte)argb);
            buf.put(index + 1, (byte)(argb >> 8));
            buf.put(index + 2, (byte)(argb >> 16));
            buf.put(index + 3, (byte)(argb >> 24));
        }
    }

    static class IntArgbPre
    extends WritablePixelFormat<IntBuffer> {
        static final IntArgbPre INSTANCE = new IntArgbPre();

        private IntArgbPre() {
            super(PixelFormat.Type.INT_ARGB_PRE);
        }

        @Override
        public boolean isPremultiplied() {
            return true;
        }

        @Override
        public int getArgb(IntBuffer buf, int x, int y, int scanlineStride) {
            return IntArgbPre.PretoNonPre(buf.get(y * scanlineStride + x));
        }

        @Override
        public void setArgb(IntBuffer buf, int x, int y, int scanlineStride, int argb) {
            buf.put(y * scanlineStride + x, IntArgbPre.NonPretoPre(argb));
        }
    }

    static class IntArgb
    extends WritablePixelFormat<IntBuffer> {
        static final IntArgb INSTANCE = new IntArgb();

        private IntArgb() {
            super(PixelFormat.Type.INT_ARGB);
        }

        @Override
        public boolean isPremultiplied() {
            return false;
        }

        @Override
        public int getArgb(IntBuffer buf, int x, int y, int scanlineStride) {
            return buf.get(y * scanlineStride + x);
        }

        @Override
        public void setArgb(IntBuffer buf, int x, int y, int scanlineStride, int argb) {
            buf.put(y * scanlineStride + x, argb);
        }
    }
}

