/*
 * spy-js - v2.0.0
 * http://spy-js.com
 * Copyright (c) 2013-2016 JetBrains - All Rights Reserved.
 *
 * This source code file is a part of spy-js plugin.
 */
var fs=require("fs"),path=require("path"),util=require("util"),EventEmitter=require("events").EventEmitter,temp=require("temp"),FileSystemSessionStore=require("./sessionStore"),urlUtil=require("./urlUtil"),_=_spy_js._;require("colors"),temp.track();var SessionCore=function(a,b,c){var d=this;b=b||[],d._isBrowser=!b.length,d._internal=c,d._log=console.log,d._warn=console.warn,d._error=console.error,d._id=a.handshake.sessionID,d._store=d._internal?{dispose:function(){}}:new FileSystemSessionStore(d._id),d._cancelledEventRequests={},d._started=!1,d._scriptCache={},d._functionCallIndex={},d._fileDependencyIndex={},d._fileIdToUrlCache={},d._contextEvents={},d._configPath=null,d._root=null,d._mapper=null,d._eventFilter=null,d._socketListeners={};var e=function(a,c,e){_.contains(b,a)||(e?d._socketListeners[a]=function(){d.once("event."+a,_.last(arguments)),c.apply(d,arguments)}:d._socketListeners[a]=_.bind(c,d))};e("disconnect",d._disconnect),e("session.start",d._start,!0),e("session.clear",d._clear),e("config.file.change",d._updateConfigFile),e("config.change",d._updateConfig),e("browser.execute",d._updateCommand),e("expression.evaluate",d._evaluate),e("function.search",d._searchFunction),e("file.dependency.get",d._fileDependency),e("file.cache.clear",d._clearFileCache),e("source.instrumentationMap.get",d._instrumentationMapByFileIds,!0),e("event.get",d._event),e("event.get.cancel",d._eventGetCancel),e("fragment.get",d._fragment,!0),e("session.save",d._save),e("session.load",d._load),d._socketEmitters=["event.session.new","event.session.change","event.session.dispose","event.file.cache","event.context.new","event.context.interruption","event.context.expired","event.context.active","event.event.metadata","event.event.data","event.event.data.end","event.log.error","event.log.info"],_(d._socketEmitters).each(function(a){d.on(a,function(){var b=_(arguments).toArray();b.unshift(a),d._socket.emit.apply(d._socket,b)})}),d._initializeSocket(a)};SessionCore.prototype=_.extend(Object.create(EventEmitter.prototype),{id:function(){return this._id},root:function(){return this._root},global:function(){return this._started&&!this.root()},isSourceMapLookupEnabled:function(){return!!this._sourceMapLookup},isSourceMapGenerationEnabled:function(){return!!this._sourceMapGeneration},proxyPort:function(){return this._proxy},isActive:function(){return!this._loaded},_hasMapper:function(){return!!this._mapper},created:function(){var a=this;a.emit("event.session.new"),a.info("new session created: "+a.id())},_flushCacheWhereConfigChanged:function(){var a=this;a._hasMapper()&&_.chain(a._scriptCache).pairs().toArray().each(function(b){var c=b[0];_.isEqual(a._buildConfig(c),b[1].config)||((a._scriptCache[c]||{}).expired=!0)})},cache:function(a){var b=this,c=a.sourceUrl,d=b._scriptCache[c];d&&d.expired&&(d=null);var e=(d||{}).config||b._buildConfig(c);d&&d.fileId&&d.fileId!=a.fileId&&(a.previous=d),b._scriptCache[c]=a,b._fileIdToUrlCache[a.fileId]=a.sourceUrl,a.config=e,b.emit("event.file.cache",e),b._internal&&b.emit("event.item.cache",a)},isCached:function(a){var b=this;return b._isCached(b._scriptCache[a])},_isCached:function(a){return!(!a||!a.fileId||a.expired)},config:function(a){var b=this,c=b._scriptCache[a];if(c&&c.expired&&(c=null),c&&c.config)return c.config;var d=b._buildConfig(a);return b._scriptCache[a]=c||{},b._scriptCache[a].config=d,d},fileIds:function(a){for(var b=this,c=[],d=b._scriptCache[a]||{};d;)c.push(d.fileId),d=d.previous;return c},_initializeSocket:function(a){var b=this;b._socket&&_.chain(b._socketListeners).pairs().each(function(a){b._socket.removeListener(a[0],a[1])}),b._socket=a,_.chain(b._socketListeners).pairs().each(function(b){a.on(b[0],b[1])})},updateSocket:function(a){var b=this;b.emit("event.session.reconnect"),b._initializeSocket(a)},_disconnect:function(){var a=this;a.emit("event.session.disconnect")},lastCachedInstrumentedCode:function(a){var b=this,c=b._scriptCache[a];return(c||{}).instrumentedCode},instrumentationMapByFileId:function(a){var b=this,c=b._cachedItemByFileId(a);if(c&&c.instrumentationMap)return{value:c.instrumentationMap,fileId:c.fileId,sourceUrl:c.sourceUrl}},allConfigs:function(){var a=this;return _.chain(a._scriptCache).values().map(function(a){return a.config}).value()},allFileUrls:function(){var a=this;return _.chain(a._scriptCache).values().filter(a._isCached).map(function(a){return a.sourceUrl}).value()},_cachedItemByFileId:function(a){var b=this,c=b._fileIdToUrlCache[a];if(c){var d=b._scriptCache[c];if(d){for(;d&&d.fileId!==a;)d=d.previous;return d&&d.fileId===a?d:null}}},_instrumentationMapByFileIds:function(a){var b=this,c={};a.forEach(function(a){var d=b._cachedItemByFileId(a);_.extend(c,d&&d.instrumentationMap||{})}),b.emit("event.source.instrumentationMap.get",c)},functionsInFile:function(a){var b=this;return((b._cachedItemByFileId(a)||{}).instrumentationMap||{}).functionsInFile||0},lastCachedFromChildProcess:function(a){var b=this;return(b._scriptCache[a]||{}).fromChildProcess},info:function(a,b){var c=this,d="string"==typeof a?a:util.inspect(a);c.emit("event.log.info",d);var e="session ("+c.id()+"): "+d;c._log(b?e[b]:e)},warn:function(a){var b=this,c="string"==typeof a?a:util.inspect(a);b.emit("event.log.info",c),b._warn("session ("+b.id()+"): "+c)},error:function(a){var b,c,d=this;a instanceof Error?b=c=a.message+"\n"+a.stack:a&&a.message&&a.err?(b={message:a.message,err:util.inspect(a.err)},c=a.message,a.err instanceof Error?c+=" ("+a.err.message+")"+(a.err.stack?"\n"+a.err.stack:""):a.err.message?(c+=" ("+a.err.message+")",a.err.stack&&(c+="\n"+a.err.stack)):c+=" ("+util.inspect(a.err)+")"):b=c="string"==typeof a?a:util.inspect(a),d.emit("event.log.error",b),d._error("session ("+d.id()+"): "+c)},_clear:function(){var a=this;a._store.clear(),a.info("session data cleared")},newEvent:function(a,b){var c=this;if(!c._loaded&&c._store){c._store.save(a);var d={streamId:a.streamId,eventId:a.eventId,globalScope:b.globalScope,files:b.files,lastEntry:b.lastEntry,firstEntry:b.firstEntry},e=c._contextEvents[d.streamId];e&&(e.events=e.events||{},a=e.events[d.eventId],a?(a.lastEntry=d.lastEntry,_.extend(a.files,d.files)):e.events[d.eventId]=d),c.emit("event.event.metadata",d)}},newContext:function(a){var b=this;b._loaded||(b._contextEvents[a.id]=a,b.emit("event.context.new",a))},contextActivated:function(a){var b=this;b._loaded||b.emit("event.context.active",{id:a})},contextExpired:function(a){var b=this;b._loaded||b.emit("event.context.expired",{id:a})},fileIdFromInsMapId:function(a){return a.slice(0,a.indexOf("_"))},functionEncountered:function(a,b,c,d,e){var f=this,g={streamId:a,eventId:b,fileId:c,funcId:d,codeElementId:e};f._registerFunctionCall(a,b,c,d),f._lastRegisteredFunctionCall&&g.fileId!==f._lastRegisteredFunctionCall.fileId&&g.eventId===g.eventId&&g.streamId===g.streamId&&f._registerFileRuntimeDependency(f._lastRegisteredFunctionCall,g),f._lastRegisteredFunctionCall=g},_registerFileRuntimeDependency:function(a,b){var c=this,d=c._fileDependencyIndex[a.streamId]=c._fileDependencyIndex[a.streamId]||{},e=d[a.fileId]=d[a.fileId]||{},f=e[b.fileId]=e[b.fileId]||{},g=a.codeElementId+":"+b.codeElementId,h=f[g]=f[g]||{},i=h[a.eventId];h[a.eventId]=i?i+1:1},_registerFunctionCall:function(a,b,c,d){var e=this,f=e._functionCallIndex[c]=e._functionCallIndex[c]||{},g=f[d]=f[d]||{},h=g[a]=g[a]||{};h[b]=h[b]+1||1},_event:function(a,b){var c=this,d=a.streamId,e=a.eventId,f=a.compact,g=function(f){c.error({message:"Error loading stream: "+d+", event: "+e,err:f}),b&&b(0),c.emit("event.event.data.end",{streamId:d,eventId:e,correlationId:a.correlationId})};try{c._store.load({streamId:d,eventId:e,mapper:f&&function(a){var b=c._decodeEntryType(a);return"FS"===b||"FE"===b||"PS"===b||"PE"===b||"R"===b||"E"===b?c._decodeBaseEntry(a):c._decodeEntryId(a)},done:function(f,h){if(h)return void g(h);b&&b(f.length);var i=c._splitArray(f,1e4),j=i.length,k=function(b){return c._cancelledEventRequests[a.correlationId]?void delete c._cancelledEventRequests[a.correlationId]:void(b!=j?(c.emit("event.event.data",{streamId:d,eventId:e,data:i[b],correlationId:a.correlationId,chunkId:b}),setTimeout(_.bind(k,null,++b),50)):c.emit("event.event.data.end",{streamId:d,eventId:e,correlationId:a.correlationId}))};k(0)}})}catch(a){g(a)}},_fragment:function(a){var b=this,c=a.fileId,d=function(d){b.error({message:"Error loading fragment from stream: "+a.streamId+", event: "+a.eventId,err:d}),b.emit("event.fragment.get",{data:[],source:c?{code:b._sourceFromCache(c),file:c}:void 0})};a.done=function(a,e){if(e)return void d(e);var f={data:a.map(b._decodeBaseEntry)};c&&(f.source={code:b._sourceFromCache(c),file:c}),b.emit("event.fragment.get",f)};try{b._store.load(a)}catch(a){d(a)}},_eventGetCancel:function(a){var b=this;b._cancelledEventRequests[a]=!0},_sourceFromCache:function(a){var b=this,c=b._cachedItemByFileId(a);if(c&&c.originalCode)return{executed:c.originalCode,mapped:c.sourceMappedFiles}},_start:function(a){var b=this;if(a&&a.path)b._readConfigFile(a.path,function(c){b._loadConfig({configPath:a.path})&&(b._started=!0,b.emit("event.session.start",{code:c,name:b._name,config:a}))});else if(a&&(a.code||a.url||a.limits)){var c=a.url?'$.root = "'+a.url+'";':"",d="";if(a.limits){var e={};_.each(b._defaultObjDumpLimits,function(b,c){e[c]=a[c]||b}),d="$.mapper = function (url) { return {instrument: {objectDump: "+JSON.stringify(e)+"}};}"}var f=a.code||"module.exports = function ($) { "+c+d+"}";b._loadConfig({configCode:f})&&(b._started=!0,b.emit("event.session.start",{code:f,name:b._name,config:a}))}else b._loadConfig()&&(b._started=!0,b.emit("event.session.start",{code:fs.readFileSync(path.join(__dirname,"defaultConfig.js"),"utf8"),name:b._name,config:a}))},_save:function(a){var b=this;if(b._loaded)return void a({});b.emit("internal.event.stopTracerCompiler");try{b._store.pack({browser:b._isBrowser,scriptCache:b._scriptCache,functionCallIndex:b._functionCallIndex,fileDependencyIndex:b._fileDependencyIndex,fileIdToUrlCache:b._fileIdToUrlCache,contextEvents:b._contextEvents,done:function(c){b.info("Saved trace file to: "+c.file),a(c)},error:function(c){b.error(c),a({})}})}finally{b.emit("internal.event.startTracerCompiler")}},_load:function(a,b){var c=this;c._loaded=!0;var d=function(a,b){_.each(a[b],function(a){c.emit("event.event.metadata",a)}),++b<a.length&&setTimeout(_.bind(d,null,a,b),50)};c._store.unpack({browser:c._isBrowser,file:a,error:function(a){c.error(a),b({})},done:function(a){c._functionCallIndex=a.functionCallIndex,c._fileDependencyIndex=a.fileDependencyIndex,c._scriptCache=a.scriptCache,c._fileIdToUrlCache=a.fileIdToUrlCache,b({id:a.id}),_.each(a.contextEvents,function(a){var b=a.events;delete a.events,c.emit("event.context.new",a),d(c._splitArray(_.toArray(b),50),0)})}})},_buildConfig:function(a){var b=this,c={};try{c=b._mapper(a)||b._defaultMapper(a)}catch(a){b._fixConfigAwareStack(b._configPath,a),b.error({message:"Error in configuration mapper function",err:a})}return c.url=c.url||a,c.instrument&&(c.instrument=c.instrument===!0?{}:c.instrument,c.instrument.objectDump!==!1&&(c.instrument.objectDump=_.extend({},b._defaultObjDumpLimits,c.instrument.objectDump||{}))),c},_updateConfigFile:function(a){var b=this;b._loaded||(a.path||a.code?(b._configPath!=a.path&&(b._configPath=a.path,b.info("configuration file path updated to "+b._configPath)),a.reload&&b._loadConfig({configPath:a.path,configCode:a.code})&&(b._flushCacheWhereConfigChanged(),b.emit("event.session.change"))):b.error("configuration file/code is missing"))},_updateConfig:function(a){var b=this;b._loaded||(b._realtimeEval||!a.realtimeEval||_.isEmpty(b._scriptCache)||b.info("Session restart may be required to trace with magnifier enabled"),b._sourceMapLookup||!a.sourceMapLookup||_.isEmpty(b._scriptCache)||b.info("Session restart may be required to trace with source map lookup enabled"),b._sourceMapGeneration||!a.sourceMapGeneration||_.isEmpty(b._scriptCache)||b.info("Session restart may be required to trace with source map generation enabled"),b._realtimeEval=a.realtimeEval,b._sourceMapLookup=a.sourceMapLookup,b._sourceMapGeneration=a.sourceMapGeneration,b.emit("event.config.change",a))},_updateCommand:function(a){var b=this;b._loaded||b.emit("event.browser.execute",a)},_evaluate:function(a,b){var c=this;return c._loaded?void b({}):c.realtimeEvaluation()?void c.emit("event.expression.evaluate",a,b):void b({})},_fileDependency:function(a,b){var c=this;return a&&a.streamId?void b(c._fileDependencyIndex[a.streamId]):(c.error("incorrect file dependency request, document context must be provided"),void b({}))},_searchFunction:function(a,b){var c=this;if(!a||!a.function||!a.file)return c.error("incorrect search request, file and function must be provided"),void b({});var d=c.fileIds(a.file)[0],e=c._functionCallIndex[d];if(!e)return c.info("file "+a.file+" not found by id "+d),void b({});var f={},g=e[a.function];_.each(g,function(a,b){var c=f[b];c?_.extend(c,a):f[b]=a}),_.isEmpty(f)&&c.info("function #"+a.function+" usage is not found in "+a.file),b(f)},_readConfigFile:function(a,b){var c=this;try{var d=fs.readFileSync(a,{encoding:"utf8"});b(d)}catch(a){c.error(a)}},_loadConfig:function(a){var b,c,d=this;a=a||{};var e=a.configPath,f=a.configCode;if(e||f)try{if(!e){var g=temp.openSync({suffix:".js"}),h=g.fd;e=g.path;var i=new Buffer(f);fs.writeSync(h,i,0,i.length),fs.closeSync(h),d.info("dynamic config created: "+e)}delete require.cache[require.resolve(e)],c={},d.emit("internal.event.stopTracerCompiler");try{b=require(e)}finally{d.emit("internal.event.startTracerCompiler")}b(c),d._proxy=c.proxy,d._root=c.root?urlUtil.normalizedUrl(c.root):null,d._mapper=c.mapper||d._defaultMapper,d._eventFilter=d._initEventFilter(_.extend({},d._defaultEventFilter,c.eventFilter)),d._name=c.name||"nameless configured"+(d.global()?" global":" ["+d._root+"]")+" session",a.configPath&&(d._configPath=e),d._validateConfig()}catch(a){return d._fixConfigAwareStack(e,a),d.error({message:"Invalid configuration file",err:a}),!1}else d._root=null,d._mapper=d._defaultMapper,d._eventFilter=d._initEventFilter(d._defaultEventFilter),d._name="nameless not configured global session";return!0},_fixConfigAwareStack:function(a,b){if(b)if(a){if(b.stack){var c=path.basename(a),d=b.stack.toString().match(new RegExp("[\\s\\S]*"+c.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")+"[^\\)]*\\)","i"));d&&d[0]?b.stack=d[0]:b.stack=""}}else b.stack=""},_validateConfig:function(){var a=this;if(a._proxy&&!a._root)throw new Error("root property is required when local proxy is used");if(a._proxy&&!_.isNumber(a._proxy))throw new Error("proxy property must be a valid port number");if(!_.isFunction(a._mapper))throw new Error("mapper property must be a function")},_defaultMapper:function(a){return{url:a,local:"",instrument:!0}},_defaultObjDumpLimits:{depth:1,propertyNumber:3,arrayLength:3,stringLength:50},_defaultEventFilter:{globalScope:!0,timeout:!0,interval:!0,events:void 0,noEvents:[]},_initEventFilter:function(a){var b=a.events?_.object(a.events,a.events):null,c=a.noEvents&&a.noEvents.length?_.object(a.noEvents,a.noEvents):null;return a.allowedEvents=b,a.disallowedEvents=c,a},_decodeEntryType:function(a){return a[6]},_decodeEntryId:function(a){return a.id},_decodeBaseEntry:function(a){return{callData:a[0],time:a[3],objDump:a[5]}},_splitArray:function(a,b){for(var c=[];a.length;)c.push(a.splice(0,b));return c},realtimeEvaluation:function(){return!!this._realtimeEval},hasFilter:function(){var a=this,b=a._eventFilter;return!(!b||b.globalScope&&b.timeout&&b.interval&&!b.events&&(!b.noEvents||!b.noEvents.length))},filter:function(a){var b=this,c=b._eventFilter,d=c.allowedEvents,e=c.disallowedEvents;return!(c.timeout||!a.isFromSetTimeout)||(!(c.interval||!a.isFromSetInterval)||(!!(e&&a.pageEvent&&e[a.pageEvent.type])||(!(!d||!a.pageEvent||d[a.pageEvent.type])||!c.globalScope&&a.globalScope)))},eventInterruption:function(a){var b=this;b.emit("event.context.interruption",{id:a})},dispose:function(){var a=this;a.emit("event.session.dispose"),_(a._socketEmitters).each(function(b){a.removeAllListeners(b)}),a._store.dispose(),a._store=null,a._socket=null,a._scriptCache={},a._fileIdToUrlCache={}},_clearFileCache:function(a){var b=this;b._loaded||((b._scriptCache[a]||{}).expired=!0,b.emit("event.session.change"))}}),module.exports=SessionCore;