var fs = require('fs');
var path = require('path');

function resolveAsDirectory(moduleName) {
    var originallyResolvedPath = require.resolve(moduleName);
    var stat = fs.statSync(originallyResolvedPath);
    var dir;
    if (stat.isDirectory()) {
        dir = originallyResolvedPath;
    }
    else {
        dir = path.dirname(originallyResolvedPath);
    }
    while (typeof dir === 'string') {
        var basename = path.basename(dir);
        if (basename === moduleName) {
            var resolved = require.resolve(dir);
            if (resolved === originallyResolvedPath) {
                return dir;
            }
        }
        var parentDir = path.dirname(dir);
        if (typeof parentDir === 'string' && parentDir.length < dir.length) {
            dir = parentDir;
        }
        else {
            return null;
        }
    }
    return null;
}

if (process.argv.length === 3) {
    var resolvedDirectory = resolveAsDirectory(process.argv[2]);
    if (resolvedDirectory) {
        process.stdout.write(resolvedDirectory + '\n');
    }
}
