/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var profiler = require("{v8-path}");
var http = require("http");
var url = require("url");
var fs = require("fs");
var path = require("path");

var pattern = 'filePath=';
var cnt = 0;
var cpuCnt = 0;
var isCpuProfiling = false;
var pending = {};

function isDelimited(filePath, encodedChar) {
  return filePath.indexOf(encodedChar) == 0 && filePath.indexOf(encodedChar, filePath.length - 1 - encodedChar.length) > 0;
}

var server = null;

function saveSnapshot(cnt, filePath, uuid) {
  pending[uuid] = 1;
  var wstream = null;
  try {
    var snapshot = profiler.takeSnapshot("snapshot" + (cnt++));
    var options = {encoding: 'utf8', flags: 'w', autoClose: true};
    var directory = path.dirname(filePath);
    if (!fs.existsSync(directory)) {
      fs.mkdirSync(directory);
    }

    wstream = fs.createWriteStream(filePath, options);

    var queue = [];
    var drained = true;
    var everythingWritten = false;
    wstream.on('drain', function () {
      drained = true;
      writer();
    });
    wstream.once('open', function(fd) {
      wstream.once('close', function () {
        fs.fsync(fd, function(){});
        pending[uuid] = undefined;
      });
    });

    var writer = function() {
      while (queue.length > 0 && drained) {
        var data = queue.shift();
        if (!wstream.write(data, function() {
              if (everythingWritten && queue.length == 0) {
                wstream.end();
                return;
              }
            })) {
          drained = false;
          return;
        }
      }
    };
    snapshot.serialize(function iterator(data, length) {
      queue.push(data);
      writer();
    }, function callback() {
      everythingWritten = true;
      writer();
    });
    return true;
  } catch (e) {
    console.error(e);
    return false;
  } finally {
  }
}

function startProfiling(cpuCnt) {
  profiler.startProfiling("CpuSnaphot" + cpuCnt);
}

function stopProfiling(cpuCnt, filePath) {
  var wstream = null;
  try {
    var options = {encoding: 'utf8'};
    wstream = fs.createWriteStream(filePath, options);
    var profile = profiler.stopProfiling();
    wstream.write(JSON.stringify(profile));
  } catch (e) {
    //
  } finally {
    if (wstream != null) {
      wstream.end();
    }
  }
}

function process(request,response) {
  var parse = url.parse(request.url, true);
  var queryData = parse.query;
  var path = parse.pathname;
  if ("/status/" == path) {
    if (queryData.uuid != null) {
      response.write(pending[queryData.uuid] == undefined ? "ok" : "pending");
      response.end();
      return;
    }
  }
  var filePath = queryData.filePath;
  if (filePath != null) {
    if (isDelimited(filePath, "'") || isDelimited(filePath, "\"")) {
      filePath = filePath.substring(1, filePath.length - 1);
    }
  }
  if (filePath != null && "/takeHeapSnapshot/" == path) {
    if (saveSnapshot(cnt, filePath, queryData.uuid)) {
      response.write("ok");
    }
  } else if ("/stop" == path) {
    response.writeHeader(200, {"Content-Type": "text/plain"});
    if (server != null) {
      server.close();
    }
    response.write("ok");
  } else {
    response.writeHeader(404, {"Content-Type": "text/plain"});
  }
  response.end();
}

server = http.createServer(function (request,response){
  try {
    process(request, response);
  } catch (e) {
    console.error(e);
  }
}).listen({port});

var a = require("{app-path}");
