-- ids
--[[
["PETINFO"] = {
	["Carrion Rat"] = 540,
	["Shy Bandicoon"] = 677,
	["Ghastly Kid"] = 1442,
	["Mirror Strider"] = 566,
	["Enchanted Broom"] = 213,
	["Pierre"] = 1204,
	["Bucktooth Flapper"] = 380,
	["Scorpling"] = 416,
	["Chi-Chi, Hatchling of Chi-Ji"] = 1303,
	["Shore Crab"] = 388,
	["Servant of Demidos"] = 1601,
	["Cheetah Cub"] = 474,
	["Lanticore Spawnling"] = 1533,
	["Redridge Rat"] = 392,
	["Lil' Leftovers"] = 1395,
	["Proto-Drake Whelp"] = 196,
	["Bandicoon"] = 706,
	["Veilwatcher Hatchling"] = 1596,
	["Mr. Wiggles"] = 126,
	["Murkimus the Gladiator"] = 217,
	["Winter Reindeer"] = 118,
	["Grizzly Squirrel"] = 647,
	["Searing Scorchling"] = 172,
	["Leopard Scorpid"] = 545,
	["Fluxfire Feline"] = 1162,
	["Blue Moth"] = 138,
	["Grotto Vole"] = 539,
	["Prairie Dog"] = 386,
	["Tainted Cockroach"] = 497,
	["Horned Lizard"] = 851,
	["Albino Chimaeraling"] = 1385,
	["Lil' K.T."] = 249,
	["Darting Hatchling"] = 232,
	["Snake"] = 387,
	["Lil' Bad Wolf"] = 1226,
	["Dandelion Frolicker"] = 1329,
	["Spiny Lizard"] = 466,
	["Stone Armadillo"] = 485,
	["Mei Li Sparkler"] = 722,
	["Tiny Harvester"] = 389,
	["Argent Squire"] = 214,
	["Silent Hedgehog"] = 741,
	["Direhorn Runt"] = 1205,
	["Ash Spiderling"] = 427,
	["Golden Dragonhawk Hatchling"] = 142,
	["Rabid Nut Varmint 5000"] = 472,
	["Gilnean Raven"] = 630,
	["Hydraling"] = 1541,
	["Guild Herald"] = 283,
	["Gundrak Hatchling"] = 234,
	["Worg Pup"] = 89,
	["Jumping Spider"] = 699,
	["Desert Spider"] = 484,
	["Mudback Calf"] = 1594,
	["Crystal Spider"] = 634,
	["Twilight Fiendling"] = 552,
	["Junglebeak"] = 1469,
	["Blue Mini Jouster"] = 259,
	["Leatherhide Runt"] = 1435,
	["Emerald Turtle"] = 564,
	["Gilded Moth"] = 748,
	["Skunk"] = 397,
	["Flamering Moth"] = 1325,
	["Axebeak Hatchling"] = 1470,
	["Feverbite Hatchling"] = 714,
	["Son of Animus"] = 1183,
	["Pandaren Earth Spirit"] = 1126,
	["Zandalari Toenibbler"] = 1213,
	["Kuitan Mongoose"] = 680,
	["Baneling"] = 903,
	["Mojo"] = 165,
	["Giraffe Calf"] = 475,
	["Legs"] = 308,
	["Scarab Hatchling"] = 512,
	["Yu'lon Kite"] = 850,
	["Cockroach"] = 393,
	["Rotten Little Helper"] = 1349,
	["Darkmoon Balloon"] = 336,
	["Lofty Libram"] = 1159,
	["Vampiric Batling"] = 187,
	["Beetle"] = 406,
	["Ominous Flame"] = 1335,
	["Zao, Calfling of Niuzao"] = 1305,
	["Devouring Maggot"] = 523,
	["Feral Vermling"] = 821,
	["Lesser Voidcaller"] = 1234,
	["Sporeling Sprout"] = 515,
	["Wanderer's Festival Hatchling"] = 1013,
	["Father Winter's Helper"] = 119,
	["Rattlesnake"] = 431,
	["Garden Moth"] = 753,
	["Siamese Cat"] = 44,
	["Hopling"] = 835,
	["Crimson Moth"] = 421,
	["Chicken"] = 646,
	["Dread Hatchling"] = 1386,
	["Mini Diablo"] = 93,
	["Stinkbug"] = 492,
	["Arctic Hare"] = 641,
	["Restless Shadeling"] = 439,
	["Emerald Shale Hatchling"] = 837,
	["Lucky"] = 155,
	["Savory Beetle"] = 717,
	["Gahz'rooki"] = 1237,
	["Puddle Terror"] = 1568,
	["Mechanical Chicken"] = 83,
	["Cursed Birman"] = 1521,
	["Peanut"] = 159,
	["Tolai Hare Pup"] = 730,
	["Stunted Direhorn"] = 1184,
	["Silver Pig"] = 171,
	["Hawk Owl"] = 67,
	["Shadow Sporebat"] = 1599,
	["Sinister Squashling"] = 162,
	["Skywisp Moth"] = 1326,
	["Hatespark the Tiny"] = 1544,
	["Blue Clockwork Rocket Bot"] = 254,
	["Wild Crimson Hatchling"] = 819,
	["Mongoose Pup"] = 739,
	["Flayer Youngling"] = 514,
	["Zangar Crawler"] = 1582,
	["Mountain Cottontail"] = 391,
	["Cat"] = 459,
	["Bat"] = 626,
	["Spawn of Onyxia"] = 489,
	["Diemetradon Hatchling"] = 504,
	["Grassland Hopper"] = 733,
	["Fetish Shaman"] = 346,
	["Hyacinth Macaw"] = 49,
	["Golden Civet"] = 749,
	["Clouded Hedgehog"] = 742,
	["Fire Beetle"] = 415,
	["Rat"] = 417,
	["Whiskers the Rat"] = 127,
	["Alpine Chipmunk"] = 487,
	["Droplet of Y'Shaarj"] = 1331,
	["Alpine Hare"] = 441,
	["Spiky Lizard"] = 433,
	["Lava Beetle"] = 429,
	["Jade Crane Chick"] = 792,
	["Undercity Cockroach"] = 55,
	["Shimmershell Snail"] = 493,
	["Land Shark"] = 115,
	["Fishy"] = 847,
	["Widget the Departed"] = 1523,
	["Everbloom Peachick"] = 1566,
	["Nether Roach"] = 638,
	["Cornish Rex Cat"] = 41,
	["Rabbit"] = 378,
	["Dusk Spiderling"] = 396,
	["Tiny Green Carp"] = 1208,
	["Corefire Imp"] = 1149,
	["Darkmoon Glowfly"] = 1062,
	["Wood Wasp"] = 1463,
	["Mechanical Squirrel"] = 39,
	["Brown Marmot"] = 449,
	["Crimson Geode"] = 559,
	["Snow Cub"] = 440,
	["Son of Sethe"] = 1574,
	["Dancing Water Skimmer"] = 751,
	["Brilliant Spore"] = 1540,
	["Skittering Cavern Crawler"] = 637,
	["Tiny Twister"] = 445,
	["Creepy Crawly"] = 468,
	["Maggot"] = 450,
	["Enchanted Lantern"] = 267,
	["Oily Slimeling"] = 530,
	["Silithid Hatchling"] = 494,
	["Frostfur Rat"] = 1427,
	["Jungle Grub"] = 678,
	["Garden Frog"] = 569,
	["Westfall Chicken"] = 84,
	["Coral Snake"] = 488,
	["Moonkin Hatchling"] = 296,
	["Pygmy Cow"] = 1543,
	["Rock Viper"] = 482,
	["Little Fawn"] = 203,
	["Gulp Froglet"] = 1338,
	["Ruby Sapling"] = 460,
	["Moccasin"] = 422,
	["Obsidian Hatchling"] = 236,
	["Snowy Panda"] = 1197,
	["Crow"] = 1068,
	["Creepy Crate"] = 321,
	["Baby Ape"] = 411,
	["Spectral Porcupette"] = 1185,
	["Emerald Boa"] = 631,
	["Elementium Geode"] = 293,
	["Razormaw Hatchling"] = 238,
	["Blossoming Ancient"] = 1248,
	["Sky-Bo"] = 1467,
	["Jademist Dancer"] = 1333,
	["Netherwhelp"] = 131,
	["Grinder"] = 834,
	["Darkmoon Hatchling"] = 1061,
	["Stout Alemental"] = 1518,
	["Toad"] = 420,
	["Lashtail Hatchling"] = 307,
	["Black Tabby Cat"] = 42,
	["Macabre Marionette"] = 1351,
	["Tiny Flamefly"] = 287,
	["Jade Tiger"] = 231,
	["Gryphon Hatchling"] = 245,
	["Hyjal Bear Cub"] = 317,
	["Elwynn Lamb"] = 209,
	["Jade Tentacle"] = 856,
	["Phoenix Hatchling"] = 175,
	["Infested Bear Cub"] = 453,
	["Mac Frog"] = 542,
	["Orange Tabby Cat"] = 43,
	["Jade Oozeling"] = 446,
	["Nether Faerie Dragon"] = 557,
	["Undercity Rat"] = 454,
	["Mini Tyrael"] = 189,
	["Netherspace Abyssal"] = 1228,
	["Sun Sproutling"] = 1434,
	["Pocket Reaver"] = 1233,
	["Ammen Vale Lashling"] = 212,
	["De-Weaponized Mechanical Companion"] = 262,
	["Speedy"] = 125,
	["Highlands Mouse"] = 550,
	["Tiny Shale Spider"] = 279,
	["Black Kingsnake"] = 75,
	["Grove Viper"] = 571,
	["Lovebird Hatchling"] = 1511,
	["Deathy"] = 294,
	["Firewing"] = 1545,
	["Wild Golden Hatchling"] = 818,
	["Tiny White Carp"] = 1209,
	["Crimson Snake"] = 78,
	["Ashleaf Spriteling"] = 1323,
	["Skunky Alemental"] = 1336,
	["Tiny Snowman"] = 117,
	["Sidewinder"] = 511,
	["Stitched Pup"] = 1146,
	["Living Sandling"] = 1177,
	["Chrominius"] = 1152,
	["Golden Pig"] = 170,
	["Armadillo Pup"] = 272,
	["Guild Page"] = 281,
	["Gurky"] = 121,
	["Clockwork Rocket Bot"] = 191,
	["Imperial Eagle Chick"] = 534,
	["Lurky"] = 111,
	["Baby Blizzard Bear"] = 202,
	["Azure Crane Chick"] = 1321,
	["Brilliant Bloodfeather"] = 1572,
	["Bloodsting Wasp"] = 1462,
	["Bandicoon Kit"] = 707,
	["Infected Fawn"] = 628,
	["Hippogryph Hatchling"] = 130,
	["Grommloc"] = 1602,
	["Brilliant Kaliri"] = 325,
	["Prairie Mouse"] = 727,
	["Eye of the Legion"] = 348,
	["Ash Viper"] = 425,
	["Murkalot"] = 1364,
	["Clefthoof Runt"] = 518,
	["Doom Bloom"] = 1564,
	["Willy"] = 157,
	["Crazy Carrot"] = 1396,
	["Pandaren Fire Spirit"] = 1124,
	["Green Wing Macaw"] = 50,
	["Fjord Rat"] = 644,
	["Dun Morogh Cub"] = 205,
	["Scorpid"] = 414,
	["Cobra Hatchling"] = 197,
	["Feline Familiar"] = 319,
	["Lava Crab"] = 423,
	["Zergling"] = 94,
	["Black Lamb"] = 374,
	["Summit Kid"] = 679,
	["Gazelle Fawn"] = 477,
	["Elder Python"] = 1181,
	["Mr. Grubbs"] = 286,
	["Tiny Red Carp"] = 1206,
	["Brown Snake"] = 77,
	["Cinder Kitten"] = 1117,
	["Teldrassil Sproutling"] = 204,
	["Malayan Quillrat Pup"] = 709,
	["Nuts"] = 323,
	["Death Adder Hatchling"] = 1330,
	["Ruby Droplet"] = 1328,
	["Bonkers"] = 1343,
	["Spirit of Competition"] = 179,
	["Jadefire Spirit"] = 1348,
	["Lil' Tarecgosa"] = 320,
	["Thicket Skitterer"] = 1456,
	["Sandy Petrel"] = 573,
	["Frog"] = 495,
	["Amber Moth"] = 732,
	["Winter's Little Helper"] = 120,
	["Forest Moth"] = 478,
	["Ashwing Moth"] = 1324,
	["Mr. Chilly"] = 192,
	["Blighted Squirrel"] = 455,
	["Iron Starlette"] = 1387,
	["Lil' Bling"] = 1320,
	["Mechanical Pandaren Dragonling"] = 844,
	["Strand Crawler"] = 211,
	["Clock'em"] = 1142,
	["Mini Thor"] = 258,
	["Gregarious Grell"] = 333,
	["Golden Civet Kitten"] = 750,
	["Lumpy"] = 337,
	["Plains Monitor"] = 726,
	["Bananas"] = 156,
	["Darkmoon Zeppelin"] = 339,
	["Crunchy Scorpion"] = 745,
	["Ancient Nest Guardian"] = 1531,
	["Darkmoon Turtle"] = 335,
	["Tundra Penguin"] = 536,
	["Death's Head Cockroach"] = 755,
	["Crimson Lasher"] = 318,
	["Shimmering Wyrmling"] = 229,
	["Mechanical Axebeak"] = 1403,
	["Blighthawk"] = 456,
	["Bone Wasp"] = 1458,
	["Sunreaver Micro-Sentry"] = 1178,
	["Zomstrok"] = 1428,
	["Weebomination"] = 1394,
	["Zipao Tiger"] = 247,
	["Masked Tanuki Pup"] = 703,
	["Fledgling Nether Ray"] = 521,
	["Zandalari Footslasher"] = 1212,
	["Eternal Strider"] = 383,
	["Zandalari Anklerender"] = 1211,
	["Porcupette"] = 381,
	["Yu'la, Broodling of Yu'lon"] = 1304,
	["Yellow-Bellied Marmot"] = 549,
	["Yellow-Bellied Bullfrog"] = 752,
	["Parrot"] = 403,
	["Oasis Moth"] = 544,
	["Sand Kitten"] = 491,
	["Xu-Fu, Cub of Xuen"] = 1266,
	["Withers"] = 220,
	["Viscous Horror"] = 1244,
	["Meadowstomper Calf"] = 1446,
	["Wind Rider Cub"] = 246,
	["Brown Prairie Dog"] = 70,
	["Frosty"] = 188,
	["Elfin Rabbit"] = 479,
	["Wildhammer Gryphon Hatchling"] = 548,
	["Wild Jade Hatchling"] = 817,
	["White Tickbird Hatchling"] = 195,
	["White Moth"] = 141,
	["Wharf Rat"] = 410,
	["Thundertail Flapper"] = 1175,
	["Pengu"] = 198,
	["Bombay Cat"] = 40,
	["Water Snake"] = 418,
	["Gold Beetle"] = 430,
	["Small Frog"] = 419,
	["Eye of Observation"] = 1576,
	["Ghostly Skull"] = 190,
	["Warpstalker Hatchling"] = 517,
	["Venus"] = 855,
	["Venomspitter Hatchling"] = 506,
	["Highlands Skunk"] = 823,
	["Ethereal Soul-Trader"] = 183,
	["Unborn Val'kyr"] = 1238,
	["Murky"] = 107,
	["Twilight Wasp"] = 1464,
	["Hare"] = 448,
	["Flat-Tooth Calf"] = 1595,
	["Draenei Micro Defender"] = 1450,
	["Twilight Iguana"] = 505,
	["Twilight Beetle"] = 469,
	["Turkey"] = 525,
	["Tuskarr Kite"] = 241,
	["Nightsaber Cub"] = 303,
	["Stormwing"] = 1546,
	["Menagerie Custodian"] = 1227,
	["Turquoise Turtle"] = 473,
	["Fox Kit"] = 278,
	["Trunks"] = 1605,
	["Sapphire Cub"] = 846,
	["Horde Balloon"] = 332,
	["Tree Python"] = 405,
	["Mongoose"] = 737,
	["Living Fluid"] = 1243,
	["Sea Calf"] = 1448,
	["Tranquil Mechanical Yeti"] = 116,
	["Onyxian Whelpling"] = 243,
	["Marsh Fiddler"] = 710,
	["Lil' Deathwing"] = 268,
	["Topaz Shale Hatchling"] = 480,
	["Kovok"] = 1334,
	["Ancona Chicken"] = 52,
	["Toothy"] = 163,
	["Tolai Hare"] = 729,
	["Cogblade Raptor"] = 1164,
	["Argi"] = 1603,
	["Tree Frog"] = 65,
	["Resilient Roach"] = 744,
	["Tirisfal Batling"] = 206,
	["Muckbreath"] = 164,
	["Guardian Cub"] = 311,
	["Tiny Green Dragon"] = 757,
	["Amberbarb Wasp"] = 1465,
	["Tiny Bog Beast"] = 509,
	["Rusty Snail"] = 496,
	["Tiny Blue Carp"] = 1207,
	["Tideskipper"] = 1230,
	["Tickbird Hatchling"] = 194,
	["Spiny Terrapin"] = 723,
	["Calico Cat"] = 224,
	["Waterfly"] = 1593,
	["Anubisath Idol"] = 1155,
	["Thundering Serpent Hatchling"] = 802,
	["Red Panda"] = 1176,
	["Ravasaur Hatchling"] = 237,
	["Terky"] = 1073,
	["Temple Snake"] = 567,
	["Egbert"] = 158,
	["Essence of Competition"] = 180,
	["Tainted Waveling"] = 1231,
	["Tainted Rat"] = 499,
	["Molten Hatchling"] = 428,
	["Ravager Hatchling"] = 465,
	["Szechuan Chicken"] = 728,
	["Soul of the Forge"] = 1569,
	["Swamplighter Firefly"] = 1590,
	["Swamp Moth"] = 402,
	["Swamp Croaker"] = 1182,
	["Fruit Hunter"] = 1471,
	["Sunfur Panda"] = 1196,
	["Azure Whelpling"] = 57,
	["Fawn"] = 447,
	["Sumprush Rodent"] = 1128,
	["Stunted Yeti"] = 1158,
	["Stunted Shardhorn"] = 532,
	["Rascal-Bot"] = 1256,
	["Stowaway Rat"] = 553,
	["Frigid Frostling"] = 253,
	["Stonegrinder"] = 1515,
	["Spotted Bell Frog"] = 502,
	["Spirit of Summer"] = 128,
	["Plump Turkey"] = 201,
	["Spirebound Crab"] = 572,
	["Lifelike Toad"] = 95,
	["Cenarion Hatchling"] = 316,
	["Spineclaw Crab"] = 1337,
	["Pygmy Direhorn"] = 1200,
	["Wolpertinger"] = 153,
	["Spider"] = 412,
	["Harbinger of Flame"] = 1147,
	["Spectral Tiger Cub"] = 242,
	["Spectral Cub"] = 1127,
	["Long-tailed Mole"] = 404,
	["Fire-Proof Roach"] = 541,
	["Fel Flame"] = 519,
	["Spawn of G'nathus"] = 1201,
	["Death Talon Whelpguard"] = 1153,
	["Crimson Shale Hatchling"] = 554,
	["Syd the Squid"] = 1478,
	["Soul of the Aspects"] = 347,
	["Fjord Worg Pup"] = 529,
	["Softshell Snapling"] = 713,
	["Gu'chi Swarmling"] = 1345,
	["Core Hound Pup"] = 244,
	["Snowshoe Rabbit"] = 72,
	["Emerald Proto-Whelp"] = 1167,
	["Deviate Hatchling"] = 233,
	["Rustberg Gull"] = 271,
	["Snarly"] = 173,
	["Ash Lizard"] = 632,
	["Luyu Moth"] = 718,
	["Sky Fry"] = 1575,
	["Singing Sunflower"] = 291,
	["Arctic Fox Kit"] = 558,
	["Gusting Grimoire"] = 1174,
	["Singing Cricket"] = 820,
	["Harpy Youngling"] = 1157,
	["Phoenix Hawk Hatchling"] = 1235,
	["Silky Moth"] = 503,
	["Frostshell Pincher"] = 1578,
	["Silkbead Snail"] = 568,
	["Firefly"] = 146,
	["Landro's Lichling"] = 302,
	["Panda Cub"] = 92,
	["Imperial Moth"] = 1039,
	["Kirin Tor Familiar"] = 199,
	["Forest Sproutling"] = 1430,
	["Giant Sewer Rat"] = 193,
	["Shore Crawler"] = 629,
	["Magical Crawdad"] = 132,
	["Sentinel's Companion"] = 1567,
	["Squirrel"] = 379,
	["Roach"] = 424,
	["Effervescent Glowfly"] = 747,
	["Lil' XT"] = 256,
	["Sea Pony"] = 340,
	["Widow Spiderling"] = 400,
	["Sea Gull"] = 560,
	["Scourged Whelpling"] = 538,
	["Scooter the Snail"] = 289,
	["Nether Ray Fry"] = 186,
	["Scalded Basilisk Hatchling"] = 528,
	["Red-Tailed Chipmunk"] = 452,
	["Sand Scarab"] = 665,
	["Anodized Robo Cub"] = 1163,
	["Yakrat"] = 740,
	["Snowshoe Hare"] = 640,
	["Royal Peacock"] = 1411,
	["Pandaren Air Spirit"] = 1125,
	["Moonshell Crab"] = 1447,
	["Stinker"] = 160,
	["Dung Beetle"] = 467,
	["Twilight Spider"] = 470,
	["Tito"] = 1236,
	["Borean Marmot"] = 639,
	["Jubling"] = 106,
	["Festering Maggot"] = 457,
	["Red Moth"] = 139,
	["Red Cricket"] = 1042,
	["Aqua Strider"] = 836,
	["Senegal"] = 51,
	["Teroclaw Hatchling"] = 1416,
	["Tainted Moth"] = 498,
	["Crimson Whelpling"] = 58,
	["Disgusting Oozeling"] = 114,
	["Zandalari Kneebiter"] = 1180,
	["Pint-Sized Pink Pachyderm"] = 166,
	["Durotar Scorpion"] = 207,
	["Lil' Ragnaros"] = 297,
	["Stripe-Tailed Scorpid"] = 432,
	["Red Dragonhawk Hatchling"] = 143,
	["Golden Dawnfeather"] = 1573,
	["Celestial Dragon"] = 255,
	["Purple Puffer"] = 328,
	["Locust"] = 543,
	["Perky Pug"] = 250,
	["Pterrordax Hatchling"] = 309,
	["Tol'vir Scarab"] = 546,
	["Lifelike Mechanical Frostboar"] = 1412,
	["Mossbite Skitterer"] = 1455,
	["Polly"] = 409,
	["Fledgling Buzzard"] = 395,
	["Blue Dragonhawk Hatchling"] = 145,
	["Poley"] = 124,
	["Albino River Calf"] = 1571,
	["Darkmoon Eye"] = 1063,
	["Spirit Crab"] = 463,
	["Darkmoon Cub"] = 343,
	["Silver Tabby Cat"] = 45,
	["Blackfuse Bombling"] = 1322,
	["Pet Bombling"] = 85,
	["Imperial Silkworm"] = 1040,
	["Crystal Beetle"] = 556,
	["Warbot"] = 227,
	["Argent Gruntling"] = 216,
	["Darkmoon Tonk"] = 338,
	["Gold Mini Jouster"] = 260,
	["Personal World Destroyer"] = 261,
	["Water Waveling"] = 535,
	["Pebble"] = 265,
	["Yellow Moth"] = 140,
	["Parched Lizard"] = 1615,
	["Panther Cub"] = 301,
	["Leaping Hatchling"] = 235,
	["Darkshore Cub"] = 508,
	["Darkmoon Rabbit"] = 848,
	["Royal Moth"] = 1587,
	["Ikky"] = 1532,
	["Curious Wolvar Pup"] = 226,
	["Viscidus Globule"] = 1154,
	["Voodoo Figurine"] = 310,
	["Coral Adder"] = 562,
	["Ore Eater"] = 1495,
	["Onyx Panther"] = 240,
	["Kun-Lai Runt"] = 1166,
	["Emperor Crab"] = 746,
	["Nightshade Sproutling"] = 1432,
	["Tiny Goldfish"] = 652,
	["Filthling"] = 1245,
	["Nexus Whelpling"] = 1165,
	["Dragon Kite"] = 169,
	["Strand Crab"] = 401,
	["Netherspawn, Spawn of Netherspawn"] = 1524,
	["Winterspring Cub"] = 306,
	["Ashstone Core"] = 1150,
	["Razzashi Hatchling"] = 239,
	["Spring Rabbit"] = 200,
	["Umbrafen Spore"] = 1538,
	["Murki"] = 1168,
	["Blazing Cindercrawler"] = 1517,
	["Mulgore Hatchling"] = 210,
	["Lucky Quilen Cub"] = 671,
	["Frostwolf Ghostpup"] = 1530,
	["Deathwatch Hatchling"] = 1449,
	["Pandaren Monk"] = 248,
	["Tiny Sporebat"] = 167,
	["Mountain Skunk"] = 633,
	["Mountain Panda"] = 1198,
	["Larva"] = 461,
	["Rat Snake"] = 399,
	["Rocket Chicken"] = 168,
	["Moon Moon"] = 1276,
	["Gooey Sha-ling"] = 1332,
	["Molten Corgi"] = 1451,
	["Minfernal"] = 500,
	["Mouse"] = 385,
	["Darkmoon Monkey"] = 330,
	["Black Rat"] = 398,
	["Mechanopeep"] = 215,
	["Icespine Hatchling"] = 1457,
	["Highlands Turkey"] = 645,
	["Mechanical Scorpid"] = 1565,
	["Bronze Whelpling"] = 1563,
	["Dark Phoenix Hatchling"] = 270,
	["Alterac Brew-Pup"] = 1363,
	["Deepholm Cockroach"] = 555,
	["Grasslands Cottontail"] = 443,
	["Grey Moth"] = 464,
	["Lunar Lantern"] = 341,
	["Mana Wyrmling"] = 136,
	["Toxic Wasteling"] = 251,
	["Fungal Abomination"] = 1144,
	["Crimson Spore"] = 1537,
	["Huge Toad"] = 648,
	["Clockwork Gnome"] = 277,
	["Magic Lamp"] = 292,
	["Sky Lantern"] = 1350,
	["Adder"] = 635,
	["Brown Rabbit"] = 137,
	["Lost of Lordaeron"] = 458,
	["Lizard Hatchling"] = 408,
	["Crested Owl"] = 507,
	["Little Black Ram"] = 437,
	["Crawling Claw"] = 264,
	["Murkablo"] = 329,
	["Ironclaw Scuttler"] = 1579,
	["Leopard Tree Frog"] = 702,
	["Pandaren Water Spirit"] = 868,
	["White Kitten"] = 46,
	["Lil' Smoky"] = 86,
	["Curious Oracle Hatchling"] = 225,
	["Landro's Lil' XT"] = 285,
	["Jade Owl"] = 845,
	["Forest Spiderling"] = 407,
	["Festival Lantern"] = 342,
	["Sifang Otter Pup"] = 712,
	["Zooey Snake"] = 731,
	["Cockatiel"] = 47,
	["Elekk Plushie"] = 1426,
	["Fiendish Imp"] = 1229,
	["King Snake"] = 438,
	["Kelp Scuttler"] = 1583,
	["Masked Tanuki"] = 570,
	["Kaliri Hatchling"] = 1597,
	["Frostwolf Pup"] = 1542,
	["Silver Dragonhawk Hatchling"] = 144,
	["Terrible Turnip"] = 650,
	["Snowy Owl"] = 69,
	["Amethyst Spiderling"] = 716,
	["Rapana Whelk"] = 743,
	["Irradiated Roach"] = 442,
	["Mystical Spring Bouquet"] = 1514,
	["Dragonbone Hatchling"] = 537,
	["Stormwind Rat"] = 675,
	["Infected Squirrel"] = 627,
	["Great Horned Owl"] = 68,
	["Sifang Otter"] = 711,
	["Alliance Balloon"] = 331,
	["Alpine Foxling"] = 724,
	["Horny Toad"] = 483,
	["Alpine Foxling Kit"] = 725,
	["Bush Chicken"] = 1516,
	["Vengeful Porcupette"] = 1344,
	["Harmonious Porcupette"] = 1346,
	["Sprite Darter Hatchling"] = 87,
	["Nordrassil Wisp"] = 547,
	["Biletoad"] = 649,
	["Tiny Red Dragon"] = 758,
	["Miniwing"] = 149,
	["Grunty"] = 228,
	["Ji-Kun Hatchling"] = 1202,
	["Arcane Eye"] = 1160,
	["Malayan Quillrat"] = 708,
	["Robo-Chick"] = 471,
	["Chi-Ji Kite"] = 849,
	["Amethyst Shale Hatchling"] = 838,
	["Qiraji Guardling"] = 513,
	["Shrine Fly"] = 754,
	["Infinite Whelpling"] = 1161,
	["Giant Bone Spider"] = 1143,
	["Fungal Moth"] = 756,
	["Fossilized Hatchling"] = 266,
	["Mud Jumper"] = 1441,
	["Untamed Hatchling"] = 1151,
	["Chuck"] = 174,
	["Jungle Darter"] = 565,
	["Mr. Bigglesworth"] = 1145,
	["Smolderweb Hatchling"] = 90,
	["Wood Frog"] = 64,
	["Treasure Goblin"] = 1365,
	["Sunfire Kaliri"] = 1570,
	["Emerald Whelpling"] = 59,
	["Electrified Razortooth"] = 1179,
	["Dark Whelpling"] = 56,
	["Sen'jin Fetish"] = 218,
	["Coilfang Stalker"] = 1232,
	["Albino Snake"] = 74,
	["Mini Mindslayer"] = 1156,
	["Peddlefeet"] = 122,
	}
]]

local AtlasLoot = _G.AtlasLoot
local Pet = AtlasLoot.Button:AddType("Pet", "pet")
local Item = AtlasLoot.Button:GetType("Item")
local AL = AtlasLoot.Locales

--lua
local type = type
local tonumber = tonumber
local str_match = string.match

-- blizzard
local IsAddOnLoaded, LoadAddOn = IsAddOnLoaded, LoadAddOn 
local ShowUIPanel = ShowUIPanel
local C_PetJournal_GetPetInfoBySpeciesID = C_PetJournal.GetPetInfoBySpeciesID

local PET_COLOR = "|cffffff00"
local PET_JOURNAL_TEXTURE = "Interface\\PetBattles\\PetJournal"

local PetClickHandler = nil

function Pet.OnSet(button, second)
	if not PetClickHandler then
		PetClickHandler = AtlasLoot.ClickHandler:Add(
		"Pet",
		{
			GoTo = { "LeftButton", "None" },
			types = {
				GoTo = true,
			},
		},
		AtlasLoot.db.Button.Pet.ClickHandler, 
		{
			{ "GoTo",		AL["Show Pet in Journal"],			AL["Show Pet in Journal"] },
		})
	end
	if not button then return end
	if second and button.__atlaslootinfo.secType then
		if type(button.__atlaslootinfo.secType[2]) == "table" then
			button.secButton.PetID = button.__atlaslootinfo.secType[2][1]
			button.secButton.ItemID = button.__atlaslootinfo.secType[2][2]
		else
			button.secButton.PetID = button.__atlaslootinfo.secType[2]
		end
		Pet.Refresh(button.secButton)
	else
		if type(button.__atlaslootinfo.type[2]) == "table" then
			button.PetID = button.__atlaslootinfo.type[2][1]
			button.ItemID = button.__atlaslootinfo.type[2][2]
		else
			button.PetID = button.__atlaslootinfo.type[2]
		end
		Pet.Refresh(button)
	end
end

function Pet.OnMouseAction(button, mouseButton)
	if not mouseButton then return end
	mouseButton = PetClickHandler:Get(mouseButton)
	if mouseButton == "GoTo" then
		if not IsAddOnLoaded("Blizzard_Collections") then
			LoadAddOn("Blizzard_Collections")
		end
		
		ShowUIPanel(CollectionsJournal)
		CollectionsJournal_SetTab(CollectionsJournal, 2) -- 1 = Mounts
		PetJournal_ShowPetCardBySpeciesID(button.PetID)
	end
end

function Pet.OnClear(button)
	button.PetID = nil
	button.secButton.PetID = nil
	
	button.info = nil
	button.secButton.info = nil
	
	button.overlay:Hide()
	button.overlay:SetHeight(button.icon:GetWidth())
	button.overlay:SetWidth(button.icon:GetWidth())
	
	button.secButton.overlay:Hide()
	button.secButton.overlay:SetHeight(button.icon:GetWidth())
	button.secButton.overlay:SetWidth(button.icon:GetWidth())
	
end

function Pet.OnEnter(button)
	Pet.ShowToolTipFrame(button)
end

function Pet.OnLeave(button)
	if Pet.tooltipFrame then Pet.tooltipFrame:Hide() end
	if button.ItemID then Item.OnLeave(button) end
end
--[[
self.TypeInfo.type:SetText(_G["BATTLE_PET_NAME_"..petType]);
	self.TypeInfo.typeIcon:SetTexture("Interface\\PetBattles\\PetIcon-"..PET_TYPE_SUFFIX[petType]);
	self.TypeInfo.abilityID = PET_BATTLE_PET_TYPE_PASSIVES[petType];
	
		--Update pet abilites
	local abilities, levels = C_PetJournal.GetPetAbilityList(speciesID);
	for i=1,NUM_PET_ABILITIES do  -- 6 abilities
		local spellFrame = self["spell"..i];
		if abilities[i] and canBattle then
			local name, icon, petType = C_PetJournal.GetPetAbilityInfo(abilities[i]);
			local isNotUsable = not level or level < levels[i];
			spellFrame.icon:SetTexture(icon);
			spellFrame.icon:SetDesaturated(isNotUsable);
			spellFrame.LevelRequirement:SetText(levels[i]);
			spellFrame.LevelRequirement:SetShown(isNotUsable);
			spellFrame.BlackCover:SetShown(isNotUsable);
			if (not level or level < levels[i]) then
				spellFrame.additionalText = format(PET_ABILITY_REQUIRES_LEVEL, levels[i]);
			else
				spellFrame.additionalText = nil;
			end
			spellFrame.abilityID = abilities[i];
			spellFrame.petID = PetJournalPetCard.petID;
			spellFrame.speciesID = speciesID;
			spellFrame:Show();
		else
			spellFrame:Hide();
		end
	end
	
	<Texture name="$parentIconBorder" file="Interface\PetBattles\PetJournal" parentKey="iconBorder">
					<Anchors>
						<Anchor point="CENTER" relativeTo="$parentIcon" x="0" y="0"/>
					</Anchors>
					<Size x="53" y="54"/>
					<TexCoords left="0.41992188" right="0.52343750" top="0.02246094" bottom="0.07519531"/>	
				</Texture>
]]--
function Pet.Refresh(button)
	-- speciesName, speciesIcon, petType, companionID, tooltipSource, tooltipDescription, isWild, canBattle, isTradeable, isUnique, obtainable = C_PetJournal.GetPetInfoBySpeciesID(button.PetID)
	local speciesName, speciesIcon, petType, companionID, tooltipSource, tooltipDescription = C_PetJournal_GetPetInfoBySpeciesID(button.PetID)
	if not speciesName then return end
	if button.type == "secButton" then
		--/dump C_PetJournal.GetPetInfoBySpeciesID(1145)
	else
		button.name:SetText(PET_COLOR..speciesName)
		button.extra:SetText(_G["BATTLE_PET_NAME_"..petType])
	end

	
	button.overlay:Show()
	button.overlay:SetTexture(PET_JOURNAL_TEXTURE)
	button.overlay:SetTexCoord(0.41992188, 0.52343750, 0.02246094, 0.07519531)
	button.overlay:SetHeight(button.icon:GetHeight()*1.2)
	button.overlay:SetWidth(button.icon:GetWidth()*1.2)

	
	button.icon:SetTexture(speciesIcon)
	button.info = {speciesName, speciesIcon, petType, tooltipSource, tooltipDescription, companionID}
end

function Pet.GetStringContent(str)
	if tonumber(str) then
		return tonumber(str)
	else
		return {
			str_match(str, "(%d+)"),
			str_match(str, "i(%d+)"),	-- linked item
		}
	end
end

--################################
-- Pet frame
--################################
function Pet.ShowToolTipFrame(button)

	if not Pet.tooltipFrame then 
		local name = "AtlasLoot-PetToolTip"
		local frame = CreateFrame("Frame", name)
		frame:SetClampedToScreen(true)
		frame:SetSize(300, 50)
		frame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
							edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
							tile = true, tileSize = 16, edgeSize = 16, 
							insets = { left = 4, right = 4, top = 4, bottom = 4 }})
		frame:SetBackdropColor(0,0,0,1)
		
		frame.icon = frame:CreateTexture(name.."-icon", frame)
		frame.icon:SetPoint("TOPLEFT", frame, "TOPLEFT", 5, -5)
		frame.icon:SetHeight(26)
		frame.icon:SetWidth(26)
		frame.icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
		
		frame.name = frame:CreateFontString(name.."-name", "ARTWORK", "GameFontNormal")
		frame.name:SetPoint("TOPLEFT", frame.icon, "TOPRIGHT", 3, 0)
		frame.name:SetJustifyH("LEFT")
		frame.name:SetWidth(250)
		--frame.name:SetHeight(12)
		frame.name:SetTextColor(1, 1, 1, 1)
		
		frame.source = frame:CreateFontString(name.."-source", "ARTWORK", "GameFontNormalSmall")
		frame.source:SetPoint("TOPLEFT", frame.name, "BOTTOMLEFT", 0, -1)
		frame.source:SetJustifyH("LEFT")
		frame.source:SetJustifyV("TOP")
		frame.source:SetWidth(250)
		--frame.info:SetHeight(20)
		frame.source:SetTextColor(1, 1, 1, 1)
		
		frame.model = CreateFrame("PlayerModel", name.."-model")
		frame.model:ClearAllPoints()
		frame.model:SetParent(frame)
		frame.model:SetPoint("TOPLEFT", frame.icon, "BOTTOMLEFT", 0, -3)
		frame.model:SetSize(145,145)
		frame.model:SetRotation(MODELFRAME_DEFAULT_ROTATION)
		
		frame.desc = frame:CreateFontString(name.."-desc", "ARTWORK", "GameFontNormalSmall")
		frame.desc:SetPoint("TOPLEFT", frame.model, "TOPRIGHT", 0, -3)
		frame.desc:SetJustifyH("LEFT")
		frame.desc:SetJustifyV("TOP")
		frame.desc:SetWidth(145)
		frame.desc:SetHeight(145)
		frame.desc:SetTextColor(1, 1, 1, 1)

		frame.typeIcon = frame:CreateTexture(name.."-typeIcon", frame)
		frame.typeIcon:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -5, -5)
		frame.typeIcon:SetHeight(20)
		frame.typeIcon:SetWidth(20)
		frame.typeIcon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
		frame.typeIcon:SetTexCoord(0.79687500, 0.49218750, 0.50390625, 0.65625000)
		
		Pet.tooltipFrame = frame
	end
	local tmp
	local frame = Pet.tooltipFrame
	frame:ClearAllPoints()
	frame:SetParent(button:GetParent():GetParent())
	frame:SetFrameStrata("TOOLTIP")
	frame:SetPoint("BOTTOMLEFT", button, "TOPRIGHT")
	
	frame.name:SetText(button.info[1])
	frame.source:SetText(button.info[4])
	frame.icon:SetTexture(button.info[2])
	tmp = frame.name:GetHeight()+frame.source:GetHeight()
	frame.icon:SetSize(tmp,tmp)
	frame:SetHeight(tmp+155)
	
	frame.desc:SetText(button.info[5])
	
	frame.model:SetCreature(button.info[6])
	frame.model:SetDoBlend(false)
	--frame.model:SetAnimation(0,-1) 0=alive, 6=dead
	
	frame.typeIcon:SetTexture("Interface\\PetBattles\\PetIcon-"..PET_TYPE_SUFFIX[button.info[3]])
	
	
	
	frame:Show()
	if button.ItemID then
		Item.OnEnter(button, {frame, "ANCHOR_TOPLEFT", 0, 2})
	end
end

function AtlasLoot:DEV_Renew()
	self.db.PETINFO = {}
	local petID, speciesID, owned, customName, level, favorite, isRevoked, speciesName
	local numPets = C_PetJournal.GetNumPets()
	
	for i=1,numPets do
		petID, speciesID, owned, customName, level, favorite, isRevoked, speciesName = C_PetJournal.GetPetInfoByIndex(i)
		if speciesName and speciesID then
			self.db.PETINFO[speciesName] = speciesID
		end
	end
end
