/*
 * Decompiled with CFR 0.152.
 */
package com.noahc3.abilitystones.recipe;

import com.noahc3.abilitystones.AbilityStones;
import com.noahc3.abilitystones.block.advancedAbilityInfuser.TileEntityAdvancedAbilityInfuser;
import com.noahc3.abilitystones.item.ModItems;
import com.noahc3.abilitystones.recipe.AdvRecipe;
import com.noahc3.abilitystones.recipe.ItemGroup;
import com.noahc3.abilitystones.recipe.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AdvancedInfuserCraftingManager {
    public static ArrayList<AdvRecipe> recipes = new ArrayList();
    private static int defaultDustCost = 7;

    private static ItemStack generatePotionWithEffect(String effect) {
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Potion", effect);
        potion.func_77982_d(nbt);
        return potion;
    }

    public static int curveDustCost(ArrayList<String> idsToApply, int dustCost) {
        int i;
        if (idsToApply.size() == 0) {
            return 0;
        }
        ArrayList<String> realIdsToApply = new ArrayList<String>();
        for (i = 0; i < idsToApply.size(); ++i) {
            if (idsToApply.get(i).equals("Time Amplification")) continue;
            realIdsToApply.add(idsToApply.get(i));
        }
        for (i = 0; i < realIdsToApply.size(); ++i) {
            dustCost -= 2 * i;
        }
        return dustCost;
    }

    public static String getAbilitiesAsString(ItemStack stone) {
        String abilities = "Abilities: ";
        int num = 0;
        if (stone.func_77942_o()) {
            if (!stone.func_77978_p().func_74779_i("eff1").equals("")) {
                ++num;
                abilities = abilities + stone.func_77978_p().func_74779_i("eff1") + ", ";
            }
            if (!stone.func_77978_p().func_74779_i("eff2").equals("")) {
                ++num;
                abilities = abilities + stone.func_77978_p().func_74779_i("eff2") + ", ";
            }
            if (!stone.func_77978_p().func_74779_i("eff3").equals("")) {
                ++num;
                abilities = abilities + stone.func_77978_p().func_74779_i("eff3") + ", ";
            }
            if (!stone.func_77978_p().func_74779_i("eff1").equals("")) {
                ++num;
                abilities = abilities + stone.func_77978_p().func_74779_i("eff4") + ", ";
            }
            if (!abilities.equals("")) {
                abilities = abilities.substring(0, abilities.length() - 2);
            }
        }
        if (num == 0) {
            abilities = "No Abilities";
        }
        return abilities;
    }

    public static void generateRecipeList() {
        recipes.add(new AdvRecipe("Swiftness", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:strong_swiftness"), 1)));
        recipes.add(new AdvRecipe("Strength", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:strong_strength"), 1)));
        recipes.add(new AdvRecipe("Night Vision", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:long_night_vision"), 1)));
        recipes.add(new AdvRecipe("Regeneration", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:strong_regeneration"), 1)));
        recipes.add(new AdvRecipe("Leaping", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:strong_leaping"), 1)));
        recipes.add(new AdvRecipe("Fire Resistance", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:long_fire_resistance"), 1)));
        recipes.add(new AdvRecipe("Invisibility", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:long_invisibility"), 1)));
        recipes.add(new AdvRecipe("Water Breathing", defaultDustCost, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:long_water_breathing"), 1)));
        recipes.add(new AdvRecipe("Saturation", defaultDustCost, new ItemGroup(new ItemStack(Items.field_151153_ao), 1)));
        recipes.add(new AdvRecipe("Resistance", defaultDustCost, new ItemGroup(new ItemStack(Blocks.field_150339_S), 1)));
        recipes.add(new AdvRecipe("Flight", 20, new ItemGroup(new ItemStack(Items.field_151008_G), 8), new ItemGroup(new ItemStack(Blocks.field_150484_ah), 1), new ItemGroup(new ItemStack(Blocks.field_150340_R), 2)));
        recipes.add(new AdvRecipe("Item Repair", 20, new ItemGroup(new ItemStack(Items.field_151045_i), 1), new ItemGroup(new ItemStack(Items.field_151043_k), 1), new ItemGroup(new ItemStack(Blocks.field_150467_bQ), 1)));
        recipes.add(new AdvRecipe("Weapon Cooldown Reduction", 20, new ItemGroup(AdvancedInfuserCraftingManager.generatePotionWithEffect("minecraft:swiftness"), 1), new ItemGroup(new ItemStack((Item)Items.field_179565_cj), 1), new ItemGroup(new ItemStack(Items.field_151016_H), 3)));
        recipes.add(new AdvRecipe("Time Amplification", 2, new ItemGroup(new ItemStack(Items.field_151113_aN), 1)));
    }

    private static boolean doItemStackContentsMatch(int type, ArrayList<ItemStack> list1, ArrayList<ItemStack> list2) {
        int i;
        ArrayList<Item> list1Items = new ArrayList<Item>();
        ArrayList<Item> list2Items = new ArrayList<Item>();
        ArrayList<NBTTagCompound> list1NBT = new ArrayList<NBTTagCompound>();
        ArrayList<NBTTagCompound> list2NBT = new ArrayList<NBTTagCompound>();
        for (i = 0; i < list1.size(); ++i) {
            if (list1.get(i).func_190926_b()) continue;
            list1Items.add(list1.get(i).func_77973_b());
        }
        for (i = 0; i < list2.size(); ++i) {
            list2Items.add(list2.get(i).func_77973_b());
        }
        for (i = 0; i < list1.size(); ++i) {
            if (list1.get(i).func_190926_b()) continue;
            list1NBT.add(list1.get(i).func_77978_p());
        }
        for (i = 0; i < list2.size(); ++i) {
            list2NBT.add(list2.get(i).func_77978_p());
        }
        if (!list1Items.containsAll(list2Items)) {
            return false;
        }
        return list1NBT.containsAll(list2NBT);
    }

    public static Result getOutputFromInputs(int type, int dustInput, TileEntityAdvancedAbilityInfuser te, ItemStack ... inputs) {
        int i;
        int dustCost = 0;
        ArrayList<ItemGroup> itemsUsed = new ArrayList<ItemGroup>();
        ArrayList<ItemStack> listOfStacksInput = new ArrayList<ItemStack>();
        ArrayList<Item> dupeListItems = new ArrayList<Item>();
        ArrayList<NBTTagCompound> dupeListNBT = new ArrayList<NBTTagCompound>();
        ArrayList<String> idsToApply = new ArrayList<String>();
        for (i = 0; i < inputs.length; ++i) {
            if (!inputs[i].func_190926_b()) {
                listOfStacksInput.add(inputs[i]);
            }
            listOfStacksInput.removeAll(Collections.singleton(null));
        }
        for (i = 0; i < listOfStacksInput.size(); ++i) {
            if (dupeListItems.contains(((ItemStack)listOfStacksInput.get(i)).func_77973_b()) && dupeListNBT.contains(((ItemStack)listOfStacksInput.get(i)).func_77978_p()) && !ItemStack.func_179545_c((ItemStack)((ItemStack)listOfStacksInput.get(i)), (ItemStack)new ItemStack(Items.field_151113_aN))) {
                return new Result(ItemStack.field_190927_a, null, 0);
            }
            if (ItemStack.func_179545_c((ItemStack)((ItemStack)listOfStacksInput.get(i)), (ItemStack)new ItemStack(Items.field_151113_aN))) continue;
            dupeListItems.add(((ItemStack)listOfStacksInput.get(i)).func_77973_b());
            dupeListNBT.add(listOfStacksInput.get(i).func_77978_p());
        }
        for (i = 0; i < recipes.size(); ++i) {
            int n;
            int countMatches = 0;
            ArrayList<ItemStack> listOfRecipeStacks = new ArrayList<ItemStack>();
            for (n = 0; n < AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.size(); ++n) {
                listOfRecipeStacks.add(AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).item);
            }
            if (!AdvancedInfuserCraftingManager.doItemStackContentsMatch(type, listOfStacksInput, listOfRecipeStacks)) continue;
            for (n = 0; n < AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.size(); ++n) {
                for (int m = 0; m < listOfStacksInput.size(); ++m) {
                    if (AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).item.func_77973_b() != listOfStacksInput.get(m).func_77973_b() || AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).count > listOfStacksInput.get(m).func_190916_E()) continue;
                    if (AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).item.func_77942_o() && listOfStacksInput.get(m).func_77942_o()) {
                        if (!AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).item.func_77978_p().equals((Object)listOfStacksInput.get(m).func_77978_p())) continue;
                        itemsUsed.add(AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get(n));
                        ++countMatches;
                        continue;
                    }
                    if (AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get((int)n).item.func_77942_o() && listOfRecipeStacks.get(m).func_77942_o()) continue;
                    itemsUsed.add(AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.get(n));
                    ++countMatches;
                }
            }
            if (countMatches == AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.size()) {
                idsToApply.add(AdvancedInfuserCraftingManager.recipes.get((int)i).output);
                dustCost += AdvancedInfuserCraftingManager.recipes.get((int)i).dustCost;
                continue;
            }
            if (countMatches <= AdvancedInfuserCraftingManager.recipes.get((int)i).recipe.size() || AdvancedInfuserCraftingManager.recipes.get((int)i).output != "Time Amplification") continue;
            for (n = 0; n < countMatches; ++n) {
                idsToApply.add(AdvancedInfuserCraftingManager.recipes.get((int)i).output);
                dustCost += AdvancedInfuserCraftingManager.recipes.get((int)i).dustCost;
            }
        }
        dustCost = AdvancedInfuserCraftingManager.curveDustCost(idsToApply, dustCost);
        if (idsToApply.isEmpty()) {
            return new Result(ItemStack.field_190927_a, null, 0);
        }
        if (dustInput < dustCost) {
            return new Result(ItemStack.field_190927_a, null, dustCost);
        }
        if (!ItemStack.func_179545_c((ItemStack)new ItemStack((Item)ModItems.magicalDust), (ItemStack)te.inventory.getStackInSlot(2))) {
            return new Result(ItemStack.field_190927_a, null, dustCost);
        }
        return new Result(AdvancedInfuserCraftingManager.setStoneNBT(idsToApply, false), itemsUsed, dustCost);
    }

    public static ItemStack setStoneNBT(ArrayList idsToApply, boolean jei) {
        int i;
        ItemStack stack = new ItemStack((Item)ModItems.advancedAbilityStone);
        boolean hasRealIds = false;
        int timeOccurrences = Collections.frequency(idsToApply, "Time Amplification");
        for (i = 0; i < idsToApply.size(); ++i) {
            if (idsToApply.get(i) == "Time Amplification") continue;
            hasRealIds = true;
        }
        if (!hasRealIds && !jei) {
            return ItemStack.field_190927_a;
        }
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("Enabled", 0);
        stack.func_77978_p().func_74778_a("UUID", UUID.randomUUID().toString());
        stack.func_77978_p().func_74768_a("Cooldown", 0);
        stack.func_77978_p().func_74768_a("Entime", (int)(System.currentTimeMillis() / 1000L));
        stack.func_77978_p().func_74768_a("Remtime", AbilityStones.defaultTimeInSeconds + AbilityStones.amplificationTimeInSeconds * timeOccurrences);
        stack.func_77978_p().func_74768_a("Deltime", (int)System.currentTimeMillis() / 1000 + stack.func_77978_p().func_74762_e("Remtime"));
        stack.func_77978_p().func_74757_a("RequiresCleanup", false);
        stack.func_77978_p().func_74768_a("TagsSet", 1);
        stack.func_77978_p().func_74780_a("OriginalAttackSpeed", 4.0);
        for (i = 0; i < idsToApply.size(); ++i) {
            if (i == 0) {
                stack.func_77978_p().func_74778_a("eff1", idsToApply.get(0).toString());
            }
            if (i == 1) {
                stack.func_77978_p().func_74778_a("eff2", idsToApply.get(1).toString());
            }
            if (i == 2) {
                stack.func_77978_p().func_74778_a("eff3", idsToApply.get(2).toString());
            }
            if (i != 3) continue;
            stack.func_77978_p().func_74778_a("eff4", idsToApply.get(3).toString());
        }
        return stack;
    }

    public static Result getResult(int type, int dustInput, TileEntityAdvancedAbilityInfuser te, ItemStack ... inputs) {
        return AdvancedInfuserCraftingManager.getOutputFromInputs(type, dustInput, te, inputs);
    }
}

