/*
 * Decompiled with CFR 0.152.
 */
package clayborn.universalremote.items;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemNBTEnergyStorage
implements IEnergyStorage {
    protected ItemStack m_stack;
    protected int m_capacity;
    protected int m_maxReceive;
    protected int m_maxExtract;

    public ItemNBTEnergyStorage(ItemStack stack, int capacity) {
        this(stack, capacity, capacity, capacity);
    }

    public ItemNBTEnergyStorage(ItemStack stack, int capacity, int maxTransfer) {
        this(stack, capacity, maxTransfer, maxTransfer);
    }

    public ItemNBTEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        this.m_stack = stack;
        if (!this.m_stack.func_77942_o()) {
            this.m_stack.func_77982_d(new NBTTagCompound());
        }
        this.m_capacity = capacity;
        this.m_maxReceive = maxReceive;
        this.m_maxExtract = maxExtract;
    }

    public int receiveEnergy(int receiveAmount, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int realAmount = Math.min(this.m_maxReceive, receiveAmount);
        return this.limitlessReceiveEnergy(realAmount, simulate);
    }

    public int limitlessReceiveEnergy(int receiveAmount, boolean simulate) {
        int realAmount = Math.max(0, receiveAmount);
        int energy = Math.max(this.getEnergyStored(), 0);
        int energyReceived = Math.min(this.m_capacity - energy, realAmount);
        if (!simulate) {
            this.setEnergyStored(energy + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int extractAmount, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int realAmount = Math.min(this.m_maxExtract, extractAmount);
        return this.limitlessExtractEnergy(realAmount, simulate);
    }

    public int limitlessExtractEnergy(int extractAmount, boolean simulate) {
        int realAmount = Math.max(0, extractAmount);
        int energy = Math.max(this.getEnergyStored(), 0);
        int energytoExtract = Math.min(energy, realAmount);
        if (!simulate) {
            this.setEnergyStored(energy - energytoExtract);
        }
        return energytoExtract;
    }

    public int getEnergyStored() {
        return this.m_stack.func_77978_p().func_74762_e("energy");
    }

    public void setEnergyStored(int energy) {
        energy = Math.max(energy, 0);
        this.m_stack.func_77978_p().func_74768_a("energy", energy);
    }

    public int getMaxEnergyStored() {
        return this.m_capacity;
    }

    public boolean canExtract() {
        return this.m_maxExtract > 0;
    }

    public boolean canReceive() {
        return this.m_maxReceive > 0;
    }
}

