/*
 * Decompiled with CFR 0.152.
 */
package clayborn.universalremote.items;

import clayborn.universalremote.creative.UniversalRemoteTab;
import clayborn.universalremote.entity.EntityPlayerProxy;
import clayborn.universalremote.inventory.ContainerProxy;
import clayborn.universalremote.items.ItemEnergyBase;
import clayborn.universalremote.items.ItemNBTEnergyStorage;
import clayborn.universalremote.items.ItemRegistry;
import clayborn.universalremote.util.CapabilityHelper;
import clayborn.universalremote.util.TextFormatter;
import clayborn.universalremote.util.Util;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.energy.CapabilityEnergy;
import org.lwjgl.input.Keyboard;

public class ItemUniversalRemote
extends ItemEnergyBase {
    public static final int energyCapacity = 100000;
    public static final int energyReceiveRate = 1000;
    public static final int energyCostPerBlock = 10;
    public static final int energyCostMax = 1000;
    public static final int energyCostBindBlock = 100;
    public static final String[] m_proxyExceptionsList = new String[]{"com.raoulvdberge.refinedstorage", "appeng"};
    boolean m_publishSubTypes;
    static final NBTTagInt m_intTagType = new NBTTagInt(0);
    static final NBTTagString m_stringTagType = new NBTTagString("");
    static final NBTTagIntArray m_intArrayTagType = new NBTTagIntArray(new int[0]);
    static final NBTTagFloat m_floatTagType = new NBTTagFloat(0.0f);
    static final NBTTagDouble m_doubleTagType = new NBTTagDouble(0.0);

    public ItemUniversalRemote(String name, boolean publishSubTypes) {
        super(100000, 1000, 0, name, null);
        this.m_publishSubTypes = publishSubTypes;
        if (this.m_publishSubTypes) {
            this.func_77627_a(true);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.m_publishSubTypes && tab == UniversalRemoteTab.INSTANCE) {
            ItemStack stack = new ItemStack((Item)ItemRegistry.Items().UniveralRemote);
            NBTTagCompound tag = null;
            tag = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
            tag.func_74768_a("energy", 0);
            stack.func_77982_d(tag);
            items.add((Object)stack);
            stack = new ItemStack((Item)ItemRegistry.Items().UniveralRemote);
            tag = null;
            tag = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
            tag.func_74768_a("energy", 100000);
            stack.func_77982_d(tag);
            items.add((Object)stack);
        }
    }

    @Override
    public void register(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_bound", "inventory"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                ItemStack stack = Util.playerAndHandToItemStack(player, hand);
                ItemNBTEnergyStorage storage = (ItemNBTEnergyStorage)CapabilityHelper.tryGetCapability(stack, CapabilityEnergy.ENERGY, null);
                int amount = storage.limitlessExtractEnergy(100, true);
                if (amount >= 100) {
                    storage.limitlessExtractEnergy(100, false);
                    NBTTagCompound tag = null;
                    tag = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
                    tag.func_74768_a("remote.dimension.id", player.field_71093_bK);
                    String dimName = DimensionManager.getProvider((int)player.field_71093_bK).func_186058_p().func_186065_b().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2").replace("_", " ").trim();
                    CharSequence[] dimNameWords = dimName.split(" ");
                    for (int i = 0; i < dimNameWords.length; ++i) {
                        if (dimNameWords[i].length() <= 1) continue;
                        dimNameWords[i] = ((String)dimNameWords[i]).substring(0, 1).toUpperCase() + ((String)dimNameWords[i]).substring(1);
                    }
                    String formattedDimName = String.join((CharSequence)" ", dimNameWords);
                    tag.func_74778_a("remote.dimension.name", formattedDimName);
                    int[] blockPosition = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
                    tag.func_74783_a("remote.blockposition", blockPosition);
                    tag.func_74778_a("remote.block.name", worldIn.func_180495_p(pos).func_177230_c().getClass().getName());
                    tag.func_74778_a("remote.hand", hand.toString());
                    tag.func_74778_a("remote.facing", facing.toString());
                    tag.func_74776_a("remote.hit.X", hitX);
                    tag.func_74776_a("remote.hit.Y", hitY);
                    tag.func_74776_a("remote.hit.Z", hitZ);
                    tag.func_74780_a("remote.player.position.X", player.field_70165_t);
                    tag.func_74780_a("remote.player.position.Y", player.field_70163_u);
                    tag.func_74780_a("remote.player.position.Z", player.field_70161_v);
                    if (stack.func_77977_a().equals(ItemRegistry.Items().UniveralRemote.func_77658_a())) {
                        stack = new ItemStack((Item)ItemRegistry.Items().UniveralRemote, 1, 1);
                        Util.setPlayerItemStackInHand(stack, player, hand);
                    }
                    stack.func_77982_d(tag);
                    player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.bound", TextFormatting.DARK_GREEN));
                } else {
                    player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.notenoughpower", TextFormatting.DARK_RED));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean validateNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_150297_b("remote.dimension.id", (int)m_intTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.dimension.name", (int)m_stringTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.block.name", (int)m_stringTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.blockposition", (int)m_intArrayTagType.func_74732_a())) {
            return false;
        }
        if (tag.func_74759_k("remote.blockposition").length != 3) {
            return false;
        }
        if (!tag.func_150297_b("remote.hand", (int)m_stringTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.facing", (int)m_stringTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.hit.X", (int)m_floatTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.hit.Y", (int)m_floatTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.hit.Z", (int)m_floatTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.player.position.X", (int)m_doubleTagType.func_74732_a())) {
            return false;
        }
        if (!tag.func_150297_b("remote.player.position.Y", (int)m_doubleTagType.func_74732_a())) {
            return false;
        }
        return tag.func_150297_b("remote.player.position.Z", (int)m_doubleTagType.func_74732_a());
    }

    @Override
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String tip = null;
        if (this.validateNBT(stack)) {
            NBTTagCompound tag = stack.func_77978_p();
            String dimName = tag.func_74779_i("remote.dimension.name");
            int[] blockPosition = tag.func_74759_k("remote.blockposition");
            tip = TextFormatter.style(TextFormatting.GRAY, dimName + " (" + blockPosition[0] + ", " + blockPosition[1] + ", " + blockPosition[2] + ")").func_150254_d();
        } else {
            tip = TextFormatter.translateAndStyle(TextFormatting.DARK_RED, true, "universalremote.strings.unbound").func_150254_d();
        }
        tooltip.add(tip);
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatter.translateAndStyle(TextFormatting.DARK_GRAY, true, "universalremote.strings.showmore").func_150254_d());
        } else {
            tooltip.add(TextFormatter.translateAndStyle("universalremote.strings.instructionsOne", TextFormatting.GRAY).func_150254_d());
            tooltip.add(TextFormatter.translateAndStyle("universalremote.strings.instructionsTwo", TextFormatting.GRAY).func_150254_d());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = Util.playerAndHandToItemStack(player, handIn);
            if (!this.validateNBT(stack)) {
                player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.notbounderror", TextFormatting.DARK_RED));
                return super.func_77659_a(worldIn, player, handIn);
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (stack.func_77977_a().equals(ItemRegistry.Items().UniveralRemote.func_77658_a())) {
                stack = new ItemStack((Item)ItemRegistry.Items().UniveralRemote, 1, 1);
                stack.func_77982_d(tag);
                Util.setPlayerItemStackInHand(stack, player, handIn);
            }
            int dim = tag.func_74762_e("remote.dimension.id");
            int[] blockPositionArray = tag.func_74759_k("remote.blockposition");
            String blockName = tag.func_74779_i("remote.block.name");
            BlockPos blockPosition = new BlockPos(blockPositionArray[0], blockPositionArray[1], blockPositionArray[2]);
            EnumHand hand = EnumHand.valueOf((String)tag.func_74779_i("remote.hand"));
            EnumFacing facing = EnumFacing.func_176739_a((String)tag.func_74779_i("remote.facing"));
            float hitX = tag.func_74760_g("remote.hit.X");
            float hitY = tag.func_74760_g("remote.hit.Y");
            float hitZ = tag.func_74760_g("remote.hit.Z");
            double posX = tag.func_74760_g("remote.player.position.X");
            double posY = tag.func_74760_g("remote.player.position.Y");
            double posZ = tag.func_74760_g("remote.player.position.Z");
            int energyCost = 0;
            World world = null;
            if (player.field_71093_bK == dim) {
                world = worldIn;
                energyCost = Math.min(1000, (int)(Math.sqrt(player.func_174818_b(blockPosition)) * 10.0));
            }
            if (world != null) {
                Chunk chunk = world.func_175726_f(blockPosition);
                if (chunk.func_177410_o()) {
                    IBlockState state = world.func_180495_p(blockPosition);
                    String test = state.func_177230_c().getClass().getName();
                    if (player.field_71093_bK == dim) {
                        if (test.equals(blockName)) {
                            ItemNBTEnergyStorage storage = (ItemNBTEnergyStorage)CapabilityHelper.tryGetCapability(stack, CapabilityEnergy.ENERGY, null);
                            int amount = storage.limitlessExtractEnergy(energyCost, true);
                            if (amount >= energyCost) {
                                storage.limitlessExtractEnergy(energyCost, false);
                                if (!test.startsWith("net.minecraft") && player.field_71093_bK == dim) {
                                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChunkData(chunk, 65535));
                                }
                                Container oldContainer = player.field_71070_bA;
                                World oldWorld = player.field_70170_p;
                                player.field_70170_p = world;
                                state.func_177230_c().func_180639_a(world, blockPosition, state, player, hand, facing, hitX, hitY, hitZ);
                                player.field_70170_p = oldWorld;
                                if (player.field_71070_bA != oldContainer && !Util.doesStringStartWithAnyInArray(m_proxyExceptionsList, player.field_71070_bA.getClass().getName())) {
                                    player.field_71070_bA = new ContainerProxy(player.field_71070_bA, new EntityPlayerProxy(player, posX, posY, posZ));
                                }
                            } else {
                                player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.notenoughpower", TextFormatting.DARK_RED));
                            }
                        } else {
                            player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.blockchanged", TextFormatting.DARK_RED));
                        }
                    } else {
                        player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.vanillasinglecrossdimerror", TextFormatting.DARK_RED));
                    }
                } else {
                    player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.boundnotloaded", TextFormatting.DARK_RED));
                }
            } else {
                player.func_145747_a(TextFormatter.translateAndStyle("universalremote.strings.crossdimerror", TextFormatting.DARK_RED));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
    }
}

