/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.jackhuang.metro.FocusPainter;
import org.jackhuang.metro.FocusPainter$FocusComponent$1;
import org.jackhuang.metro.MetroGraphicsUtils;

class FocusPainter$FocusComponent
extends JComponent {
    private Component currentlyFocusedComponent = null;
    private WeakReference<JComponent> lastFocusedComponent = new WeakReference<Object>(null);
    private BufferedImage lastFocusImage = null;
    private Dimension lastSize = null;
    BufferedImage testImage;

    public FocusPainter$FocusComponent(JLayeredPane jLayeredPane) {
        this.setBounds(0, 0, jLayeredPane.getWidth(), jLayeredPane.getHeight());
        jLayeredPane.addComponentListener(new FocusPainter$FocusComponent$1(this, jLayeredPane));
    }

    public void setCurrentlyFocusedComponent(Component component) {
        this.currentlyFocusedComponent = component;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.currentlyFocusedComponent != null && this.currentlyFocusedComponent instanceof JComponent) {
            BufferedImage bufferedImage;
            JComponent jComponent = (JComponent)this.currentlyFocusedComponent;
            Rectangle rectangle = new Rectangle(0, 0, jComponent.getSize().width, jComponent.getSize().height);
            Dimension dimension = jComponent.getSize();
            if (jComponent == this.lastFocusedComponent.get() && dimension.equals(this.lastSize)) {
                bufferedImage = this.lastFocusImage;
            } else {
                this.lastFocusImage = bufferedImage = this.createFocusGlow(rectangle, jComponent, graphics);
                this.lastSize = dimension;
                this.lastFocusedComponent = new WeakReference<JComponent>(jComponent);
            }
            Rectangle rectangle2 = jComponent.getVisibleRect();
            if (rectangle2.width == rectangle.width) {
                rectangle2.width += 9;
            }
            if (rectangle2.height == rectangle.height) {
                rectangle2.height += 9;
            }
            if (rectangle2.x == rectangle.x) {
                rectangle2.x -= 9;
                rectangle2.width += 9;
            }
            if (rectangle2.y == rectangle.y) {
                rectangle2.y -= 9;
                rectangle2.height += 9;
            }
            graphics = graphics.create();
            Rectangle rectangle3 = SwingUtilities.convertRectangle(jComponent, rectangle2, this);
            graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle = SwingUtilities.convertRectangle(jComponent, rectangle, this);
            graphics.drawImage(bufferedImage, rectangle.x - 9 - 9, rectangle.y - 9 - 9, null);
            graphics.dispose();
        }
    }

    private BufferedImage createFocusGlow(Rectangle rectangle, JComponent jComponent, Graphics graphics) {
        Object object;
        BufferedImage bufferedImage = MetroGraphicsUtils.createCompatibleTranslucentImage(rectangle.width + 9 + 9, rectangle.height + 9 + 9);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Graphics graphics2 = graphics2D.create(9, 9, rectangle.width, rectangle.height);
        graphics2.setColor(Color.BLACK);
        if (jComponent instanceof JRadioButton || jComponent instanceof JCheckBox) {
            object = jComponent.getForeground();
            jComponent.setForeground(new Color(0, 0, 0, 0));
            jComponent.paint(graphics2);
            jComponent.setForeground((Color)object);
        } else if (jComponent instanceof JTabbedPane) {
            object = (JTabbedPane)jComponent;
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)((JTabbedPane)object).getUI();
            Rectangle rectangle2 = basicTabbedPaneUI.getTabBounds((JTabbedPane)object, ((JTabbedPane)object).getSelectedIndex());
            graphics2.fillRoundRect(rectangle2.x + 4, rectangle2.y, rectangle2.width - 7, rectangle2.height, 5, 5);
        } else if (jComponent instanceof JSlider) {
            object = (JSlider)jComponent;
            BasicSliderUI basicSliderUI = (BasicSliderUI)((JSlider)object).getUI();
            try {
                Field field = BasicSliderUI.class.getDeclaredField("thumbRect");
                field.setAccessible(true);
                Rectangle rectangle3 = (Rectangle)field.get(basicSliderUI);
                graphics2.fillOval(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            }
        } else if (jComponent instanceof JButton || jComponent instanceof JToggleButton) {
            jComponent.paint(graphics2);
        } else {
            graphics2.setColor(Color.BLACK);
            graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        graphics2.dispose();
        graphics2D.dispose();
        object = this.createFocusedImage(bufferedImage);
        return object;
    }

    private BufferedImage createFocusedImage(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getWidth() + 18;
        int n3 = bufferedImage.getHeight() + 18;
        BufferedImage bufferedImage2 = MetroGraphicsUtils.getAlphaMask(bufferedImage, n2, n3);
        BufferedImage bufferedImage3 = new BufferedImage(n2, n3, 10);
        BufferedImage bufferedImage4 = new BufferedImage(n2, n3, 10);
        Kernel[] kernelArray = MetroGraphicsUtils.getSeparateGaussianKernel(1);
        new ConvolveOp(kernelArray[0]).filter(bufferedImage2, bufferedImage3);
        new ConvolveOp(kernelArray[1]).filter(bufferedImage3, bufferedImage4);
        Kernel[] kernelArray2 = MetroGraphicsUtils.getSeparateGaussianKernel(9);
        new ConvolveOp(kernelArray2[0]).filter(bufferedImage2, bufferedImage3);
        new ConvolveOp(kernelArray2[1]).filter(bufferedImage3, bufferedImage2);
        byte[] byArray = ((DataBufferByte)bufferedImage4.getRaster().getDataBuffer()).getData();
        byte[] byArray2 = ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = byArray[i2] == 0 ? (byte)((double)byArray2[i2] * 0.6) : (byte)0;
        }
        RescaleOp rescaleOp = new RescaleOp(6.6666665f, 0.0f, null);
        rescaleOp.filter(bufferedImage2, bufferedImage2);
        BufferedImage bufferedImage5 = MetroGraphicsUtils.createCompatibleTranslucentImage(n2, n3);
        Graphics2D graphics2D = bufferedImage5.createGraphics();
        graphics2D.drawImage((Image)MetroGraphicsUtils.createColorMaskImage(bufferedImage2, FocusPainter.access$000()), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage5;
    }
}

