/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro.painters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jackhuang.metro.MetroGraphicsUtils;
import org.jackhuang.metro.components.ConstomButton;
import org.jackhuang.metro.painters.ButtonPainter$1;

public class ButtonPainter
extends SynthPainter {
    private static final String DEFAULT_NORMAL = "D5D5D5";
    private static final Color[] DEFAULT_NORMAL_BG = new Color[]{MetroGraphicsUtils.getWebColor("D5D5D5"), MetroGraphicsUtils.getWebColor("D5D5D5")};
    private static final Color[] DEFAULT_NORMAL_FG = new Color[]{MetroGraphicsUtils.getWebColor("D5D5D5"), MetroGraphicsUtils.getWebColor("D5D5D5")};
    private static final String DEFAULT_PRELIGHT = "A9A9A9";
    private static final Color[] DEFAULT_PRELIGHT_BG = new Color[]{MetroGraphicsUtils.getWebColor("A9A9A9"), MetroGraphicsUtils.getWebColor("A9A9A9")};
    private static final Color[] DEFAULT_PRELIGHT_FG = new Color[]{MetroGraphicsUtils.getWebColor("A9A9A9"), MetroGraphicsUtils.getWebColor("A9A9A9")};
    private static final String DEFAULT_ACTIVE = "222222";
    private static final Color[] DEFAULT_ACTIVE_BG = new Color[]{MetroGraphicsUtils.getWebColor("222222"), MetroGraphicsUtils.getWebColor("222222")};
    private static final Color[] DEFAULT_ACTIVE_FG = new Color[]{MetroGraphicsUtils.getWebColor("222222"), MetroGraphicsUtils.getWebColor("222222")};
    private static final Color[] DISABLED_BG = new Color[]{MetroGraphicsUtils.getWebColor("E3EFE9"), MetroGraphicsUtils.getMidWebColor("E3EFE9", "DFE2E6"), MetroGraphicsUtils.getWebColor("DFE2E6"), MetroGraphicsUtils.getMidWebColor("DFE2E6", "D6D9DF"), MetroGraphicsUtils.getWebColor("D6D9DF"), MetroGraphicsUtils.getWebColor("D6D9DF"), MetroGraphicsUtils.getMidWebColor("D6D9DF", "D8DBE1"), MetroGraphicsUtils.getWebColor("D8DBE1"), MetroGraphicsUtils.getWebColor("DADDE3")};
    private static final Color[] DISABLED_FG = new Color[]{MetroGraphicsUtils.getWebColor("C9CCD2"), MetroGraphicsUtils.getWebColor("C9CCD2"), MetroGraphicsUtils.getWebColor("BCBFC5"), MetroGraphicsUtils.getWebColor("BCBFC5")};

    private static boolean processCustomButton(ConstomButton constomButton, int n2) {
        if (System.currentTimeMillis() > constomButton.lastDrawTime) {
            constomButton.lastDrawTime = System.currentTimeMillis();
            constomButton.drawPercent += n2;
            if (constomButton.drawPercent > 100 && n2 > 0) {
                constomButton.drawPercent = 100;
            } else if (constomButton.drawPercent < 0 && n2 < 0) {
                constomButton.drawPercent = 0;
            } else {
                SwingUtilities.invokeLater(new ButtonPainter$1(constomButton));
            }
        }
        return true;
    }

    @Override
    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Serializable serializable;
        Serializable serializable2;
        Color[] colorArray;
        Color[] colorArray2;
        ConstomButton constomButton;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if ((synthContext.getComponentState() & 0x400) != 0) {
            if ((synthContext.getComponentState() & 4) != 0) {
                if (synthContext.getComponent() instanceof ConstomButton) {
                    constomButton = (ConstomButton)synthContext.getComponent();
                    colorArray2 = new Color[]{constomButton.activeFg, constomButton.activeFg};
                    colorArray = new Color[]{constomButton.activeFg, constomButton.activeFg};
                } else {
                    colorArray2 = DEFAULT_ACTIVE_FG;
                    colorArray = DEFAULT_ACTIVE_FG;
                }
            } else {
                if ((synthContext.getComponentState() & 8) != 0) {
                    return;
                }
                if ((synthContext.getComponentState() & 2) != 0) {
                    if (synthContext.getComponent() instanceof ConstomButton) {
                        constomButton = (ConstomButton)synthContext.getComponent();
                        if (!ButtonPainter.processCustomButton(constomButton, 1)) {
                            return;
                        }
                        serializable2 = MetroGraphicsUtils.getMidWebColor(constomButton.normalFg, constomButton.prelightFg, constomButton.drawPercent);
                        serializable = MetroGraphicsUtils.getMidWebColor(constomButton.normalBg, constomButton.prelightBg, constomButton.drawPercent);
                        colorArray2 = new Color[]{serializable2, serializable2};
                        colorArray = new Color[]{serializable, serializable};
                    } else {
                        colorArray2 = DEFAULT_PRELIGHT_FG;
                        colorArray = DEFAULT_PRELIGHT_FG;
                    }
                } else if (synthContext.getComponent() instanceof ConstomButton) {
                    constomButton = (ConstomButton)synthContext.getComponent();
                    if (!ButtonPainter.processCustomButton(constomButton, -1)) {
                        return;
                    }
                    serializable2 = MetroGraphicsUtils.getMidWebColor(constomButton.normalFg, constomButton.prelightFg, constomButton.drawPercent);
                    serializable = MetroGraphicsUtils.getMidWebColor(constomButton.normalBg, constomButton.prelightBg, constomButton.drawPercent);
                    colorArray2 = new Color[]{serializable2, serializable2};
                    colorArray = new Color[]{serializable, serializable};
                } else {
                    colorArray2 = DEFAULT_NORMAL_FG;
                    colorArray = DEFAULT_NORMAL_FG;
                }
            }
        } else if ((synthContext.getComponentState() & 4) != 0) {
            if (synthContext.getComponent() instanceof ConstomButton) {
                constomButton = (ConstomButton)synthContext.getComponent();
                colorArray2 = new Color[]{constomButton.activeFg, constomButton.activeFg};
                colorArray = new Color[]{constomButton.activeFg, constomButton.activeFg};
            } else {
                colorArray2 = DEFAULT_ACTIVE_FG;
                colorArray = DEFAULT_ACTIVE_FG;
            }
        } else {
            if ((synthContext.getComponentState() & 8) != 0) {
                return;
            }
            if ((synthContext.getComponentState() & 2) != 0) {
                if (synthContext.getComponent() instanceof ConstomButton) {
                    constomButton = (ConstomButton)synthContext.getComponent();
                    if (!ButtonPainter.processCustomButton(constomButton, 1)) {
                        return;
                    }
                    serializable2 = MetroGraphicsUtils.getMidWebColor(constomButton.normalFg, constomButton.prelightFg, constomButton.drawPercent);
                    serializable = MetroGraphicsUtils.getMidWebColor(constomButton.normalBg, constomButton.prelightBg, constomButton.drawPercent);
                    colorArray2 = new Color[]{serializable2, serializable2};
                    colorArray = new Color[]{serializable, serializable};
                } else if (synthContext.getComponent() instanceof ConstomButton) {
                    constomButton = (ConstomButton)synthContext.getComponent();
                    colorArray2 = new Color[]{constomButton.prelightFg, constomButton.prelightFg};
                    colorArray = new Color[]{constomButton.prelightBg, constomButton.prelightBg};
                } else {
                    colorArray2 = DEFAULT_PRELIGHT_FG;
                    colorArray = DEFAULT_PRELIGHT_FG;
                }
            } else if (synthContext.getComponent() instanceof ConstomButton) {
                constomButton = (ConstomButton)synthContext.getComponent();
                if (!ButtonPainter.processCustomButton(constomButton, -1)) {
                    return;
                }
                serializable2 = MetroGraphicsUtils.getMidWebColor(constomButton.normalFg, constomButton.prelightFg, constomButton.drawPercent);
                serializable = MetroGraphicsUtils.getMidWebColor(constomButton.normalBg, constomButton.prelightBg, constomButton.drawPercent);
                colorArray2 = new Color[]{serializable2, serializable2};
                colorArray = new Color[]{serializable, serializable};
            } else {
                colorArray2 = DEFAULT_NORMAL_FG;
                colorArray = DEFAULT_NORMAL_FG;
            }
        }
        int n6 = synthContext.getComponent() instanceof ConstomButton ? ((ConstomButton)synthContext.getComponent()).radix : 0;
        graphics2D.setColor(colorArray2[0]);
        serializable2 = new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n6);
        graphics2D.draw((Shape)((Object)serializable2));
        graphics2D.setColor(colorArray[0]);
        serializable = new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n6);
        graphics2D.fill((Shape)((Object)serializable));
    }

    @Override
    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Color[] colorArray;
        Color[] colorArray2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if ((synthContext.getComponentState() & 0x400) != 0) {
            if ((synthContext.getComponentState() & 4) != 0 || (synthContext.getComponentState() & 0x200) != 0) {
                colorArray2 = DEFAULT_ACTIVE_FG;
                colorArray = DEFAULT_ACTIVE_FG;
            } else if ((synthContext.getComponentState() & 8) != 0) {
                colorArray2 = DISABLED_FG;
                colorArray = DISABLED_BG;
            } else if ((synthContext.getComponentState() & 2) != 0) {
                colorArray2 = DEFAULT_PRELIGHT_FG;
                colorArray = DEFAULT_PRELIGHT_FG;
            } else {
                colorArray2 = DEFAULT_NORMAL_FG;
                colorArray = DEFAULT_NORMAL_FG;
            }
        } else if ((synthContext.getComponentState() & 4) != 0 || (synthContext.getComponentState() & 0x200) != 0) {
            colorArray2 = DEFAULT_ACTIVE_FG;
            colorArray = DEFAULT_ACTIVE_FG;
        } else if ((synthContext.getComponentState() & 8) != 0) {
            colorArray2 = DISABLED_FG;
            colorArray = DISABLED_BG;
        } else if ((synthContext.getComponentState() & 2) != 0) {
            colorArray2 = DEFAULT_PRELIGHT_FG;
            colorArray = DEFAULT_PRELIGHT_FG;
        } else {
            colorArray2 = DEFAULT_NORMAL_FG;
            colorArray = DEFAULT_NORMAL_FG;
        }
        graphics2D.setColor(colorArray2[0]);
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3, n4, n5);
        graphics2D.draw(float_);
        graphics2D.setColor(colorArray[0]);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(n2, n3, n4, n5);
        graphics2D.fill(float_2);
    }
}

