/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jackhuang.metro.MetroGraphicsUtils;
import org.jackhuang.metro.ui.ComboBoxUI$1;
import org.jackhuang.metro.ui.ComboBoxUI$ComboLayout;

public class ComboBoxUI
extends BasicComboBoxUI
implements MouseListener {
    private static final BufferedImage combo_normal = MetroGraphicsUtils.loadImage("combo_normal.png");
    private static final BufferedImage combo_over = MetroGraphicsUtils.loadImage("combo_over.png");
    private static final BufferedImage combo_pressed = MetroGraphicsUtils.loadImage("combo_pressed.png");
    private static final BufferedImage combo_disabled = MetroGraphicsUtils.loadImage("combo_disabled.png");
    private static final BufferedImage combo_edit_btn = MetroGraphicsUtils.loadImage("combo_edit_btn.png");
    private static final BufferedImage combo_edit_btn_over = MetroGraphicsUtils.loadImage("combo_edit_btn_over.png");
    private static final BufferedImage combo_edit_btn_pressed = MetroGraphicsUtils.loadImage("combo_edit_btn_pressed.png");
    private static Dimension BTN_SIZE = new Dimension(17, 20);
    private Dimension btnSize = new Dimension(BTN_SIZE);
    private boolean mouseInside = false;
    private boolean mouseDown = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        this.btnSize.height = dimension.height = Math.max(dimension.height, ComboBoxUI.BTN_SIZE.height);
        this.btnSize.width = (int)((double)ComboBoxUI.BTN_SIZE.width / (double)ComboBoxUI.BTN_SIZE.height * (double)this.btnSize.height);
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right + this.btnSize.width;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    @Override
    protected JButton createArrowButton() {
        ComboBoxUI$1 comboBoxUI$1 = new ComboBoxUI$1(this);
        comboBoxUI$1.addMouseListener(this);
        comboBoxUI$1.setMinimumSize(BTN_SIZE);
        comboBoxUI$1.setPreferredSize(BTN_SIZE);
        comboBoxUI$1.setMargin(new Insets(0, 0, 0, 0));
        return comboBoxUI$1;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        Rectangle rectangle = new Rectangle(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight());
        this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
        if (!this.comboBox.isEditable()) {
            if (listCellRenderer instanceof JComponent) {
                ((JComponent)((Object)listCellRenderer)).setOpaque(false);
                ((JComponent)((Object)listCellRenderer)).setForeground(this.comboBox.getForeground());
            }
            this.paintCurrentValue(graphics, this.rectangleForCurrentValue(), false);
            if (listCellRenderer instanceof JComponent) {
                ((JComponent)((Object)listCellRenderer)).setOpaque(true);
            }
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl2) {
        if (!this.comboBox.isEditable()) {
            BufferedImage bufferedImage = combo_normal;
            if (!this.comboBox.isEnabled()) {
                bufferedImage = combo_disabled;
            } else if (this.mouseDown) {
                bufferedImage = combo_pressed;
            } else if (this.mouseInside) {
                bufferedImage = combo_over;
            }
            graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.x + 4, rectangle.y + rectangle.height, 0, 0, 1, 26, this.comboBox);
            graphics.drawImage(bufferedImage, rectangle.x + 1, rectangle.y, rectangle.x + rectangle.width - 25, rectangle.y + rectangle.height, 1, 0, 3, 26, this.comboBox);
            graphics.drawImage(bufferedImage, rectangle.x + rectangle.width - 25, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 4, 0, 29, 26, this.comboBox);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new ComboBoxUI$ComboLayout(this, null);
    }

    @Override
    protected Insets getInsets() {
        return new Insets(0, 5, 0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            if (mouseEvent.getComponent() == this.arrowButton) {
                this.mouseInside = true;
            }
        } else {
            this.mouseInside = true;
            this.comboBox.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            if (mouseEvent.getComponent() == this.arrowButton) {
                this.mouseInside = false;
            }
        } else {
            this.mouseInside = false;
            this.comboBox.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            if (mouseEvent.getComponent() == this.arrowButton) {
                this.mouseDown = true;
            }
        } else {
            this.mouseDown = true;
            this.comboBox.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            if (mouseEvent.getComponent() == this.arrowButton) {
                this.mouseDown = false;
            }
        } else {
            this.mouseDown = false;
            this.comboBox.repaint();
        }
    }

    static /* synthetic */ JComboBox access$000(ComboBoxUI comboBoxUI) {
        return comboBoxUI.comboBox;
    }

    static /* synthetic */ BufferedImage access$100() {
        return combo_edit_btn;
    }

    static /* synthetic */ boolean access$200(ComboBoxUI comboBoxUI) {
        return comboBoxUI.mouseDown;
    }

    static /* synthetic */ BufferedImage access$300() {
        return combo_edit_btn_pressed;
    }

    static /* synthetic */ JComboBox access$400(ComboBoxUI comboBoxUI) {
        return comboBoxUI.comboBox;
    }

    static /* synthetic */ boolean access$500(ComboBoxUI comboBoxUI) {
        return comboBoxUI.mouseInside;
    }

    static /* synthetic */ BufferedImage access$600() {
        return combo_edit_btn_over;
    }

    static /* synthetic */ JComboBox access$700(ComboBoxUI comboBoxUI) {
        return comboBoxUI.comboBox;
    }

    static /* synthetic */ JButton access$900(ComboBoxUI comboBoxUI) {
        return comboBoxUI.arrowButton;
    }

    static /* synthetic */ Dimension access$1000(ComboBoxUI comboBoxUI) {
        return comboBoxUI.btnSize;
    }

    static /* synthetic */ JButton access$1100(ComboBoxUI comboBoxUI) {
        return comboBoxUI.arrowButton;
    }

    static /* synthetic */ JButton access$1200(ComboBoxUI comboBoxUI) {
        return comboBoxUI.arrowButton;
    }

    static /* synthetic */ Component access$1300(ComboBoxUI comboBoxUI) {
        return comboBoxUI.editor;
    }

    static /* synthetic */ Rectangle access$1400(ComboBoxUI comboBoxUI) {
        return comboBoxUI.rectangleForCurrentValue();
    }

    static /* synthetic */ Component access$1500(ComboBoxUI comboBoxUI) {
        return comboBoxUI.editor;
    }
}

